/*
 * Decompiled with CFR 0.152.
 */
package org.primal.registry;

import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BannerPattern;

public class Primal_BannerPatterns {
    public static final ResourceKey<BannerPattern> PAW = Primal_BannerPatterns.create("paw");
    public static final ResourceKey<BannerPattern> JAWS = Primal_BannerPatterns.create("jaws");
    public static final ResourceKey<BannerPattern> MARSH = Primal_BannerPatterns.create("marsh");
    public static final ResourceKey<BannerPattern> EYRIE = Primal_BannerPatterns.create("eyrie");
    public static final List<ResourceKey<BannerPattern>> Banner_Patterns = List.of(PAW, JAWS, MARSH, EYRIE);

    public static void bootstrap(BootstrapContext<BannerPattern> context) {
        Primal_BannerPatterns.register(context, PAW);
        Primal_BannerPatterns.register(context, JAWS);
        Primal_BannerPatterns.register(context, MARSH);
        Primal_BannerPatterns.register(context, EYRIE);
    }

    private static ResourceKey<BannerPattern> create(String name) {
        return ResourceKey.create((ResourceKey)Registries.BANNER_PATTERN, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"primal", (String)name));
    }

    public static void register(BootstrapContext<BannerPattern> context, ResourceKey<BannerPattern> resourceKey) {
        context.register(resourceKey, (Object)new BannerPattern(resourceKey.location(), "block.minecraft.banner." + resourceKey.location().toShortLanguageKey()));
    }
}

