/*
 * Decompiled with CFR 0.152.
 */
package org.primal.registry;

import com.mojang.serialization.Codec;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.primal.Primal_Registries;
import org.primal.block.SeashellsBlock;
import org.primal.registry.Primal_Blocks;
import org.primal.worldgen.EagleNestFeature;
import org.primal.worldgen.RandomPatchCustomConfig;
import org.primal.worldgen.RiverReedsFeature;
import org.primal.worldgen.SeashellsFeature;

public class Primal_WorldGen {
    public static final ResourceKey<PlacedFeature> RIVER_REEDS_PLACED = Primal_WorldGen.registerPlacedFeatureKey("river_reeds");
    public static ResourceKey<ConfiguredFeature<?, ?>> RIVER_REEDS_CONFIGURED = Primal_WorldGen.registerKey("river_reeds_patch");
    public static final ResourceKey<PlacedFeature> SEASHELLS_PLACED = Primal_WorldGen.registerPlacedFeatureKey("seashells");
    public static ResourceKey<ConfiguredFeature<?, ?>> SEASHELLS_CONFIGURED = Primal_WorldGen.registerKey("seashells_patch");
    public static final ResourceKey<PlacedFeature> EAGLES_NEST_SPAWN = Primal_WorldGen.registerPlacedFeatureKey("eagle_nest");
    public static ResourceKey<ConfiguredFeature<?, ?>> EAGLES_NEST_SPAWN_CONFIGURED = Primal_WorldGen.registerKey("eagle_nest_spawn");
    public static DeferredHolder<Feature<?>, RiverReedsFeature> RIVER_REEDS_FEATURE = Primal_WorldGen.registerFeature("river_reeds", () -> new RiverReedsFeature(RandomPatchCustomConfig.CODEC));
    public static final DeferredHolder<Feature<?>, SeashellsFeature> SEASHELLS = Primal_WorldGen.registerFeature("seashells", () -> new SeashellsFeature((Codec<SimpleBlockConfiguration>)SimpleBlockConfiguration.CODEC));
    public static final DeferredHolder<Feature<?>, EagleNestFeature> EAGLE_NEST = Primal_WorldGen.registerFeature("eagle_nest", () -> new EagleNestFeature(RandomPatchCustomConfig.CODEC));

    public static void init() {
    }

    public static void boostrapPlacedFeature(BootstrapContext<PlacedFeature> context) {
        HolderGetter registryEntryLookup = context.lookup(Registries.CONFIGURED_FEATURE);
        PlacementUtils.register(context, RIVER_REEDS_PLACED, (Holder)registryEntryLookup.getOrThrow(RIVER_REEDS_CONFIGURED), (PlacementModifier[])new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)2), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
        PlacementUtils.register(context, SEASHELLS_PLACED, (Holder)registryEntryLookup.getOrThrow(SEASHELLS_CONFIGURED), (PlacementModifier[])new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)5), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_TOP_SOLID, BiomeFilter.biome()});
        PlacementUtils.register(context, EAGLES_NEST_SPAWN, (Holder)registryEntryLookup.getOrThrow(EAGLES_NEST_SPAWN_CONFIGURED), (PlacementModifier[])new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)30), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
    }

    public static void boostrapConfiguredFeature(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        Primal_WorldGen.registerFeature(context, RIVER_REEDS_CONFIGURED, (RiverReedsFeature)((Object)RIVER_REEDS_FEATURE.get()), new RandomPatchCustomConfig(10, 8, 5));
        Primal_WorldGen.registerFeature(context, SEASHELLS_CONFIGURED, Feature.FLOWER, Primal_WorldGen.createSeashells(96, 6, 2));
        Primal_WorldGen.registerFeature(context, EAGLES_NEST_SPAWN_CONFIGURED, (EagleNestFeature)((Object)EAGLE_NEST.get()), new RandomPatchCustomConfig(12, 1, 0));
    }

    private static RandomPatchConfiguration createSeashells(int tries, int xzSpread, int ySpread) {
        SimpleWeightedRandomList.Builder builder = SimpleWeightedRandomList.builder();
        for (int i = 1; i <= 4; ++i) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                builder.add((Object)((BlockState)((BlockState)((Block)Primal_Blocks.SEASHELLS.get()).defaultBlockState().setValue((Property)SeashellsBlock.AMOUNT, (Comparable)Integer.valueOf(i))).setValue((Property)SeashellsBlock.FACING, (Comparable)direction)), 1);
            }
        }
        return new RandomPatchConfiguration(tries, xzSpread, ySpread, PlacementUtils.filtered((Feature)((SeashellsFeature)((Object)SEASHELLS.get())), (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(builder)), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_OR_WATER_PREDICATE));
    }

    private static <C extends FeatureConfiguration, F extends Feature<C>> DeferredHolder<Feature<?>, F> registerFeature(String name, Supplier<F> feature) {
        return Primal_Registries.FEATURES.register(name, feature);
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void registerFeature(BootstrapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC configuration) {
        context.register(key, (Object)new ConfiguredFeature(feature, configuration));
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"primal", (String)name));
    }

    public static ResourceKey<PlacedFeature> registerPlacedFeatureKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"primal", (String)name));
    }
}

