/*
 * Decompiled with CFR 0.152.
 */
package org.primal.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;
import org.primal.registry.Primal_Sounds;
import org.primal.util.VariantHolderPrimal;

public interface AnimalEgg {
    public static final IntegerProperty HATCH = BlockStateProperties.HATCH;

    default public void destroyEgg(Level level, BlockState state, BlockPos pos, Entity entity, int chance, Block block, IntegerProperty eggsProperty) {
        if (this.canDestroyEgg(level, entity) && !level.isClientSide && level.random.nextInt(chance) == 0 && state.is(block)) {
            this.decreaseEggs(level, pos, state, eggsProperty);
        }
    }

    default public void decreaseEggs(Level level, BlockPos pos, BlockState state, IntegerProperty eggsProperty) {
        level.playSound(null, pos, (SoundEvent)Primal_Sounds.EGG_BREAK.get(), SoundSource.BLOCKS, 0.7f, 0.9f + level.random.nextFloat() * 0.2f);
        int i = (Integer)state.getValue((Property)eggsProperty);
        if (i <= 1) {
            level.destroyBlock(pos, false);
        } else {
            level.setBlock(pos, (BlockState)state.setValue((Property)eggsProperty, (Comparable)Integer.valueOf(i - 1)), 2);
            level.gameEvent((Holder)GameEvent.BLOCK_DESTROY, pos, GameEvent.Context.of((BlockState)state));
            level.levelEvent(2001, pos, Block.getId((BlockState)state));
        }
    }

    public DeferredHolder<EntityType<?>, ? extends EntityType<? extends Animal>> getAnimal();

    default public void randomTick(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random, IntegerProperty eggsProperty) {
        if (AnimalEgg.shouldUpdateHatchLevel((Level)level)) {
            int i = (Integer)state.getValue((Property)HATCH);
            if (i < 2) {
                level.playSound(null, pos, (SoundEvent)Primal_Sounds.EGG_CRACK.get(), SoundSource.BLOCKS, 0.7f, 0.9f + random.nextFloat() * 0.2f);
                level.setBlock(pos, (BlockState)state.setValue((Property)HATCH, (Comparable)Integer.valueOf(i + 1)), 2);
                level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)state));
            } else {
                level.playSound(null, pos, (SoundEvent)Primal_Sounds.EGG_HATCH.get(), SoundSource.BLOCKS, 0.7f, 0.9f + random.nextFloat() * 0.2f);
                level.removeBlock(pos, false);
                level.gameEvent((Holder)GameEvent.BLOCK_DESTROY, pos, GameEvent.Context.of((BlockState)state));
                for (int j = 0; j < (Integer)state.getValue((Property)eggsProperty); ++j) {
                    level.levelEvent(2001, pos, Block.getId((BlockState)state));
                    Animal animal = (Animal)((EntityType)this.getAnimal().get()).create((Level)level);
                    if (animal == null) continue;
                    Holder holder = level.getBiome(pos);
                    animal.setAge(-24000);
                    if (animal instanceof VariantHolderPrimal) {
                        VariantHolderPrimal variantWhenHatches = (VariantHolderPrimal)animal;
                        if (animal instanceof VariantHolder) {
                            VariantHolder variantHolder = (VariantHolder)animal;
                            VariantHolderPrimal variantHolderCast = variantWhenHatches;
                            if (variantHolderCast.getRareVariant(animal) != null && variantWhenHatches.getRareVariantProbability((Level)level)) {
                                variantHolder.setVariant(variantHolderCast.getRareVariant(animal));
                            } else {
                                variantHolderCast.setVariantFromBiome(animal, (Holder<Biome>)holder);
                            }
                        }
                    }
                    animal.moveTo((double)pos.getX() + 0.3 + (double)j * 0.2, (double)pos.getY(), (double)pos.getZ() + 0.3, 0.0f, 0.0f);
                    level.addFreshEntity((Entity)animal);
                }
            }
        }
    }

    public static boolean shouldUpdateHatchLevel(Level level) {
        float f = level.getTimeOfDay(1.0f);
        return (double)f < 0.69 && (double)f > 0.65 || level.random.nextInt(500) == 0;
    }

    private boolean canDestroyEgg(Level level, Entity entity) {
        if (this.entityCannotDestroyEgg(entity)) {
            return false;
        }
        return entity instanceof LivingEntity && (entity instanceof Player || EventHooks.canEntityGrief((Level)level, (Entity)entity));
    }

    public boolean entityCannotDestroyEgg(Entity var1);
}

