/*
 * Decompiled with CFR 0.152.
 */
package org.primal.worldgen;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import org.jetbrains.annotations.NotNull;
import org.primal.block.NestBlock;
import org.primal.block_entity.NestBlockEntity;
import org.primal.entity.animal.EagleEntity;
import org.primal.registry.Primal_Blocks;
import org.primal.registry.Primal_Entities;
import org.primal.registry.Primal_Items;
import org.primal.worldgen.RandomPatchCustomConfig;

public class EagleNestFeature
extends Feature<RandomPatchCustomConfig> {
    public EagleNestFeature(Codec<RandomPatchCustomConfig> configCodec) {
        super(configCodec);
    }

    public boolean place(@NotNull FeaturePlaceContext<RandomPatchCustomConfig> context) {
        boolean isTooLowAltitude;
        RandomPatchCustomConfig randomPatchConfiguration = (RandomPatchCustomConfig)context.config();
        RandomSource randomsource = context.random();
        BlockPos origin = context.origin();
        WorldGenLevel level = context.level();
        boolean bl = isTooLowAltitude = origin.getY() < level.getSeaLevel() + 20;
        if (isTooLowAltitude) {
            return false;
        }
        int i = 0;
        BlockPos.MutableBlockPos desiredPosition = new BlockPos.MutableBlockPos();
        int xzSpread = randomPatchConfiguration.xzSpread() + 1;
        int ySpread = randomPatchConfiguration.ySpread() + 1;
        BlockState defaultStateNest = ((Block)Primal_Blocks.NEST_BLOCK.get()).defaultBlockState();
        Holder holder = level.getBiome(origin);
        boolean adultGenerated = false;
        for (int l = 0; l < randomPatchConfiguration.tries(); ++l) {
            EagleEntity eagle;
            desiredPosition.setWithOffset((Vec3i)origin, randomsource.nextInt(xzSpread) - randomsource.nextInt(xzSpread), randomsource.nextInt(ySpread) - randomsource.nextInt(ySpread), randomsource.nextInt(xzSpread) - randomsource.nextInt(xzSpread));
            if (!this.canGenerateHere(level, (BlockPos)desiredPosition) || !level.setBlock((BlockPos)desiredPosition, defaultStateNest, 3)) continue;
            BlockState finalState = defaultStateNest;
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPos blockPosAround = desiredPosition.relative(direction);
                if (!level.getBlockState(blockPosAround).is(Primal_Blocks.NEST_BLOCK)) continue;
                finalState = (BlockState)finalState.setValue((Property)NestBlock.PROPERTY_BY_DIRECTION.get(direction), (Comparable)Boolean.valueOf(false));
                level.setBlock(blockPosAround, (BlockState)level.getBlockState(blockPosAround).setValue((Property)NestBlock.PROPERTY_BY_DIRECTION.get(direction.getOpposite()), (Comparable)Boolean.valueOf(false)), 2);
            }
            if (level.getRandom().nextInt(3) == 0) {
                ItemStack eggStack = new ItemStack((ItemLike)Primal_Items.EAGLE_EGG.get(), level.getRandom().nextIntBetweenInclusive(1, 2));
                BlockEntity be = level.getBlockEntity((BlockPos)desiredPosition);
                if (be instanceof NestBlockEntity) {
                    NestBlockEntity nestEntity = (NestBlockEntity)be;
                    nestEntity.setEgg(eggStack, null);
                    finalState = (BlockState)finalState.setValue((Property)NestBlock.HAS_EGG, (Comparable)Boolean.valueOf(true));
                }
            }
            level.setBlock((BlockPos)desiredPosition, finalState, 3);
            if ((!adultGenerated || adultGenerated && level.getRandom().nextIntBetweenInclusive(0, 1) == 0) && (eagle = (EagleEntity)((EntityType)Primal_Entities.EAGLE.get()).create((Level)level.getLevel())) != null) {
                if (adultGenerated && level.getRandom().nextIntBetweenInclusive(0, 4) == 0 && !((Boolean)finalState.getValue((Property)NestBlock.HAS_EGG)).booleanValue()) {
                    eagle.setAge(-24000);
                }
                eagle.setVariantFromBiome(eagle, (Holder<Biome>)holder);
                eagle.moveTo(desiredPosition.getX(), desiredPosition.getY() + 1, desiredPosition.getZ(), 0.0f, 0.0f);
                level.addFreshEntity((Entity)eagle);
                adultGenerated = true;
            }
            ++i;
        }
        return i > 0;
    }

    public boolean canGenerateHere(WorldGenLevel level, BlockPos pos) {
        return level.getBlockState(pos).isAir() && level.getBlockState(pos.below()).isCollisionShapeFullBlock((BlockGetter)level, pos);
    }
}

