/*
 * Decompiled with CFR 0.152.
 */
package org.primal.client.renderer.block_entity;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Optional;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.primal.block.NestBlock;
import org.primal.block_entity.NestBlockEntity;

public class NestBlockEntityRenderer
implements BlockEntityRenderer<NestBlockEntity> {
    private final BlockRenderDispatcher blockRenderer;

    public NestBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.blockRenderer = context.getBlockRenderDispatcher();
    }

    public void render(@NotNull NestBlockEntity nestBlockEntity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Level level = nestBlockEntity.getLevel();
        if (level != null) {
            if (!((Boolean)nestBlockEntity.getBlockState().getValue((Property)NestBlock.HAS_EGG)).booleanValue()) {
                return;
            }
            ItemStack eggStack = nestBlockEntity.getEgg();
            Item item = eggStack.getItem();
            if (item instanceof BlockItem) {
                BakedModel eggModel;
                BlockItem blockItem = (BlockItem)item;
                Block eggBlock = blockItem.getBlock();
                BlockState eggState = eggBlock.defaultBlockState();
                Optional<Property> eggProperty = eggBlock.defaultBlockState().getProperties().stream().filter(property -> property.getName().equals("eggs") && property instanceof IntegerProperty).findFirst();
                Optional<Property> hatchProperty = eggBlock.defaultBlockState().getProperties().stream().filter(property -> property.getName().equals("hatch") && property instanceof IntegerProperty).findFirst();
                if (eggProperty.isPresent()) {
                    eggState = (BlockState)eggState.setValue((Property)((IntegerProperty)eggProperty.get()), (Comparable)Integer.valueOf(eggStack.getCount()));
                }
                if (hatchProperty.isPresent()) {
                    eggState = (BlockState)eggState.setValue((Property)((IntegerProperty)hatchProperty.get()), (Comparable)((Integer)nestBlockEntity.getBlockState().getValue((Property)NestBlock.HATCH)));
                }
                if ((eggModel = this.blockRenderer.getBlockModel(eggState)) != null) {
                    poseStack.pushPose();
                    poseStack.translate(0.0f, 0.25f, 0.0f);
                    this.blockRenderer.renderSingleBlock(eggState, poseStack, bufferSource, packedLight, packedOverlay);
                    poseStack.popPose();
                }
            }
        }
    }
}

