/*
 * Decompiled with CFR 0.152.
 */
package org.primal.client.renderer.entity.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.primal.entity.animal.EagleEntity;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class EagleCollarLayer
extends GeoRenderLayer<EagleEntity> {
    public EagleCollarLayer(GeoRenderer<EagleEntity> entityRendererIn) {
        super(entityRendererIn);
    }

    public void render(PoseStack poseStack, EagleEntity animatable, BakedGeoModel bakedModel, @Nullable RenderType renderType, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
        if (!animatable.isTame() || animatable.isInvisible()) {
            return;
        }
        RenderType collarRenderType = RenderType.entityCutoutNoCull((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"primal", (String)("textures/entity/eagle/" + (animatable.isBaby() ? "b_" : "") + "collar" + (animatable.isLeftHanded() ? "_l" : "_r") + ".png")));
        int i = animatable.getCollarColor().getTextureDiffuseColor();
        this.getRenderer().reRender(bakedModel, poseStack, bufferSource, (GeoAnimatable)animatable, collarRenderType, bufferSource.getBuffer(collarRenderType), partialTick, packedLight, OverlayTexture.NO_OVERLAY, i);
    }
}

