/*
 * Decompiled with CFR 0.152.
 */
package org.primal.datagen.providers;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.primal.registry.Primal_Entities;
import org.primal.registry.Primal_Tags;
import org.primal.registry.Primal_WorldGen;

public class Primal_BiomeModifiersGenerator {
    public static void bootstrap(BootstrapContext<BiomeModifier> bootstrap) {
        Primal_BiomeModifiersGenerator.registerMobSpawn(bootstrap, "spawn/bear", Primal_Tags.SPAWNS_BEAR, (EntityType)Primal_Entities.BEAR.get(), 20, 1, 1);
        Primal_BiomeModifiersGenerator.registerMobSpawn(bootstrap, "spawn/shark_single", Primal_Tags.SPAWNS_SHARK, (EntityType)Primal_Entities.SHARK.get(), 5, 1, 1);
        Primal_BiomeModifiersGenerator.registerMobSpawn(bootstrap, "spawn/shark_group", Primal_Tags.SPAWNS_SHARK, (EntityType)Primal_Entities.SHARK.get(), 1, 1, 3);
        Primal_BiomeModifiersGenerator.registerMobSpawn(bootstrap, "spawn/crocodile", Primal_Tags.SPAWNS_CROCODILE, (EntityType)Primal_Entities.CROCODILE.get(), 20, 1, 1);
        Primal_BiomeModifiersGenerator.registerMobSpawn(bootstrap, "spawn/crocodile_warm", Primal_Tags.SPAWNS_BROWN_CROCODILE, (EntityType)Primal_Entities.CROCODILE.get(), 3, 1, 1);
        Primal_BiomeModifiersGenerator.registerVegetation(bootstrap, "feature/river_reeds", Primal_Tags.SPAWNS_RIVER_REEDS, Primal_WorldGen.RIVER_REEDS_PLACED);
        Primal_BiomeModifiersGenerator.registerVegetation(bootstrap, "feature/seashells", Primal_Tags.SPAWNS_SEASHELLS, Primal_WorldGen.SEASHELLS_PLACED);
        Primal_BiomeModifiersGenerator.registerVegetation(bootstrap, "feature/eagle_nest", Primal_Tags.SPAWNS_EAGLE, Primal_WorldGen.EAGLES_NEST_SPAWN);
    }

    public static void registerVegetation(BootstrapContext<BiomeModifier> bootstrap, String biomeModifier, TagKey<Biome> spawnTag, ResourceKey<PlacedFeature> placedFeature) {
        Primal_BiomeModifiersGenerator.registerVegetation(bootstrap, Primal_BiomeModifiersGenerator.modifierFor(biomeModifier), spawnTag, placedFeature);
    }

    public static void registerVegetation(BootstrapContext<BiomeModifier> bootstrap, ResourceKey<BiomeModifier> biomeModifierResourceKey, TagKey<Biome> spawnTag, ResourceKey<PlacedFeature> placedFeature) {
        Primal_BiomeModifiersGenerator.registerFeature(bootstrap, biomeModifierResourceKey, spawnTag, placedFeature, GenerationStep.Decoration.VEGETAL_DECORATION);
    }

    public static void registerFeature(BootstrapContext<BiomeModifier> bootstrap, ResourceKey<BiomeModifier> biomeModifierResourceKey, TagKey<Biome> spawnTag, ResourceKey<PlacedFeature> placedFeature, GenerationStep.Decoration step) {
        HolderGetter biomes = bootstrap.lookup(Registries.BIOME);
        HolderGetter placedFeatures = bootstrap.lookup(Registries.PLACED_FEATURE);
        bootstrap.register(biomeModifierResourceKey, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(spawnTag), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(placedFeature)}), step));
    }

    public static void registerMobSpawn(BootstrapContext<BiomeModifier> bootstrap, String biomeModifier, TagKey<Biome> spawnTag, EntityType<?> mob, int weight, int minGroupSize, int maxGroupSize) {
        Primal_BiomeModifiersGenerator.registerMobSpawn(bootstrap, Primal_BiomeModifiersGenerator.modifierFor(biomeModifier), spawnTag, mob, weight, minGroupSize, maxGroupSize);
    }

    public static void registerMobSpawn(BootstrapContext<BiomeModifier> bootstrap, ResourceKey<BiomeModifier> biomeModifierResourceKey, TagKey<Biome> spawnTag, EntityType<?> mob, int weight, int minGroupSize, int maxGroupSize) {
        HolderGetter biomes = bootstrap.lookup(Registries.BIOME);
        bootstrap.register(biomeModifierResourceKey, (Object)new BiomeModifiers.AddSpawnsBiomeModifier((HolderSet)biomes.getOrThrow(spawnTag), List.of(new MobSpawnSettings.SpawnerData(mob, weight, minGroupSize, maxGroupSize))));
    }

    public static ResourceKey<BiomeModifier> modifierFor(String id) {
        return ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"primal", (String)id));
    }
}

