/*
 * Decompiled with CFR 0.152.
 */
package org.primal.entity.ai.behavior.crocodile;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ProjectileWeaponItem;
import org.jetbrains.annotations.NotNull;
import org.primal.entity.animal.CrocodileEntity;
import org.primal.registry.Primal_MemoryModuleTypes;

public class CrocodileStartAttack
extends Behavior<CrocodileEntity> {
    private final int cooldownBetweenAttacks;

    public CrocodileStartAttack(int cooldownBetweenAttacks) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.ATTACK_COOLING_DOWN, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.NEAREST_ATTACKABLE, (Object)MemoryStatus.VALUE_PRESENT));
        this.cooldownBetweenAttacks = cooldownBetweenAttacks;
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel level, @NotNull CrocodileEntity crocodile) {
        LivingEntity target = (LivingEntity)crocodile.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).get();
        NearestVisibleLivingEntities nearestVisibleLivingEntities = (NearestVisibleLivingEntities)crocodile.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).get();
        return !CrocodileStartAttack.isHoldingUsableProjectileWeapon((Mob)crocodile) && crocodile.isWithinMeleeAttackRange(target) && nearestVisibleLivingEntities.contains(target) && crocodile.getPassengers().isEmpty();
    }

    protected void start(@NotNull ServerLevel level, @NotNull CrocodileEntity crocodile, long gameTime) {
        LivingEntity target = (LivingEntity)crocodile.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).get();
        crocodile.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, (Object)new EntityTracker((Entity)target, true));
        crocodile.swing(InteractionHand.MAIN_HAND);
        if (CrocodileEntity.canPickUpEntity((Entity)target, crocodile)) {
            target.startRiding((Entity)crocodile);
            crocodile.setHealthWhenStartRiding(crocodile.getHealth());
            crocodile.setPose(Pose.SPIN_ATTACK);
            crocodile.getBrain().setMemory((MemoryModuleType)Primal_MemoryModuleTypes.IS_THRASHING.get(), (Object)true);
            this.stop(level, crocodile, gameTime);
        } else {
            crocodile.doHurtTarget((Entity)target);
            this.stop(level, crocodile, gameTime);
        }
    }

    protected void tick(@NotNull ServerLevel level, @NotNull CrocodileEntity crocodile, long gameTime) {
    }

    protected void stop(@NotNull ServerLevel level, CrocodileEntity crocodile, long gameTime) {
        crocodile.getBrain().setMemoryWithExpiry(MemoryModuleType.ATTACK_COOLING_DOWN, (Object)true, (long)this.cooldownBetweenAttacks);
    }

    private static boolean isHoldingUsableProjectileWeapon(Mob mob) {
        return mob.isHolding(stack -> {
            Item item = stack.getItem();
            return item instanceof ProjectileWeaponItem && mob.canFireProjectileWeapon((ProjectileWeaponItem)item);
        });
    }
}

