/*
 * Decompiled with CFR 0.152.
 */
package org.primal.entity.animal;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.PolarBear;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.primal.client.animation.entity.BearAnimations;
import org.primal.entity.ai.BearAi;
import org.primal.registry.Primal_Entities;
import org.primal.registry.Primal_MemoryModuleTypes;
import org.primal.registry.Primal_Sounds;
import org.primal.registry.Primal_Tags;
import org.primal.util.MiscUtil;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BearEntity
extends TamableAnimal
implements VariantHolder<Variant>,
GeoEntity,
ContainerListener,
HasCustomInventoryScreen,
OwnableEntity,
NeutralMob {
    protected SimpleContainer inventory = new SimpleContainer(27);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Boolean> BEAR_SLEEPING = SynchedEntityData.defineId(BearEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> DATA_VARIANT_ID = SynchedEntityData.defineId(BearEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_HONEY_COUNTER = SynchedEntityData.defineId(BearEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> AWAKE_COUNTER = SynchedEntityData.defineId(BearEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> HEALING_COOLDOWN = SynchedEntityData.defineId(BearEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> HAS_CHEST = SynchedEntityData.defineId(BearEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> FOLLOWER_STATE = SynchedEntityData.defineId(BearEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> IS_JOCKEY = SynchedEntityData.defineId(BearEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> DATA_COLLAR_COLOR = SynchedEntityData.defineId(BearEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private int tameAttempts = 0;

    public void containerChanged(@NotNull Container container) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 80.0).add(Attributes.MOVEMENT_SPEED, (double)0.1f).add(Attributes.ATTACK_DAMAGE, 8.0).add(Attributes.ATTACK_KNOCKBACK, (double)1.8f).add(Attributes.KNOCKBACK_RESISTANCE, (double)0.6f);
    }

    public BearEntity(EntityType<BearEntity> entityType, Level level) {
        super(entityType, level);
        this.setHealth(this.getMaxHealth());
        this.getNavigation().setCanFloat(true);
    }

    @NotNull
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        Holder holder = level.getBiome(this.blockPosition());
        if (holder.is(Primal_Tags.SPAWNS_BLACK_BEAR)) {
            this.setVariant(Variant.WARM);
        } else {
            this.setVariant(Variant.GRIZZLY);
        }
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{BearAnimations.mainController(this).receiveTriggeredAnimations().triggerableAnim("roar", BearAnimations.ROAR).triggerableAnim("beg_end", RawAnimation.begin().thenPlay("animation.grizzly_bear.beg_end")).triggerableAnim("sleep_start", RawAnimation.begin().thenPlay("animation.grizzly_bear.sleep_start")).triggerableAnim("sleep_end", RawAnimation.begin().thenPlay("animation.grizzly_bear.sleep_end")), new AnimationController((GeoAnimatable)this, "alt_idle", state -> PlayState.STOP).triggerableAnim("alt_idle", BearAnimations.IDLE_ALT), new AnimationController((GeoAnimatable)this, "attack", state -> PlayState.STOP).triggerableAnim("attack", BearAnimations.ATTACK).triggerableAnim("attack2", BearAnimations.ATTACK_ALT)});
    }

    public int getMaxHeadYRot() {
        return 35;
    }

    public int getMaxHeadXRot() {
        return 35;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void swing(@NotNull InteractionHand hand) {
        this.triggerAnim("attack", this.getRandom().nextBoolean() ? "attack" : "attack2");
        super.swing(hand);
    }

    public boolean doHurtTarget(@NotNull Entity entity) {
        boolean hurt = super.doHurtTarget(entity);
        List<Object> attackablesEntities = new ArrayList<Entity>(this.level().getEntities((Entity)this, this.getBoundingBox().inflate(1.0)).stream().filter(target -> {
            BearEntity bear2;
            return MiscUtil.isSeeingTarget(target, (Entity)this, -0.8f) && (!(target instanceof BearEntity) || (bear2 = (BearEntity)((Object)target)).getOwner() == null || bear2.getOwner() != this.getOwner());
        }).toList());
        if (attackablesEntities.size() > 5) {
            attackablesEntities = attackablesEntities.subList(0, 5);
        }
        for (Entity otherEntity : attackablesEntities) {
            this.doHurtOther(otherEntity);
        }
        return hurt;
    }

    public void doHurtOther(@NotNull Entity entity) {
        boolean flag;
        float f = (float)this.getAttributeValue(Attributes.ATTACK_DAMAGE) * 0.6f;
        DamageSource damagesource = this.damageSources().mobAttack((LivingEntity)this);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            f = EnchantmentHelper.modifyDamage((ServerLevel)serverlevel, (ItemStack)this.getWeaponItem(), (Entity)entity, (DamageSource)damagesource, (float)f);
        }
        if (flag = entity.hurt(damagesource, f)) {
            Level level2;
            float f1 = this.getKnockback(entity, damagesource);
            if (f1 > 0.0f && entity instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity;
                livingentity.knockback((double)(f1 * 0.2f), (double)Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180)))));
                this.setDeltaMovement(this.getDeltaMovement().multiply(0.6, 1.0, 0.6));
            }
            if ((level2 = this.level()) instanceof ServerLevel) {
                ServerLevel serverLevel1 = (ServerLevel)level2;
                EnchantmentHelper.doPostAttackEffects((ServerLevel)serverLevel1, (Entity)entity, (DamageSource)damagesource);
            }
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            if (this.tickCount % 300 == 0 && this.getRandom().nextBoolean()) {
                this.triggerAnim("alt_idle", "alt_idle");
            }
        } else {
            this.setCounters();
        }
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(BEAR_SLEEPING, (Object)false);
        builder.define(DATA_VARIANT_ID, (Object)Variant.GRIZZLY.id);
        builder.define(DATA_HONEY_COUNTER, (Object)0);
        builder.define(AWAKE_COUNTER, (Object)0);
        builder.define(HEALING_COOLDOWN, (Object)0);
        builder.define(HAS_CHEST, (Object)false);
        builder.define(FOLLOWER_STATE, (Object)0);
        builder.define(DATA_COLLAR_COLOR, (Object)DyeColor.RED.getId());
        builder.define(IS_JOCKEY, (Object)false);
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Variant", this.getVariant().id);
        compound.putInt("HoneyCounter", this.getHoneyCounter());
        compound.putInt("AwakeCounter", this.getAwakeCounter());
        compound.putInt("HealingCooldown", this.getHealingCooldown());
        compound.putBoolean("IsSleeping", this.isBearSleeping());
        compound.putBoolean("HasChest", this.hasChest());
        if (this.getOwnerUUID() != null) {
            compound.putInt("FollowerState", this.getFollowerState());
        }
        if (this.hasChest()) {
            ListTag listtag = new ListTag();
            for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
                ItemStack itemstack = this.inventory.getItem(i);
                if (itemstack.isEmpty()) continue;
                CompoundTag compoundtag = new CompoundTag();
                compoundtag.putByte("Slot", (byte)i);
                listtag.add((Object)itemstack.save((HolderLookup.Provider)this.registryAccess(), (Tag)compoundtag));
            }
            compound.put("Items", (Tag)listtag);
        }
        compound.putByte("CollarColor", (byte)this.getCollarColor().getId());
        compound.putBoolean("BearJockey", this.isBearJockey());
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setVariant(Variant.byId(compound.getInt("Variant")));
        this.setHoneyCounter(compound.getInt("HoneyCounter"));
        this.setAwakeCounter(compound.getInt("AwakeCounter"));
        this.setBearSleeping(compound.getBoolean("IsSleeping"));
        this.setHealingCooldown(compound.getInt("HealingCooldown"));
        this.setChest(compound.getBoolean("HasChest"));
        if (compound.hasUUID("Owner")) {
            this.setFollowerState(compound.getInt("FollowerState"));
        }
        if (this.hasChest()) {
            ListTag listtag = compound.getList("Items", 10);
            for (int i = 0; i < listtag.size(); ++i) {
                CompoundTag compoundtag = listtag.getCompound(i);
                int j = compoundtag.getByte("Slot") & 0xFF;
                if (j >= this.inventory.getContainerSize()) continue;
                this.inventory.setItem(j, ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)compoundtag).orElse(ItemStack.EMPTY));
            }
        }
        if (compound.contains("CollarColor", 99)) {
            this.setCollarColor(DyeColor.byId((int)compound.getInt("CollarColor")));
        }
        this.setBearJockey(compound.getBoolean("BearJockey"));
    }

    public boolean isBearSleeping() {
        return (Boolean)this.entityData.get(BEAR_SLEEPING);
    }

    public void setBearSleeping(boolean isSleeping) {
        this.entityData.set(BEAR_SLEEPING, (Object)isSleeping);
    }

    public int getHoneyCounter() {
        return (Integer)this.entityData.get(DATA_HONEY_COUNTER);
    }

    public void setHoneyCounter(int value) {
        this.entityData.set(DATA_HONEY_COUNTER, (Object)value);
    }

    public int getAwakeCounter() {
        return (Integer)this.entityData.get(AWAKE_COUNTER);
    }

    public void setAwakeCounter(int value) {
        this.entityData.set(AWAKE_COUNTER, (Object)value);
    }

    public int getHealingCooldown() {
        return (Integer)this.entityData.get(HEALING_COOLDOWN);
    }

    public void setHealingCooldown(int value) {
        this.entityData.set(HEALING_COOLDOWN, (Object)value);
    }

    public boolean hasChest() {
        return (Boolean)this.entityData.get(HAS_CHEST);
    }

    public void setChest(boolean chested) {
        this.entityData.set(HAS_CHEST, (Object)chested);
    }

    public DyeColor getCollarColor() {
        return DyeColor.byId((int)((Integer)this.entityData.get(DATA_COLLAR_COLOR)));
    }

    private void setCollarColor(DyeColor collarColor) {
        this.entityData.set(DATA_COLLAR_COLOR, (Object)collarColor.getId());
    }

    public boolean isBearJockey() {
        return (Boolean)this.entityData.get(IS_JOCKEY);
    }

    public void setBearJockey(boolean isJockey) {
        this.entityData.set(IS_JOCKEY, (Object)isJockey);
    }

    public int getFollowerState() {
        return (Integer)this.entityData.get(FOLLOWER_STATE);
    }

    public void setFollowerState(int state) {
        this.entityData.set(FOLLOWER_STATE, (Object)state);
    }

    public boolean isSitting() {
        return this.getFollowerState() == 2;
    }

    public boolean isFollowing() {
        return this.getFollowerState() == 1;
    }

    public boolean isWandering() {
        return this.getFollowerState() == 0;
    }

    public void setVariant(Variant variant) {
        this.entityData.set(DATA_VARIANT_ID, (Object)variant.id);
    }

    @NotNull
    public Variant getVariant() {
        return Variant.byId((Integer)this.entityData.get(DATA_VARIANT_ID));
    }

    private void setCounters() {
        if (this.getHoneyCounter() > 0) {
            this.setHoneyCounter(this.getHoneyCounter() - 1);
        }
        if (this.getAwakeCounter() > 0 && !this.isAggressive() && !this.getBrain().isActive(Activity.ROAR)) {
            this.setAwakeCounter(this.getAwakeCounter() - 1);
        }
        if (this.getHealingCooldown() > 0) {
            this.setHealingCooldown(this.getHealingCooldown() - 1);
        }
    }

    public boolean canMate(@NotNull Animal otherAnimal) {
        PolarBear polarBear;
        BearEntity bear;
        if (otherAnimal instanceof BearEntity && (bear = (BearEntity)otherAnimal).canParent() && this.canParent()) {
            return true;
        }
        return otherAnimal instanceof PolarBear && (polarBear = (PolarBear)otherAnimal).canMate((Animal)this) && this.canParent() && this.getVariant() == Variant.GRIZZLY;
    }

    public boolean canParent() {
        return !this.isVehicle() && !this.isPassenger() && !this.isBaby() && this.isInLove();
    }

    public AgeableMob getBreedOffspring(@NotNull ServerLevel level, @NotNull AgeableMob otherParent) {
        return BearEntity.createFromParents((AgeableMob)this, otherParent);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static BearEntity createFromParents(AgeableMob parent, AgeableMob otherParent) {
        BearEntity offspring = (BearEntity)((EntityType)Primal_Entities.BEAR.get()).create(parent.level());
        if (offspring == null) return offspring;
        if (parent instanceof BearEntity) {
            BearEntity bear1 = (BearEntity)parent;
            if (otherParent instanceof BearEntity) {
                BearEntity bear2 = (BearEntity)otherParent;
                offspring.setVariant(offspring.random.nextBoolean() ? bear1.getVariant() : bear2.getVariant());
                return offspring;
            }
        }
        if (!(parent instanceof PolarBear)) {
            if (!(otherParent instanceof PolarBear)) return offspring;
        }
        offspring.setVariant(Variant.GROLAR);
        return offspring;
    }

    public boolean refuseToMove() {
        return ImmutableList.of((Object)Pose.ROARING, (Object)Pose.SNIFFING, (Object)Pose.CROAKING).contains((Object)this.getPose());
    }

    public void stopMoving() {
        this.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        this.getNavigation().stop();
        this.getBrain().eraseMemory(MemoryModuleType.LOOK_TARGET);
    }

    protected void customServerAiStep() {
        super.customServerAiStep();
        Brain<BearEntity> brain = this.getBrain();
        brain.tick((ServerLevel)this.level(), (LivingEntity)this);
        if (!this.isInWater()) {
            this.setSprinting(brain.getMemory(MemoryModuleType.ATTACK_TARGET).isPresent());
        }
        if (this.isSprinting() && this.isInWater()) {
            this.setSprinting(false);
        }
        BearAi.updateActivity(this);
        if (this.getHealth() < this.getMaxHealth() && this.random.nextInt(0, 100) <= 20 && this.getHealingCooldown() == 0) {
            int indexOfHealItem = -1;
            for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
                if (!BearEntity.isHealFood(this.inventory.getItem(i))) continue;
                indexOfHealItem = i;
            }
            if (indexOfHealItem != -1) {
                this.heal(2.0f);
                this.inventory.setItem(indexOfHealItem, new ItemStack((ItemLike)this.inventory.getItem(indexOfHealItem).getItem(), this.inventory.getItem(indexOfHealItem).getCount() - 1));
                this.playEatingSound();
                this.setHealingCooldown(50);
            }
        }
        this.applySpeedModifiers();
        if (this.isBearJockey() && this.isBaby()) {
            this.setAge(-24000);
        }
        if (this.isBearJockey() && !this.isVehicle()) {
            this.setBearJockey(false);
        }
    }

    public float getSpeed() {
        return this.isSprinting() ? super.getSpeed() * 1.3f : (this.getPose().equals((Object)Pose.ROARING) ? 0.0f : super.getSpeed());
    }

    public AttributeModifier createSpeedModifier(float amount) {
        return new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"primal", (String)"health_speed_modifier"), Mth.clamp((double)amount, (double)0.0, (double)0.13), AttributeModifier.Operation.ADD_VALUE);
    }

    public void applySpeedModifiers() {
        AttributeModifier modifier = this.createSpeedModifier(this.getHealth() / this.getMaxHealth() * 0.13f);
        AttributeInstance entityAttributeInstance_speed = this.getAttribute(Attributes.MOVEMENT_SPEED);
        if (entityAttributeInstance_speed != null) {
            entityAttributeInstance_speed.removeModifier(modifier.id());
            entityAttributeInstance_speed.addTransientModifier(modifier);
        }
    }

    public boolean bearCollapses() {
        return this.getMaxHealth() * 0.2f > this.getHealth();
    }

    public float getWalkTargetValue(@NotNull BlockPos pos, @NotNull LevelReader level) {
        if (BearAi.isPosNearNearestRepellent(this, pos)) {
            return -1.0f;
        }
        return level.getBlockState(pos.below()).is(Blocks.GRASS_BLOCK) ? 10.0f : level.getPathfindingCostFromLightLevels(pos);
    }

    protected float getWaterSlowDown() {
        return this.getVariant() == Variant.GROLAR ? 0.96f : 0.9f;
    }

    protected void registerGoals() {
    }

    @NotNull
    protected Brain.Provider<BearEntity> brainProvider() {
        return BearAi.brainProvider();
    }

    @NotNull
    protected Brain<?> makeBrain(@NotNull Dynamic<?> dynamic) {
        return BearAi.makeBrain((Brain<BearEntity>)this.brainProvider().makeBrain(dynamic));
    }

    @NotNull
    public Brain<BearEntity> getBrain() {
        return super.getBrain();
    }

    @Nullable
    public LivingEntity getTarget() {
        return this.getTargetFromBrain();
    }

    public boolean hurt(@NotNull DamageSource source, float amount) {
        BearEntity bear2;
        LivingEntity target;
        Entity entity;
        boolean hurt = super.hurt(source, amount);
        if (this.level().isClientSide) {
            return false;
        }
        if (hurt && (entity = source.getEntity()) instanceof LivingEntity && (target = (LivingEntity)entity) != this.getOwner() && (!(target instanceof BearEntity) || (bear2 = (BearEntity)target).getOwner() == null || bear2.getOwner() != this.getOwner())) {
            BearAi.wasHurtBy(this, target);
        }
        return hurt;
    }

    public boolean canTargetEntity(LivingEntity target) {
        return !this.isBaby() && !this.bearCollapses() && this.getBrain().getMemory(MemoryModuleType.NEAREST_ATTACKABLE).isPresent() && this.getBrain().getMemory(MemoryModuleType.NEAREST_ATTACKABLE).get() == target && (this.getBrain().hasMemoryValue((MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_VISIBLE_BABY.get()) || this.isTame() || target.distanceTo((Entity)this) < 8.0f && !target.isShiftKeyDown()) && target.getHealth() > 0.0f && target.canBeSeenAsEnemy() && MiscUtil.isNotNeverAttack(target);
    }

    public void setAttackTarget(LivingEntity attackTarget) {
        this.getBrain().eraseMemory(MemoryModuleType.ROAR_TARGET);
        this.getBrain().setMemory(MemoryModuleType.ATTACK_TARGET, (Object)attackTarget);
        this.getBrain().eraseMemory(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE);
    }

    public boolean isFood(@NotNull ItemStack stack) {
        return BearEntity.isTameFood(stack) || BearEntity.isHealFood(stack) || BearEntity.isMatingFood(stack);
    }

    public static boolean isTameFood(@NotNull ItemStack stack) {
        return stack.is(Items.HONEYCOMB);
    }

    public static boolean isHealFood(@NotNull ItemStack stack) {
        return stack.is(Items.SWEET_BERRIES);
    }

    public static boolean isMatingFood(@NotNull ItemStack stack) {
        return stack.is(Items.SALMON_BUCKET);
    }

    @NotNull
    public InteractionResult mobInteract(Player player, @NotNull InteractionHand hand) {
        boolean wasFeed;
        ItemStack stackInHand = player.getItemInHand(hand);
        Item item = stackInHand.getItem();
        if (item instanceof DyeItem) {
            DyeColor dyecolor;
            DyeItem dyeitem = (DyeItem)item;
            if (this.isOwnedBy((LivingEntity)player) && (dyecolor = dyeitem.getDyeColor()) != this.getCollarColor()) {
                this.setCollarColor(dyecolor);
                stackInHand.consume(1, (LivingEntity)player);
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
        }
        if (this.isFood(stackInHand) && (wasFeed = this.handleEating(player, stackInHand))) {
            stackInHand.consume(1, (LivingEntity)player);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        if (this.isTame() && player.isSecondaryUseActive() && this.hasChest()) {
            this.openCustomInventoryScreen(player);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        if (this.isTame() && !this.hasChest() && stackInHand.is(Items.BARREL) && !this.isBaby()) {
            this.setChest(true);
            this.playChestEquipsSound();
            stackInHand.consume(1, (LivingEntity)player);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        if (this.isTame()) {
            if (this.isBearSleeping() && !this.isSitting()) {
                this.setAwakeCounter(600 + this.getRandom().nextIntBetweenInclusive(20, 200));
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
            }
            return this.changeFollowState(player, hand);
        }
        return InteractionResult.PASS;
    }

    public InteractionResult changeFollowState(Player player, InteractionHand hand) {
        if (player != this.getOwner()) {
            if (this.level().isClientSide) {
                return InteractionResult.CONSUME;
            }
            return InteractionResult.PASS;
        }
        if (!this.level().isClientSide && hand.equals((Object)InteractionHand.MAIN_HAND)) {
            this.setFollowerState(this.isWandering() ? 1 : (this.isFollowing() ? 2 : 0));
            player.displayClientMessage((Component)Component.translatable((String)(this.isFollowing() ? "primal.gui.animal_following" : (this.isSitting() ? "primal.gui.animal_sitting" : "primal.gui.animal_wandering")), (Object[])new Object[]{this.getName()}), true);
        }
        return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
    }

    public void openCustomInventoryScreen(@NotNull Player player) {
        if (this.hasChest()) {
            player.openMenu((MenuProvider)new SimpleMenuProvider((i, inventory, player1) -> ChestMenu.threeRows((int)i, (Inventory)inventory, (Container)this.inventory), this.getName()));
        }
    }

    protected boolean handleEating(@NotNull Player player, @NotNull ItemStack stack) {
        if (this.isFood(stack)) {
            if (BearEntity.isMatingFood(stack) && !this.isBearSleeping() && !this.level().isClientSide && this.getAge() == 0 && this.canFallInLove()) {
                this.setInLove(player);
                return this.playEatingSound();
            }
            if (!this.isTame() && BearEntity.isTameFood(stack) && !this.isBearSleeping() && !this.level().isClientSide) {
                boolean canTameNow;
                ++this.tameAttempts;
                boolean bl = canTameNow = this.tameAttempts >= 10 && this.random.nextInt(21 - this.tameAttempts) == 0;
                if (canTameNow) {
                    this.tame(player);
                    this.navigation.stop();
                    this.setTarget(null);
                    this.level().broadcastEntityEvent((Entity)this, (byte)7);
                } else {
                    this.level().broadcastEntityEvent((Entity)this, (byte)6);
                }
                return this.playEatingSound();
            }
            if (this.isTame() && !this.level().isClientSide && BearEntity.isHealFood(stack) && this.getHealth() < this.getMaxHealth()) {
                this.heal(2.0f);
                return this.playEatingSound();
            }
            if (this.isBaby() && !BearEntity.isTameFood(stack)) {
                int i = this.getAge();
                this.ageUp(BearEntity.getSpeedUpSecondsWhenFeeding((int)(-i)), true);
                return this.playEatingSound();
            }
        }
        return false;
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return this.getBrain().isActive(Activity.ROAR) ? null : (this.isBearSleeping() ? (SoundEvent)Primal_Sounds.BEAR_SNORING.get() : (this.isAggressive() ? (SoundEvent)Primal_Sounds.BEAR_IDLE_ANGRY.get() : (SoundEvent)Primal_Sounds.BEAR_IDLE.get()));
    }

    @Nullable
    protected SoundEvent getHurtSound(@NotNull DamageSource damageSource) {
        return (SoundEvent)Primal_Sounds.BEAR_HURT.get();
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return (SoundEvent)Primal_Sounds.BEAR_DEATH.get();
    }

    @Nullable
    public SoundEvent getRoarSound() {
        return (SoundEvent)Primal_Sounds.BEAR_ROAR.get();
    }

    @Nullable
    public SoundEvent getWakeUpSound() {
        return (SoundEvent)Primal_Sounds.BEAR_WAKE_UP.get();
    }

    protected boolean playEatingSound() {
        SoundEvent soundEvent;
        if (!this.isSilent() && (soundEvent = this.getEatingSound()) != null) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), soundEvent, this.getSoundSource(), 1.0f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.2f);
        }
        return true;
    }

    protected void playChestEquipsSound() {
        this.playSound((SoundEvent)Primal_Sounds.ANIMAL_CHEST.get(), 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
    }

    public SoundEvent getEatingSound() {
        return (SoundEvent)Primal_Sounds.BEAR_EAT.get();
    }

    public boolean isPushable() {
        return super.isPushable() && !this.isBearSleeping();
    }

    public void knockback(double strength, double x, double z) {
        if (this.isBearSleeping()) {
            return;
        }
        super.knockback(strength, x, z);
    }

    public boolean shouldTryTeleportToOwner() {
        LivingEntity livingentity = this.getOwner();
        return livingentity != null && this.distanceToSqr((Entity)this.getOwner()) >= 625.0;
    }

    protected void dropEquipment() {
        if (this.inventory != null) {
            for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
                ItemStack itemstack = this.inventory.getItem(i);
                if (itemstack.isEmpty()) continue;
                this.spawnAtLocation(itemstack);
            }
        }
        if (this.hasChest()) {
            if (!this.level().isClientSide) {
                this.spawnAtLocation((ItemLike)Blocks.BARREL);
            }
            this.setChest(false);
        }
    }

    public boolean canBeSeenAsEnemy() {
        return super.canBeSeenAsEnemy() && !this.isBearSleeping();
    }

    public boolean canBeLeashed() {
        return super.canBeLeashed() && !this.isBearSleeping();
    }

    @NotNull
    protected Vec3 getLeashOffset() {
        return new Vec3(0.0, (double)(this.getEyeHeight() * 0.6f), (double)(this.getBbWidth() * 0.2f));
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return this.isBearJockey();
    }

    public int getRemainingPersistentAngerTime() {
        return 0;
    }

    public void setRemainingPersistentAngerTime(int remainingPersistentAngerTime) {
    }

    @Nullable
    public UUID getPersistentAngerTarget() {
        return null;
    }

    public void setPersistentAngerTarget(@Nullable UUID persistentAngerTarget) {
    }

    public void startPersistentAngerTimer() {
    }

    public static enum Variant implements StringRepresentable
    {
        GRIZZLY(0, "grizzly"),
        WARM(1, "warm"),
        GROLAR(2, "grolar");

        public static final Codec<Variant> CODEC;
        private static final IntFunction<Variant> BY_ID;
        final int id;
        private final String name;

        public static Variant byId(int id) {
            return BY_ID.apply(id);
        }

        private Variant(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Variant::values);
            BY_ID = ByIdMap.continuous(Variant::getId, (Object[])Variant.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.CLAMP);
        }
    }
}

