/*
 * Decompiled with CFR 0.152.
 */
package org.primal.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.animal.sniffer.Sniffer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SnifferEggBlock;
import net.minecraft.world.level.block.TurtleEggBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.primal.block_entity.NestBlockEntity;
import org.primal.registry.Primal_BlockEntities;
import org.primal.registry.Primal_Sounds;
import org.primal.registry.Primal_Tags;
import org.primal.util.AnimalEgg;
import org.primal.util.VariantHolderPrimal;

public class NestBlock
extends BaseEntityBlock {
    public static final MapCodec<NestBlock> CODEC = NestBlock.simpleCodec(NestBlock::new);
    public static final BooleanProperty HAS_EGG = BooleanProperty.create((String)"has_egg");
    public static final IntegerProperty HATCH = BlockStateProperties.HATCH;
    public static final BooleanProperty NORTH = PipeBlock.NORTH;
    public static final BooleanProperty EAST = PipeBlock.EAST;
    public static final BooleanProperty SOUTH = PipeBlock.SOUTH;
    public static final BooleanProperty WEST = PipeBlock.WEST;
    public static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = ImmutableMap.copyOf((Map)((Map)Util.make((Object)Maps.newEnumMap(Direction.class), p_55164_ -> {
        p_55164_.put(Direction.NORTH, NORTH);
        p_55164_.put(Direction.EAST, EAST);
        p_55164_.put(Direction.SOUTH, SOUTH);
        p_55164_.put(Direction.WEST, WEST);
    })));

    public NestBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)NORTH, (Comparable)Boolean.valueOf(true))).setValue((Property)EAST, (Comparable)Boolean.valueOf(true))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(true))).setValue((Property)WEST, (Comparable)Boolean.valueOf(true))).setValue((Property)HAS_EGG, (Comparable)Boolean.valueOf(false))).setValue((Property)HATCH, (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{NORTH, EAST, SOUTH, WEST, HAS_EGG, HATCH});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level blockgetter = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        return (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)NORTH, (Comparable)Boolean.valueOf(!blockgetter.getBlockState(blockpos.north()).is((Block)this)))).setValue((Property)EAST, (Comparable)Boolean.valueOf(!blockgetter.getBlockState(blockpos.east()).is((Block)this)))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(!blockgetter.getBlockState(blockpos.south()).is((Block)this)))).setValue((Property)WEST, (Comparable)Boolean.valueOf(!blockgetter.getBlockState(blockpos.west()).is((Block)this)));
    }

    @NotNull
    protected BlockState updateShape(@NotNull BlockState state, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor level, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        if (facing != Direction.DOWN && facing != Direction.UP) {
            return facingState.is((Block)this) ? (BlockState)state.setValue((Property)PROPERTY_BY_DIRECTION.get(facing), (Comparable)Boolean.valueOf(false)) : (BlockState)state.setValue((Property)PROPERTY_BY_DIRECTION.get(facing), (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    @NotNull
    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)PROPERTY_BY_DIRECTION.get(rotation.rotate(Direction.NORTH)), (Comparable)((Boolean)state.getValue((Property)NORTH)))).setValue((Property)PROPERTY_BY_DIRECTION.get(rotation.rotate(Direction.SOUTH)), (Comparable)((Boolean)state.getValue((Property)SOUTH)))).setValue((Property)PROPERTY_BY_DIRECTION.get(rotation.rotate(Direction.EAST)), (Comparable)((Boolean)state.getValue((Property)EAST)))).setValue((Property)PROPERTY_BY_DIRECTION.get(rotation.rotate(Direction.WEST)), (Comparable)((Boolean)state.getValue((Property)WEST)));
    }

    @NotNull
    protected BlockState mirror(BlockState state, Mirror mirror) {
        return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)PROPERTY_BY_DIRECTION.get(mirror.mirror(Direction.NORTH)), (Comparable)((Boolean)state.getValue((Property)NORTH)))).setValue((Property)PROPERTY_BY_DIRECTION.get(mirror.mirror(Direction.SOUTH)), (Comparable)((Boolean)state.getValue((Property)SOUTH)))).setValue((Property)PROPERTY_BY_DIRECTION.get(mirror.mirror(Direction.EAST)), (Comparable)((Boolean)state.getValue((Property)EAST)))).setValue((Property)PROPERTY_BY_DIRECTION.get(mirror.mirror(Direction.WEST)), (Comparable)((Boolean)state.getValue((Property)WEST)));
    }

    protected void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean movedByPiston) {
        NestBlockEntity eggBlockEntity = NestBlock.getBlockEntity(level, pos);
        if (((Boolean)state.getValue((Property)HAS_EGG)).booleanValue() && eggBlockEntity != null && newState.getBlock().defaultBlockState().isAir()) {
            ItemStack eggStack = new ItemStack((ItemLike)eggBlockEntity.getEgg().getItem(), eggBlockEntity.getEgg().getCount());
            NestBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)eggStack);
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    protected void spawnAfterBreak(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull ItemStack stack, boolean dropExperience) {
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        if ((player.isSecondaryUseActive() || stack.isEmpty()) && ((Boolean)state.getValue((Property)HAS_EGG)).booleanValue()) {
            return NestBlock.removeEgg((LivingEntity)player, level, pos, state, true) ? ItemInteractionResult.sidedSuccess((boolean)level.isClientSide) : ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
        }
        if (this.isItemPlaceable(stack)) {
            return NestBlock.tryPlaceEgg((LivingEntity)player, level, pos, state, stack) ? ItemInteractionResult.sidedSuccess((boolean)level.isClientSide) : ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public static boolean tryPlaceEgg(@Nullable LivingEntity entity, Level level, BlockPos pos, BlockState state, ItemStack stack) {
        if (!((Boolean)state.getValue((Property)HAS_EGG)).booleanValue()) {
            if (!level.isClientSide) {
                NestBlock.placeEgg(entity, level, pos, state, stack, false);
            }
            return true;
        }
        if (((Boolean)state.getValue((Property)HAS_EGG)).booleanValue() && NestBlock.getBlockEntity(level, pos).getEgg().is(stack.getItem()) && NestBlock.getBlockEntity(level, pos).getEggsAmount() + 1 <= NestBlock.getMaxEggAmount(stack)) {
            if (!level.isClientSide) {
                NestBlock.placeEgg(entity, level, pos, state, stack, true);
            }
            return true;
        }
        return false;
    }

    private static boolean removeEgg(@Nullable LivingEntity entity, Level level, BlockPos pos, BlockState state, boolean pop) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof NestBlockEntity) {
            NestBlockEntity nestBlockEntity = (NestBlockEntity)blockEntity;
            ItemStack eggStack = new ItemStack((ItemLike)nestBlockEntity.getEgg().getItem(), 1);
            nestBlockEntity.removeEgg(entity);
            if (nestBlockEntity.getEgg().isEmpty()) {
                BlockState blockstate = (BlockState)state.setValue((Property)HAS_EGG, (Comparable)Boolean.valueOf(false));
                level.setBlock(pos, blockstate, 3);
                level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)entity, (BlockState)blockstate));
            }
            if (pop) {
                NestBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)eggStack);
            }
            return true;
        }
        return false;
    }

    private static void placeEgg(@Nullable LivingEntity entity, Level level, BlockPos pos, BlockState state, ItemStack stack, boolean addToEgg) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof NestBlockEntity) {
            NestBlockEntity nestBlockEntity = (NestBlockEntity)blockEntity;
            if (addToEgg) {
                nestBlockEntity.addEgg(stack.consumeAndReturn(1, entity), entity);
            } else {
                nestBlockEntity.setEgg(stack.consumeAndReturn(1, entity), entity);
                BlockState blockstate = (BlockState)state.setValue((Property)HAS_EGG, (Comparable)Boolean.valueOf(true));
                level.setBlock(pos, blockstate, 3);
                level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)entity, (BlockState)blockstate));
            }
            level.playSound(null, pos, (SoundEvent)Primal_Sounds.PLACES_EGG.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public boolean isItemPlaceable(ItemStack stack) {
        BlockItem blockItem;
        Item item = stack.getItem();
        return item instanceof BlockItem && (blockItem = (BlockItem)item).getBlock().defaultBlockState().is(Primal_Tags.Block.IS_ANIMAL_EGG);
    }

    public static int getMaxEggAmount(ItemStack eggStack) {
        BlockItem blockItem;
        Block eggBlock;
        Optional<Property> eggPropertyOpt;
        Item item = eggStack.getItem();
        if (item instanceof BlockItem && (eggPropertyOpt = (eggBlock = (blockItem = (BlockItem)item).getBlock()).defaultBlockState().getProperties().stream().filter(property -> property.getName().equals("eggs") && property instanceof IntegerProperty).findFirst()).isPresent()) {
            IntegerProperty property2 = (IntegerProperty)eggPropertyOpt.get();
            return property2.getPossibleValues().stream().max(Integer::compare).orElse(1);
        }
        return 1;
    }

    public static Optional<BlockState> getEggBlockState(ItemStack eggStack) {
        Item item = eggStack.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            Block eggBlock = blockItem.getBlock();
            BlockState eggState = eggBlock.defaultBlockState();
            Optional<Property> eggProperty = eggBlock.defaultBlockState().getProperties().stream().filter(property -> property.getName().equals("eggs") && property instanceof IntegerProperty).findFirst();
            if (eggProperty.isPresent()) {
                eggState = (BlockState)eggBlock.defaultBlockState().setValue((Property)((IntegerProperty)eggProperty.get()), (Comparable)Integer.valueOf(eggStack.getCount()));
            }
            return Optional.of(eggState);
        }
        return Optional.empty();
    }

    public static NestBlockEntity getBlockEntity(Level level, BlockPos pos) {
        return (NestBlockEntity)level.getBlockEntity(pos);
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        VoxelShape defaultBox = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
        if (level instanceof Level) {
            Level level1 = (Level)level;
            if (NestBlock.getBlockEntity(level1, pos) == null || !((Boolean)state.getValue((Property)HAS_EGG)).booleanValue()) {
                return defaultBox;
            }
            ItemStack eggStack = NestBlock.getBlockEntity(level1, pos).getEgg();
            if (NestBlock.getEggBlockState(eggStack).isPresent()) {
                BlockState eggBlock = NestBlock.getEggBlockState(eggStack).get();
                VoxelShape eggShape = eggBlock.getShape(level, pos);
                AABB bounds = eggShape.bounds();
                VoxelShape eggBox = Block.box((double)(bounds.minX * 16.0), (double)(bounds.minY * 16.0 + 4.0), (double)(bounds.minZ * 16.0), (double)(bounds.maxX * 16.0), (double)(bounds.maxY * 16.0 + 4.0), (double)(bounds.maxZ * 16.0));
                defaultBox = Shapes.or((VoxelShape)defaultBox, (VoxelShape)eggBox);
            }
        }
        return defaultBox;
    }

    @NotNull
    protected RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new NestBlockEntity((BlockEntityType)Primal_BlockEntities.NEST_BLOCK_ENTITY.get(), pos, state);
    }

    protected void randomTick(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (NestBlock.getBlockEntity((Level)level, pos) != null) {
            NestBlock.serverTick((Level)level, pos, state, NestBlock.getBlockEntity((Level)level, pos));
        }
    }

    protected boolean isRandomlyTicking(BlockState state) {
        return (Boolean)state.getValue((Property)HAS_EGG);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, NestBlockEntity blockEntity) {
        Optional<BlockState> eggState;
        ItemStack eggStack = blockEntity.getEgg();
        if (!eggStack.isEmpty() && (eggState = NestBlock.getEggBlockState(eggStack)).isPresent() && eggState.get().is(Primal_Tags.Block.IS_ANIMAL_EGG)) {
            Optional<Property> eggProperty = eggState.get().getBlock().defaultBlockState().getProperties().stream().filter(property -> property.getName().equals("eggs") && property instanceof IntegerProperty).findFirst();
            NestBlock.randomEggTick(state, eggState.get(), level, pos, level.getRandom(), eggProperty.orElse(null));
        }
    }

    protected static void randomEggTick(@NotNull BlockState nestState, @NotNull BlockState eggState, @NotNull Level level, @NotNull BlockPos pos, @NotNull RandomSource random, @javax.annotation.Nullable IntegerProperty eggsProperty) {
        if (level.random.nextInt(10) == 0 && (eggState.getBlock() instanceof AnimalEgg || eggState.getBlock() == Blocks.SNIFFER_EGG || eggState.getBlock() == Blocks.TURTLE_EGG)) {
            int i = (Integer)nestState.getValue((Property)HATCH);
            if (i < 2) {
                level.playSound(null, pos, (SoundEvent)Primal_Sounds.EGG_CRACK.get(), SoundSource.BLOCKS, 0.7f, 0.9f + random.nextFloat() * 0.2f);
                level.setBlock(pos, (BlockState)nestState.setValue((Property)HATCH, (Comparable)Integer.valueOf(i + 1)), 2);
                level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)nestState));
            } else {
                level.playSound(null, pos, (SoundEvent)Primal_Sounds.EGG_HATCH.get(), SoundSource.BLOCKS, 0.7f, 0.9f + random.nextFloat() * 0.2f);
                NestBlockEntity nestBlockEntity = NestBlock.getBlockEntity(level, pos);
                if (eggsProperty != null) {
                    for (int j = 0; j < (Integer)eggState.getValue((Property)eggsProperty); ++j) {
                        Turtle turtle;
                        NestBlock.removeEgg(null, level, pos, nestState, false);
                        level.levelEvent(2001, pos, Block.getId((BlockState)nestState));
                        Block block = eggState.getBlock();
                        if (block instanceof AnimalEgg) {
                            AnimalEgg animalEgg = (AnimalEgg)block;
                            Animal animal = (Animal)((EntityType)animalEgg.getAnimal().get()).create(level);
                            if (animal == null) continue;
                            Holder holder = level.getBiome(pos);
                            animal.setAge(-24000);
                            if (animal instanceof VariantHolderPrimal) {
                                VariantHolderPrimal variantWhenHatches = (VariantHolderPrimal)animal;
                                if (animal instanceof VariantHolder) {
                                    VariantHolder variantHolder = (VariantHolder)animal;
                                    VariantHolderPrimal variantHolderCast = variantWhenHatches;
                                    if (variantHolderCast.getRareVariant(animal) != null && variantWhenHatches.getRareVariantProbability(level)) {
                                        variantHolder.setVariant(variantHolderCast.getRareVariant(animal));
                                    } else {
                                        variantHolderCast.setVariantFromBiome(animal, (Holder<Biome>)holder);
                                    }
                                }
                            }
                            animal.moveTo((double)pos.getX() + 0.3 + (double)j * 0.2, (double)(pos.getY() + 1), (double)pos.getZ() + 0.3, 0.0f, 0.0f);
                            level.addFreshEntity((Entity)animal);
                            continue;
                        }
                        if (!(eggState.getBlock() instanceof TurtleEggBlock) || (turtle = (Turtle)EntityType.TURTLE.create(level)) == null) continue;
                        turtle.setAge(-24000);
                        turtle.setHomePos(pos);
                        turtle.moveTo((double)pos.getX() + 0.3 + (double)j * 0.2, (double)(pos.getY() + 1), (double)pos.getZ() + 0.3, 0.0f, 0.0f);
                        level.addFreshEntity((Entity)turtle);
                    }
                } else if (eggState.getBlock() instanceof SnifferEggBlock) {
                    NestBlock.removeEgg(null, level, pos, nestState, false);
                    Sniffer sniffer = (Sniffer)EntityType.SNIFFER.create(level);
                    if (sniffer != null) {
                        Vec3 vec3 = pos.getCenter();
                        sniffer.setBaby(true);
                        sniffer.moveTo(vec3.x(), vec3.y() + 1.0, vec3.z(), Mth.wrapDegrees((float)(level.random.nextFloat() * 360.0f)), 0.0f);
                        level.addFreshEntity((Entity)sniffer);
                    }
                }
                BlockState emptyNestState = (BlockState)((BlockState)nestState.setValue((Property)HAS_EGG, (Comparable)Boolean.valueOf(false))).setValue((Property)HATCH, (Comparable)Integer.valueOf(0));
                level.setBlock(pos, emptyNestState, 3);
                level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)emptyNestState));
                nestBlockEntity.updateBlock();
            }
        }
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }
}

