/*
 * Decompiled with CFR 0.152.
 */
package org.primal.datagen.providers;

import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import org.jetbrains.annotations.NotNull;
import org.primal.block.SeashellsBlock;
import org.primal.registry.Primal_Blocks;

public class Primal_LootTablesBlocksGenerator
extends BlockLootSubProvider {
    public Primal_LootTablesBlocksGenerator(HolderLookup.Provider lookupProvider) {
        super(Set.of(), FeatureFlags.DEFAULT_FLAGS, lookupProvider);
    }

    @NotNull
    protected Iterable<Block> getKnownBlocks() {
        return BuiltInRegistries.BLOCK.entrySet().stream().filter(e -> ((ResourceKey)e.getKey()).location().getNamespace().equals("primal")).map(Map.Entry::getValue).toList();
    }

    public void generate() {
        HolderLookup.RegistryLookup enchantmentRegistryLookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        this.createDropThemselves((Block)Primal_Blocks.SHARK_TOOTH.get(), (Block)Primal_Blocks.STRAW_BALE.get(), (Block)Primal_Blocks.CROCODILE_SCUTE_BLOCK.get(), (Block)Primal_Blocks.CROCODILE_SCUTE_SHINGLE.get(), (Block)Primal_Blocks.CHISELED_CROCODILE_SCUTE.get(), (Block)Primal_Blocks.CROCODILE_SCUTE_STAIRS.get(), (Block)Primal_Blocks.CROCODILE_SCUTE_SLAB.get(), (Block)Primal_Blocks.ARID_CROCODILE_SCUTE_BLOCK.get(), (Block)Primal_Blocks.ARID_CROCODILE_SCUTE_SHINGLE.get(), (Block)Primal_Blocks.ARID_CHISELED_CROCODILE_SCUTE.get(), (Block)Primal_Blocks.ARID_CROCODILE_SCUTE_STAIRS.get(), (Block)Primal_Blocks.ARID_CROCODILE_SCUTE_SLAB.get(), (Block)Primal_Blocks.HUMID_CROCODILE_SCUTE_BLOCK.get(), (Block)Primal_Blocks.HUMID_CROCODILE_SCUTE_SHINGLE.get(), (Block)Primal_Blocks.HUMID_CHISELED_CROCODILE_SCUTE.get(), (Block)Primal_Blocks.HUMID_CROCODILE_SCUTE_STAIRS.get(), (Block)Primal_Blocks.HUMID_CROCODILE_SCUTE_SLAB.get());
        this.createSingleDropShearOrSilkTouch((Block)Primal_Blocks.SHORT_RIVER_REEDS.get());
        this.createSingleDropShearOrSilkTouch((Block)Primal_Blocks.RIVER_REEDS.get());
        this.add((Block)Primal_Blocks.SEASHELLS.get(), this.createSeashellsDrops((Block)Primal_Blocks.SEASHELLS.get()));
        this.dropWhenSilkTouch((Block)Primal_Blocks.CROCODILE_EGG.get());
        this.dropWhenSilkTouch((Block)Primal_Blocks.EAGLE_EGG.get());
        this.add((Block)Primal_Blocks.NEST_BLOCK.get(), this.createSilkTouchOrShearsDispatchTable((Block)Primal_Blocks.NEST_BLOCK.get(), (LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)Primal_Blocks.NEST_BLOCK.get(), (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)3.0f, (float)6.0f))))));
    }

    private void createDropThemselves(Block ... blocks) {
        for (Block holder : blocks) {
            this.dropSelf(holder);
        }
    }

    private void createSingleDropShearOrSilkTouch(Block block) {
        this.add(block, LootTable.lootTable().withPool(LootPool.lootPool().when(HAS_SHEARS).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f))))));
    }

    protected LootTable.Builder createSeashellsDrops(Block seashells) {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)seashells, LootItem.lootTableItem((ItemLike)seashells).apply(IntStream.rangeClosed(1, 4).boxed().toList(), integer -> SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)integer.intValue())).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)seashells).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)SeashellsBlock.AMOUNT, integer.intValue())))))));
    }
}

