/*
 * Decompiled with CFR 0.152.
 */
package org.primal.entity.ai;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalMakeLove;
import net.minecraft.world.entity.ai.behavior.BabyFollowAdult;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.EraseMemoryIf;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.TryFindLand;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.primal.entity.ai.behavior.crocodile.CrocodileBasking;
import org.primal.entity.ai.behavior.crocodile.CrocodileExploding;
import org.primal.entity.ai.behavior.crocodile.CrocodileGoesToCompass;
import org.primal.entity.ai.behavior.crocodile.CrocodileGoesToEgg;
import org.primal.entity.ai.behavior.crocodile.CrocodileGoesToReed;
import org.primal.entity.ai.behavior.crocodile.CrocodileStartAttack;
import org.primal.entity.ai.behavior.crocodile.CrocodileThrash;
import org.primal.entity.ai.behavior.generic.TryFindWaterSurface;
import org.primal.entity.ai.behavior.generic.TryLayEggOnLandOrNest;
import org.primal.entity.animal.CrocodileEntity;
import org.primal.registry.Primal_Activities;
import org.primal.registry.Primal_Blocks;
import org.primal.registry.Primal_Entities;
import org.primal.registry.Primal_MemoryModuleTypes;
import org.primal.registry.Primal_Sensors;
import org.primal.util.MiscUtil;

public class CrocodileAi {
    private static final ImmutableList<SensorType<? extends Sensor<? super CrocodileEntity>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.NEAREST_LIVING_ENTITIES, (Object)SensorType.HURT_BY, (Object)((SensorType)Primal_Sensors.NEAREST_BABY.get()), (Object)SensorType.NEAREST_PLAYERS, (Object)SensorType.NEAREST_ADULT, (Object)((SensorType)Primal_Sensors.CROCODILE_ATTACK_SENSOR.get()), (Object)((SensorType)Primal_Sensors.CROCODILE_TEMPTATIONS_SENSOR.get()), (Object)((SensorType)Primal_Sensors.CROCODILE_NEAREST_EGG.get()), (Object)((SensorType)Primal_Sensors.CROCODILE_NEAREST_REED.get()));
    private static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.NEAREST_LIVING_ENTITIES, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)MemoryModuleType.PATH, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryModuleType.ATTACK_COOLING_DOWN, (Object)MemoryModuleType.NEAREST_ATTACKABLE, (Object)MemoryModuleType.ROAR_TARGET, (Object)MemoryModuleType.HURT_BY, (Object)MemoryModuleType.HURT_BY_ENTITY, (Object[])new MemoryModuleType[]{MemoryModuleType.BREED_TARGET, MemoryModuleType.IS_PANICKING, MemoryModuleType.TEMPTATION_COOLDOWN_TICKS, MemoryModuleType.IS_TEMPTED, MemoryModuleType.TEMPTING_PLAYER, MemoryModuleType.AVOID_TARGET, MemoryModuleType.HAS_HUNTING_COOLDOWN, MemoryModuleType.NEAREST_REPELLENT, MemoryModuleType.IS_PREGNANT, MemoryModuleType.PACIFIED, (MemoryModuleType)Primal_MemoryModuleTypes.WAS_BASKING.get(), (MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_VISIBLE_BABY.get(), (MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_IMPORTANT_BLOCK.get(), MemoryModuleType.ADMIRING_ITEM, (MemoryModuleType)Primal_MemoryModuleTypes.IS_THRASHING.get(), (MemoryModuleType)Primal_MemoryModuleTypes.IS_EXPLODING.get(), (MemoryModuleType)Primal_MemoryModuleTypes.IS_STUNNED.get()});
    private static final UniformInt ADULT_FOLLOW_RANGE = UniformInt.of((int)5, (int)16);
    private static final UniformInt RETREAT_DURATION = TimeUtil.rangeOfSeconds((int)5, (int)20);

    public static Predicate<ItemStack> getTemptations() {
        return CrocodileEntity::isMatingFood;
    }

    public static void initMemories(CrocodileEntity CrocodileEntity2, RandomSource random) {
    }

    public static Brain.Provider<CrocodileEntity> brainProvider() {
        return Brain.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    public static Brain<?> makeBrain(Brain<CrocodileEntity> brain) {
        CrocodileAi.initCoreActivity(brain);
        CrocodileAi.initIdleActivity(brain);
        CrocodileAi.initFightActivity(brain);
        CrocodileAi.initThrashActivity(brain);
        CrocodileAi.initExplosionActivity(brain);
        CrocodileAi.initRetreatActivity(brain);
        CrocodileAi.initLayEggActivity(brain);
        brain.setCoreActivities((Set)ImmutableSet.of((Object)Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.useDefaultActivity();
        return brain;
    }

    private static void initCoreActivity(Brain<CrocodileEntity> brain) {
        brain.addActivity(Activity.CORE, 0, ImmutableList.of((Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink()));
    }

    private static void initIdleActivity(Brain<CrocodileEntity> brain) {
        brain.addActivity(Activity.IDLE, 10, ImmutableList.of((Object)StartAttacking.create(CrocodileAi::findNearestValidAttackTarget), (Object)new AnimalMakeLove((EntityType)Primal_Entities.CROCODILE.get()), TryFindWaterSurface.create(16, 1.0f), (Object)((Object)new CrocodileGoesToCompass()), (Object)((Object)new CrocodileGoesToEgg()), (Object)SetEntityLookTargetSometimes.create((EntityType)EntityType.PLAYER, (float)6.0f, (UniformInt)UniformInt.of((int)30, (int)60)), (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)new FollowTemptation(livingEntity -> Float.valueOf(1.0f), livingEntity -> livingEntity.isBaby() ? 2.5 : 3.5), (Object)4), (Object)Pair.of((Object)BehaviorBuilder.triggerIf(crocodile -> !crocodile.isAggressive() || crocodile.getAirSupply() < 3500, (OneShot)BabyFollowAdult.create((UniformInt)ADULT_FOLLOW_RANGE, (float)1.0f)), (Object)1))), (Object)((Object)new CrocodileGoesToReed()), CrocodileAi.createIdleMovementBehaviors()));
    }

    private static void initFightActivity(Brain<CrocodileEntity> brain) {
        brain.addActivityAndRemoveMemoryWhenStopped(Activity.FIGHT, 10, ImmutableList.of((Object)SetWalkTargetFromAttackTargetIfTargetOutOfReach.create((float)1.0f), (Object)((Object)new CrocodileStartAttack(20)), (Object)SetEntityLookTarget.create((float)50.0f), (Object)StopAttackingIfTargetInvalid.create(), (Object)EraseMemoryIf.create(Animal::isInLove, (MemoryModuleType)MemoryModuleType.ATTACK_TARGET)), MemoryModuleType.ATTACK_TARGET);
    }

    public static void wasHurtBy(CrocodileEntity crocodile, LivingEntity target) {
        Brain<CrocodileEntity> brain = crocodile.getBrain();
        brain.eraseMemory(MemoryModuleType.PACIFIED);
        brain.eraseMemory(MemoryModuleType.BREED_TARGET);
        if (crocodile.isBaby()) {
            CrocodileAi.retreatFromNearestTarget(crocodile, target);
            for (CrocodileEntity nearCrocodile : CrocodileAi.getNearestAdultCrocodiles(crocodile)) {
                nearCrocodile.getBrain().setMemory(MemoryModuleType.ATTACK_TARGET, (Object)target);
            }
        } else {
            crocodile.getBrain().setMemory(MemoryModuleType.ATTACK_TARGET, (Object)target);
        }
    }

    private static List<CrocodileEntity> getNearestAdultCrocodiles(CrocodileEntity crocodile) {
        return crocodile.level().getEntitiesOfClass(CrocodileEntity.class, crocodile.getBoundingBox().inflate(30.0, 5.0, 30.0)).stream().filter(crocodile1 -> !crocodile1.isBaby()).toList();
    }

    private static void retreatFromNearestTarget(CrocodileEntity crocodile, LivingEntity target) {
        Brain<CrocodileEntity> brain = crocodile.getBrain();
        LivingEntity avoidTarget = BehaviorUtils.getNearestTarget((LivingEntity)crocodile, (Optional)brain.getMemory(MemoryModuleType.AVOID_TARGET), (LivingEntity)target);
        avoidTarget = BehaviorUtils.getNearestTarget((LivingEntity)crocodile, (Optional)brain.getMemory(MemoryModuleType.ATTACK_TARGET), (LivingEntity)avoidTarget);
        CrocodileAi.setAvoidTarget(crocodile, avoidTarget);
    }

    private static void setAvoidTarget(CrocodileEntity crocodile, LivingEntity target) {
        crocodile.getBrain().eraseMemory(MemoryModuleType.ATTACK_TARGET);
        crocodile.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        crocodile.getBrain().setMemoryWithExpiry(MemoryModuleType.AVOID_TARGET, (Object)target, (long)RETREAT_DURATION.sample(crocodile.level().random));
    }

    private static void initThrashActivity(Brain<CrocodileEntity> brain) {
        brain.addActivityAndRemoveMemoryWhenStopped((Activity)Primal_Activities.THRASH.get(), 10, ImmutableList.of((Object)((Object)new CrocodileThrash(100))), (MemoryModuleType)Primal_MemoryModuleTypes.IS_THRASHING.get());
    }

    private static void initExplosionActivity(Brain<CrocodileEntity> brain) {
        brain.addActivityAndRemoveMemoryWhenStopped((Activity)Primal_Activities.EXPLODING.get(), 10, ImmutableList.of((Object)((Object)new CrocodileExploding(40))), (MemoryModuleType)Primal_MemoryModuleTypes.IS_EXPLODING.get());
    }

    private static void initRetreatActivity(Brain<CrocodileEntity> brain) {
        brain.addActivityAndRemoveMemoryWhenStopped(Activity.AVOID, 10, ImmutableList.of((Object)SetWalkTargetAwayFrom.entity((MemoryModuleType)MemoryModuleType.AVOID_TARGET, (float)1.2f, (int)20, (boolean)false), CrocodileAi.createIdleMovementBehaviors(), (Object)SetEntityLookTargetSometimes.create((float)8.0f, (UniformInt)UniformInt.of((int)30, (int)60)), (Object)EraseMemoryIf.create(crocodile -> !crocodile.isBaby(), (MemoryModuleType)MemoryModuleType.AVOID_TARGET)), MemoryModuleType.AVOID_TARGET);
    }

    private static void initLayEggActivity(Brain<CrocodileEntity> brain) {
        brain.addActivityWithConditions(Activity.LAY_SPAWN, ImmutableList.of((Object)Pair.of((Object)1, TryLayEggOnLandOrNest.create((Block)Primal_Blocks.CROCODILE_EGG.get(), MiscUtil.EGGS_3, 3, 1)), (Object)Pair.of((Object)2, (Object)TryFindLand.create((int)16, (float)1.0f)), (Object)Pair.of((Object)3, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.stroll((float)1.0f), (Object)2), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.create((float)1.0f, (int)3), (Object)1), (Object)Pair.of((Object)BehaviorBuilder.triggerIf(Entity::onGround), (Object)1))))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.IS_PREGNANT, (Object)MemoryStatus.VALUE_PRESENT)));
    }

    private static RunOne<CrocodileEntity> createIdleMovementBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)((Object)new CrocodileBasking(20)), (Object)1), (Object)Pair.of((Object)BehaviorBuilder.triggerIf(Predicate.not(crocodile -> crocodile.isAggressive() || crocodile.isUnderWater() && crocodile.getAirSupply() > 3500), (OneShot)RandomStroll.stroll((float)1.0f)), (Object)1), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    public static void updateActivity(CrocodileEntity crocodile) {
        Brain<CrocodileEntity> brain = crocodile.getBrain();
        if (crocodile.isBaby()) {
            brain.setActiveActivityToFirstValid((List)ImmutableList.of((Object)((Activity)Primal_Activities.EXPLODING.get()), (Object)Activity.AVOID, (Object)Activity.IDLE));
        } else {
            brain.setActiveActivityToFirstValid((List)ImmutableList.of((Object)((Activity)Primal_Activities.EXPLODING.get()), (Object)((Activity)Primal_Activities.THRASH.get()), (Object)Activity.FIGHT, (Object)Activity.LAY_SPAWN, (Object)Activity.IDLE));
        }
        crocodile.setAggressive(brain.hasMemoryValue(MemoryModuleType.ATTACK_TARGET) || brain.hasMemoryValue((MemoryModuleType)Primal_MemoryModuleTypes.IS_THRASHING.get()));
    }

    private static Optional<? extends LivingEntity> findNearestValidAttackTarget(CrocodileEntity crocodile) {
        return BehaviorUtils.isBreeding((LivingEntity)crocodile) || crocodile.isBaby() || crocodile.isPacified() ? Optional.empty() : crocodile.getBrain().getMemory(MemoryModuleType.NEAREST_ATTACKABLE);
    }
}

