/*
 * Decompiled with CFR 0.152.
 */
package org.primal.entity.ai.sensors.bear;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.NearestLivingEntitySensor;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.primal.entity.ai.sensors.bear.BearRepellentSensor;
import org.primal.entity.animal.BearEntity;
import org.primal.registry.Primal_Tags;

public final class BearAttackEntitySensor
extends NearestLivingEntitySensor<BearEntity> {
    @NotNull
    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.copyOf((Iterable)Iterables.concat((Iterable)super.requires(), List.of(MemoryModuleType.NEAREST_ATTACKABLE)));
    }

    protected void doTick(@NotNull ServerLevel level, @NotNull BearEntity bear) {
        super.doTick(level, (LivingEntity)bear);
        if (bear.isTame()) {
            bear.getBrain().getMemory(MemoryModuleType.NEAREST_LIVING_ENTITIES).stream().flatMap(Collection::stream).filter(target -> {
                BearEntity bear2;
                return Sensor.isEntityAttackable((LivingEntity)bear, (LivingEntity)target) && bear.getOwner() != null && (bear.getOwner().getLastHurtByMob() == target || bear.getOwner().getLastHurtMob() == target && bear.isFollowing()) && (!(target instanceof BearEntity) || (bear2 = (BearEntity)((Object)target)).getOwner() == null || bear2.getOwner() != bear.getOwner());
            }).findFirst().ifPresentOrElse(ent -> bear.getBrain().setMemory(MemoryModuleType.NEAREST_ATTACKABLE, ent), () -> bear.getBrain().eraseMemory(MemoryModuleType.NEAREST_ATTACKABLE));
        } else {
            bear.getBrain().getMemory(MemoryModuleType.NEAREST_LIVING_ENTITIES).stream().flatMap(Collection::stream).filter(target -> {
                ServerLevel serverLevel;
                Level patt0$temp;
                return Sensor.isEntityAttackable((LivingEntity)bear, (LivingEntity)target) && target.getType().is(Primal_Tags.Entity.BEAR_HUNTABLE) && (!((patt0$temp = target.level()) instanceof ServerLevel) || !BearRepellentSensor.findNearestRepellent(serverLevel = (ServerLevel)patt0$temp, target).isPresent());
            }).findFirst().ifPresentOrElse(ent -> bear.getBrain().setMemory(MemoryModuleType.NEAREST_ATTACKABLE, ent), () -> bear.getBrain().eraseMemory(MemoryModuleType.NEAREST_ATTACKABLE));
        }
    }
}

