/*
 * Decompiled with CFR 0.152.
 */
package org.primal.mixin;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.PolarBear;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.primal.Primal_Main;
import org.primal.entity.animal.BearEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoReplacedEntity;
import software.bernie.geckolib.util.RenderUtil;

@Mixin(value={PolarBear.class})
public abstract class PolarBearMixin
extends Animal
implements NeutralMob {
    @Unique
    PolarBear p$THIS = (PolarBear)this;
    @Unique
    AttributeModifier primal$polarBearHealthIncrease = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"primal", (String)"polar_bear_health_increase"), 30.0, AttributeModifier.Operation.ADD_VALUE);

    @Shadow
    public abstract boolean isStanding();

    protected PolarBearMixin(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"registerGoals"}, at={@At(value="HEAD")})
    private void primal$makePolarBearBreedable(CallbackInfo ci) {
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.0, BearEntity.class));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.0, PolarBear.class));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, stack -> stack.is(Items.SALMON_BUCKET), false));
    }

    @Inject(method={"isFood"}, at={@At(value="RETURN")}, cancellable=true)
    private void primal$addPolarBearFoodForMating(ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)((Boolean)cir.getReturnValue() != false || stack.is(Items.SALMON_BUCKET) ? 1 : 0));
    }

    @Inject(method={"getBreedOffspring"}, at={@At(value="HEAD")}, cancellable=true)
    private void primal$makeGrolar(ServerLevel level, AgeableMob otherParent, CallbackInfoReturnable<AgeableMob> cir) {
        BearEntity bear;
        if (otherParent instanceof BearEntity && (bear = (BearEntity)otherParent).getVariant() == BearEntity.Variant.GRIZZLY) {
            cir.setReturnValue((Object)BearEntity.createFromParents((AgeableMob)this.p$THIS, otherParent));
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void primal$triggerAttackAnimation(CallbackInfo ci) {
        if (this.isStanding() && !this.isInWater()) {
            if (!this.level().isClientSide) {
                return;
            }
            GeoAnimatable geoAnimatable = RenderUtil.getReplacedAnimatable((EntityType)this.getType());
            if (geoAnimatable instanceof GeoReplacedEntity) {
                GeoReplacedEntity replacedEntity = (GeoReplacedEntity)geoAnimatable;
                replacedEntity.triggerAnim((Entity)this.p$THIS, "base_controller", "attack");
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void primal$increasesHealth(CallbackInfo ci) {
        AttributeInstance healthAttribute = this.p$THIS.getAttribute(Attributes.MAX_HEALTH);
        if (healthAttribute != null && !healthAttribute.hasModifier(this.primal$polarBearHealthIncrease.id()) && ((Boolean)Primal_Main.COMMON_CONFIG.polarBearIncreasesHealth.get()).booleanValue()) {
            healthAttribute.addPermanentModifier(this.primal$polarBearHealthIncrease);
            this.p$THIS.heal(this.getMaxHealth());
        } else if (healthAttribute != null && healthAttribute.hasModifier(this.primal$polarBearHealthIncrease.id()) && !((Boolean)Primal_Main.COMMON_CONFIG.polarBearIncreasesHealth.get()).booleanValue()) {
            healthAttribute.removeModifier(this.primal$polarBearHealthIncrease);
        }
    }
}

