/*
 * Decompiled with CFR 0.152.
 */
package org.primal.sounds;

import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import org.primal.entity.animal.CrocodileEntity;
import org.primal.registry.Primal_Sounds;

public class CrocodileSplashesSoundInstance
extends AbstractTickableSoundInstance {
    private final CrocodileEntity crocodile;
    private int timer;

    public CrocodileSplashesSoundInstance(CrocodileEntity crocodile) {
        super((SoundEvent)Primal_Sounds.CROCODILE_SPLASHES.get(), SoundSource.HOSTILE, SoundInstance.createUnseededRandom());
        this.crocodile = crocodile;
        this.attenuation = SoundInstance.Attenuation.LINEAR;
        this.looping = true;
        this.delay = 0;
        this.timer = 0;
        this.volume = 1.0f;
        this.pitch = 1.0f;
    }

    public void tick() {
        ++this.timer;
        if ((this.crocodile.isRemoved() || !this.crocodile.isThrashing()) && this.timer > 2 || !this.crocodile.isInWater()) {
            this.stop();
            return;
        }
        this.x = (float)this.crocodile.getX();
        this.y = (float)this.crocodile.getY();
        this.z = (float)this.crocodile.getZ();
    }

    public boolean canPlaySound() {
        return !this.crocodile.isSilent();
    }
}

