/*
 * Decompiled with CFR 0.152.
 */
package org.primal;

import java.util.List;
import net.neoforged.neoforge.common.ModConfigSpec;

public class Primal_Config {
    public final ModConfigSpec.BooleanValue enableBearSingleSpawn;
    public final ModConfigSpec.IntValue bearSingleSpawnWeight;
    public final ModConfigSpec.IntValue bearSingleMinGroup;
    public final ModConfigSpec.IntValue bearSingleMaxGroup;
    public final ModConfigSpec.ConfigValue<List<? extends String>> bearSingleExtraBiomes;
    public final ModConfigSpec.BooleanValue enableBearGroupSpawn;
    public final ModConfigSpec.IntValue bearGroupSpawnWeight;
    public final ModConfigSpec.IntValue bearGroupMinGroup;
    public final ModConfigSpec.IntValue bearGroupMaxGroup;
    public final ModConfigSpec.ConfigValue<List<? extends String>> bearGroupExtraBiomes;
    public final ModConfigSpec.BooleanValue enableCrocodileNormalSpawn;
    public final ModConfigSpec.IntValue crocodileNormalSpawnWeight;
    public final ModConfigSpec.IntValue crocodileNormalMinGroup;
    public final ModConfigSpec.IntValue crocodileNormalMaxGroup;
    public final ModConfigSpec.ConfigValue<List<? extends String>> crocodileNormalExtraBiomes;
    public final ModConfigSpec.BooleanValue enableCrocodileWarmSpawn;
    public final ModConfigSpec.IntValue crocodileWarmSpawnWeight;
    public final ModConfigSpec.IntValue crocodileWarmMinGroup;
    public final ModConfigSpec.IntValue crocodileWarmMaxGroup;
    public final ModConfigSpec.ConfigValue<List<? extends String>> crocodileWarmExtraBiomes;
    public final ModConfigSpec.BooleanValue enableSingleSharkSpawn;
    public final ModConfigSpec.IntValue sharkSingleSpawnWeight;
    public final ModConfigSpec.IntValue sharkSingleMinGroup;
    public final ModConfigSpec.IntValue sharkSingleMaxGroup;
    public final ModConfigSpec.ConfigValue<List<? extends String>> sharkSingleExtraBiomes;
    public final ModConfigSpec.BooleanValue enableSharkGroupSpawn;
    public final ModConfigSpec.IntValue sharkGroupSpawnWeight;
    public final ModConfigSpec.IntValue sharkGroupMinGroup;
    public final ModConfigSpec.IntValue sharkGroupMaxGroup;
    public final ModConfigSpec.ConfigValue<List<? extends String>> sharkGroupExtraBiomes;
    public final ModConfigSpec.BooleanValue polarBearModelChange;
    public final ModConfigSpec.BooleanValue foxModelChange;
    public final ModConfigSpec.BooleanValue riverReedsSpawnInWorld;
    public final ModConfigSpec.IntValue riverReedsPatchRarity;
    public final ModConfigSpec.IntValue riverReedsPatchSpreadXZ;
    public final ModConfigSpec.IntValue riverReedsPatchSpreadY;
    public final ModConfigSpec.ConfigValue<List<? extends String>> riverReedsExtraBiomes;
    public final ModConfigSpec.BooleanValue seaShellsSpawnInWorld;
    public final ModConfigSpec.IntValue seaShellsPatchRarity;
    public final ModConfigSpec.IntValue seaShellsPatchTries;
    public final ModConfigSpec.IntValue seaShellsPatchSpreadXZ;
    public final ModConfigSpec.IntValue seaShellsPatchSpreadY;
    public final ModConfigSpec.ConfigValue<List<? extends String>> seaShellsExtraBiomes;
    public final ModConfigSpec.BooleanValue eagleNestSpawnInWorld;
    public final ModConfigSpec.IntValue eagleNestRarity;
    public final ModConfigSpec.IntValue eagleNestTries;
    public final ModConfigSpec.IntValue eagleNestSpreadXZ;
    public final ModConfigSpec.IntValue eagleNestSpreadY;
    public final ModConfigSpec.ConfigValue<List<? extends String>> eagleNestExtraBiomes;

    public Primal_Config(ModConfigSpec.Builder builder) {
        builder.comment("Mob Settings").push("mob");
        builder.push("replaced_models");
        builder.comment("Toggle model replacements for certain mobs");
        this.polarBearModelChange = builder.define("polarBearModelChange", true);
        this.foxModelChange = builder.define("foxModelChange", true);
        builder.pop();
        builder.comment("Primal Mobs Spawn - tweak natural spawn\n(Eagles only spawn on nests, tweak the nest spawn in world section)");
        builder.push("bear");
        builder.push("single");
        builder.comment("Enable or disable bear single spawning\nDefault=true");
        this.enableBearSingleSpawn = builder.define("enableBearSingleSpawn", true);
        builder.comment("Spawn weight for single bears (higher = more common)\nDefault=20");
        this.bearSingleSpawnWeight = builder.defineInRange("bearSingleSpawnWeight", 20, 1, Integer.MAX_VALUE);
        builder.comment("Minimum group size for single bears, it MUST be lesser than max group size\nDefault=1");
        this.bearSingleMinGroup = builder.defineInRange("bearSingleMinGroup", 1, 1, Integer.MAX_VALUE);
        builder.comment("Maximum group size for single bears, it MUST be greater than min group size\nDefault=1");
        this.bearSingleMaxGroup = builder.defineInRange("bearSingleMaxGroup", 1, 1, Integer.MAX_VALUE);
        builder.comment("Extra biomes (separated from biome tag) where single bears can spawn.\nMust be written as full biome IDs (e.g. \"minecraft:plains\", \"nomansland:maple_forest\").\nDefault = []");
        this.bearSingleExtraBiomes = builder.defineList("bearSingleExtraBiomes", List.of(), o -> {
            String s;
            return o instanceof String && (s = (String)o).contains(":");
        });
        builder.pop();
        builder.push("group");
        builder.comment("Enable or disable bear group spawning (with babies)\nDefault=true");
        this.enableBearGroupSpawn = builder.define("enableBearGroupSpawn", true);
        builder.comment("Spawn weight for bear groups (higher = more common)\nDefault=5");
        this.bearGroupSpawnWeight = builder.defineInRange("bearGroupSpawnWeight", 5, 1, Integer.MAX_VALUE);
        builder.comment("Minimum group size for bear groups, it MUST be lesser than max group size\nDefault=2");
        this.bearGroupMinGroup = builder.defineInRange("bearGroupMinGroup", 2, 1, Integer.MAX_VALUE);
        builder.comment("Maximum group size for bear groups, it MUST be greater than min group size\nDefault=2");
        this.bearGroupMaxGroup = builder.defineInRange("bearGroupMaxGroup", 2, 1, Integer.MAX_VALUE);
        builder.comment("Extra biomes (separated from biome tag) where bear groups can spawn.\nMust be written as full biome IDs (e.g. \"minecraft:plains\", \"nomansland:maple_forest\").\nDefault = []");
        this.bearGroupExtraBiomes = builder.defineList("bearGroupExtraBiomes", List.of(), o -> {
            String s;
            return o instanceof String && (s = (String)o).contains(":");
        });
        builder.pop();
        builder.pop();
        builder.push("crocodile");
        builder.push("normal");
        builder.comment("Enable or disable crocodile spawning in swampy/jungle biomes\nDefault=true");
        this.enableCrocodileNormalSpawn = builder.define("enableCrocodileNormalSpawn", true);
        builder.comment("Spawn weight for crocodiles in swampy/jungle biomes (higher = more common)\nDefault=20");
        this.crocodileNormalSpawnWeight = builder.defineInRange("crocodileNormalSpawnWeight", 20, 1, Integer.MAX_VALUE);
        builder.comment("Minimum group size for crocodiles in swampy/jungle biomes, it MUST be lesser than max group size\nDefault=1");
        this.crocodileNormalMinGroup = builder.defineInRange("crocodileNormalMinGroup", 1, 1, Integer.MAX_VALUE);
        builder.comment("Maximum group size for crocodiles in swampy/jungle biomes, it MUST be greater than min group size\nDefault=1");
        this.crocodileNormalMaxGroup = builder.defineInRange("crocodileNormalMaxGroup", 1, 1, Integer.MAX_VALUE);
        builder.comment("Extra biomes (separated from biome tag) where normal crocodiles can spawn.\nMust be written as full biome IDs (e.g. \"minecraft:plains\", \"nomansland:maple_forest\").\nDefault = []");
        this.crocodileNormalExtraBiomes = builder.defineList("crocodileNormalExtraBiomes", List.of(), o -> {
            String s;
            return o instanceof String && (s = (String)o).contains(":");
        });
        builder.pop();
        builder.push("warm");
        builder.comment("Enable or disable crocodile spawning in warm biomes\nDefault=true");
        this.enableCrocodileWarmSpawn = builder.define("enableCrocodileWarmSpawn", true);
        builder.comment("Spawn weight for crocodiles in warm biomes (higher = more common)\nDefault=3");
        this.crocodileWarmSpawnWeight = builder.defineInRange("crocodileWarmSpawnWeight", 3, 1, Integer.MAX_VALUE);
        builder.comment("Minimum group size for crocodiles in warm biomes, it MUST be lesser than max group size\nDefault=1");
        this.crocodileWarmMinGroup = builder.defineInRange("crocodileWarmMinGroup", 1, 1, Integer.MAX_VALUE);
        builder.comment("Maximum group size for crocodiles in warm biomes, it MUST be greater than min group size\nDefault=1");
        this.crocodileWarmMaxGroup = builder.defineInRange("crocodileWarmMaxGroup", 1, 1, Integer.MAX_VALUE);
        builder.comment("Extra biomes (separated from biome tag) where warm crocodiles can spawn.\nMust be written as full biome IDs (e.g. \"minecraft:plains\", \"nomansland:maple_forest\").\nDefault = []");
        this.crocodileWarmExtraBiomes = builder.defineList("crocodileWarmExtraBiomes", List.of(), o -> {
            String s;
            return o instanceof String && (s = (String)o).contains(":");
        });
        builder.pop();
        builder.pop();
        builder.push("shark");
        builder.push("single");
        builder.comment("Enable or disable single shark spawning\nDefault=true");
        this.enableSingleSharkSpawn = builder.define("enableSingleSharkSpawn", true);
        builder.comment("Spawn weight for single sharks (higher = more common)\nDefault=5");
        this.sharkSingleSpawnWeight = builder.defineInRange("sharkSingleSpawnWeight", 5, 1, Integer.MAX_VALUE);
        builder.comment("Minimum group size for single sharks, it MUST be lesser than max group size\nDefault=1");
        this.sharkSingleMinGroup = builder.defineInRange("sharkSingleMinGroup", 1, 1, Integer.MAX_VALUE);
        builder.comment("Maximum group size for single sharks, it MUST be greater than min group size\nDefault=1");
        this.sharkSingleMaxGroup = builder.defineInRange("sharkSingleMaxGroup", 1, 1, Integer.MAX_VALUE);
        builder.comment("Extra biomes (separated from biome tag) where single sharks can spawn.\nMust be written as full biome IDs (e.g. \"minecraft:plains\", \"nomansland:maple_forest\").\nDefault = []");
        this.sharkSingleExtraBiomes = builder.defineList("sharkSingleExtraBiomes", List.of(), o -> {
            String s;
            return o instanceof String && (s = (String)o).contains(":");
        });
        builder.pop();
        builder.push("group");
        builder.comment("Enable or disable group shark spawning\nDefault=true");
        this.enableSharkGroupSpawn = builder.define("enableSharkGroupSpawn", true);
        builder.comment("Spawn weight for shark groups (higher = more common)\nDefault=1");
        this.sharkGroupSpawnWeight = builder.defineInRange("sharkGroupSpawnWeight", 1, 1, Integer.MAX_VALUE);
        builder.comment("Minimum group size for shark groups, it MUST be lesser than max group size\nDefault=1");
        this.sharkGroupMinGroup = builder.defineInRange("sharkGroupMinGroup", 1, 1, Integer.MAX_VALUE);
        builder.comment("Maximum group size for shark groups, it MUST be greater than min group size\nDefault=3");
        this.sharkGroupMaxGroup = builder.defineInRange("sharkGroupMaxGroup", 3, 1, Integer.MAX_VALUE);
        builder.comment("Extra biomes (separated from biome tag) where shark groups can spawn.\nMust be written as full biome IDs (e.g. \"minecraft:plains\", \"nomansland:maple_forest\").\nDefault = []");
        this.sharkGroupExtraBiomes = builder.defineList("sharkGroupExtraBiomes", List.of(), o -> {
            String s;
            return o instanceof String && (s = (String)o).contains(":");
        });
        builder.pop();
        builder.pop();
        builder.pop();
        builder.comment("World Settings").push("world");
        builder.push("river_reeds");
        builder.comment("Enable or disable river reeds spawning\nDefault=true");
        this.riverReedsSpawnInWorld = builder.define("riverReedsSpawnInWorld", true);
        builder.comment("Patch rarity for river reeds\nDefault=2");
        this.riverReedsPatchRarity = builder.defineInRange("riverReedsPatchRarity", 2, 0, Integer.MAX_VALUE);
        builder.comment("Patch horizontal spread (XZ) for river reeds\nDefault=8");
        this.riverReedsPatchSpreadXZ = builder.defineInRange("riverReedsPatchSpreadXZ", 8, 0, Integer.MAX_VALUE);
        builder.comment("Patch vertical spread (Y) for river reeds\nDefault=5");
        this.riverReedsPatchSpreadY = builder.defineInRange("riverReedsPatchSpreadY", 5, 0, Integer.MAX_VALUE);
        builder.comment("Extra biomes (separated from biome tag) where river reeds can spawn.\nMust be written as full biome IDs (e.g. \"minecraft:plains\", \"nomansland:maple_forest\").\nDefault = []");
        this.riverReedsExtraBiomes = builder.defineList("riverReedsExtraBiomes", List.of(), o -> {
            String s;
            return o instanceof String && (s = (String)o).contains(":");
        });
        builder.pop();
        builder.push("seashells");
        builder.comment("Enable or disable seashells spawning\nDefault=true");
        this.seaShellsSpawnInWorld = builder.define("seaShellsSpawnInWorld", true);
        builder.comment("Patch rarity for seashells\nDefault=5");
        this.seaShellsPatchRarity = builder.defineInRange("seaShellsPatchRarity", 5, 0, Integer.MAX_VALUE);
        builder.comment("Number of tries per patch for seashells\nDefault=96");
        this.seaShellsPatchTries = builder.defineInRange("seaShellsPatchTries", 96, 0, Integer.MAX_VALUE);
        builder.comment("Patch horizontal spread (XZ) for seashells\nDefault=6");
        this.seaShellsPatchSpreadXZ = builder.defineInRange("seaShellsPatchSpreadXZ", 6, 0, Integer.MAX_VALUE);
        builder.comment("Patch vertical spread (Y) for seashells\nDefault=2");
        this.seaShellsPatchSpreadY = builder.defineInRange("seaShellsPatchSpreadY", 2, 0, Integer.MAX_VALUE);
        builder.comment("Extra biomes (separated from biome tag) where seashells can spawn.\nMust be written as full biome IDs (e.g. \"minecraft:plains\", \"nomansland:maple_forest\").\nDefault = []");
        this.seaShellsExtraBiomes = builder.defineList("seaShellsExtraBiomes", List.of(), o -> {
            String s;
            return o instanceof String && (s = (String)o).contains(":");
        });
        builder.pop();
        builder.push("eagle_nest");
        builder.comment("Enable or disable eagle nest spawning\nDefault=true");
        this.eagleNestSpawnInWorld = builder.define("eagleNestSpawnInWorld", true);
        builder.comment("Rarity of eagle nests (higher = rarer)\nDefault=30");
        this.eagleNestRarity = builder.defineInRange("eagleNestRarity", 30, 0, Integer.MAX_VALUE);
        builder.comment("Number of tries per patch for eagle nests\nDefault=12");
        this.eagleNestTries = builder.defineInRange("eagleNestTries", 12, 0, Integer.MAX_VALUE);
        builder.comment("Patch horizontal spread (XZ) for eagle nests\nDefault=1");
        this.eagleNestSpreadXZ = builder.defineInRange("eagleNestSpreadXZ", 1, 0, Integer.MAX_VALUE);
        builder.comment("Patch vertical spread (Y) for eagle nests\nDefault=0");
        this.eagleNestSpreadY = builder.defineInRange("eagleNestSpreadY", 0, 0, Integer.MAX_VALUE);
        builder.comment("Extra biomes (separated from biome tag) where eagle nests can spawn.\nMust be written as full biome IDs (e.g. \"minecraft:plains\", \"nomansland:maple_forest\").\nDefault = []");
        this.eagleNestExtraBiomes = builder.defineList("eagleNestExtraBiomes", List.of(), o -> {
            String s;
            return o instanceof String && (s = (String)o).contains(":");
        });
        builder.pop();
        builder.pop();
    }
}

