/*
 * Decompiled with CFR 0.152.
 */
package org.primal.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;
import org.primal.block.RiverReeds;
import org.primal.block.properties.TripleBlockHalf;
import org.primal.registry.Primal_Blocks;
import org.primal.registry.Primal_Tags;

public class ShortRiverReeds
extends BushBlock
implements BonemealableBlock,
SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final MapCodec<ShortRiverReeds> CODEC = ShortRiverReeds.simpleCodec(ShortRiverReeds::new);

    public ShortRiverReeds(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        boolean isUnderwater = fluidstate.getType() == Fluids.WATER;
        return (BlockState)super.getStateForPlacement(context).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isUnderwater));
    }

    @NotNull
    protected BlockState updateShape(BlockState state, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor level, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    @NotNull
    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected boolean canSurvive(@NotNull BlockState state, @NotNull LevelReader level, @NotNull BlockPos pos) {
        FluidState fluidstate = level.getFluidState(pos);
        return super.canSurvive(state, level, pos) || super.canSurvive(state, level, pos) && fluidstate.is((Fluid)Fluids.WATER) && fluidstate.getAmount() == 8;
    }

    protected boolean mayPlaceOn(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return super.mayPlaceOn(state, level, pos) || state.is(Primal_Tags.RIVER_REED_SOIL);
    }

    public boolean isValidBonemealTarget(@NotNull LevelReader level, @NotNull BlockPos pos, @NotNull BlockState state) {
        return RiverReeds.isValidPosForRiverReed(level, pos.above());
    }

    public boolean isBonemealSuccess(@NotNull Level level, @NotNull RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state) {
        return true;
    }

    public void performBonemeal(@NotNull ServerLevel level, @NotNull RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state) {
        boolean spawnTriple;
        BlockState defaultState = ((Block)Primal_Blocks.RIVER_REEDS.get()).defaultBlockState();
        BlockState lowerRiverReed = (BlockState)defaultState.setValue(RiverReeds.HALF, (Comparable)((Object)TripleBlockHalf.LOWER));
        BlockState middleRiverReed = (BlockState)defaultState.setValue(RiverReeds.HALF, (Comparable)((Object)TripleBlockHalf.MIDDLE));
        BlockState upperRiverReed = (BlockState)defaultState.setValue(RiverReeds.HALF, (Comparable)((Object)TripleBlockHalf.UPPER));
        BlockPos posAbove = pos.above();
        BlockPos posAboveAbove = pos.above().above();
        boolean bl = spawnTriple = level.getRandom().nextBoolean() && level.getFluidState(pos).getType() == Fluids.WATER;
        if (spawnTriple && RiverReeds.isValidPosForRiverReed((LevelReader)level, posAboveAbove)) {
            if (level.getFluidState(pos).getType() == Fluids.WATER) {
                lowerRiverReed = (BlockState)lowerRiverReed.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true));
            }
            if (level.getFluidState(posAbove).getType() == Fluids.WATER) {
                middleRiverReed = (BlockState)middleRiverReed.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true));
            }
            if (level.getFluidState(posAboveAbove).getType() == Fluids.WATER) {
                upperRiverReed = (BlockState)upperRiverReed.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true));
            }
            level.setBlock(pos, lowerRiverReed, 2);
            level.setBlock(posAbove, middleRiverReed, 2);
            level.setBlock(posAboveAbove, upperRiverReed, 2);
        } else {
            if (level.getFluidState(pos).getType() == Fluids.WATER) {
                lowerRiverReed = (BlockState)lowerRiverReed.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true));
            }
            if (level.getFluidState(posAbove).getType() == Fluids.WATER) {
                upperRiverReed = (BlockState)upperRiverReed.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true));
            }
            level.setBlock(pos, lowerRiverReed, 2);
            level.setBlock(posAbove, upperRiverReed, 2);
        }
    }

    @NotNull
    protected MapCodec<? extends BushBlock> codec() {
        return CODEC;
    }

    protected void randomTick(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (!level.isAreaLoaded(pos, 1)) {
            return;
        }
        if (level.getRawBrightness(pos, 0) >= 6 && level.getRandom().nextIntBetweenInclusive(1, 50) == 1) {
            this.performBonemeal(level, random, pos, state);
        }
    }

    protected boolean isRandomlyTicking(@NotNull BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED);
    }
}

