/*
 * Decompiled with CFR 0.152.
 */
package org.primal.datagen.providers;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.critereon.ConsumeItemTrigger;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntityTypePredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.TameAnimalTrigger;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.data.AdvancementProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;
import org.primal.advancements.criterion.Primal_CustomCriterion;
import org.primal.advancements.criterion.SharkKillsEntity;
import org.primal.entity.animal.BearEntity;
import org.primal.entity.animal.EagleEntity;
import org.primal.registry.Primal_Advancements;
import org.primal.registry.Primal_Entities;
import org.primal.registry.Primal_Items;

public class Primal_AdvancementsGenerator
extends AdvancementProvider {
    public Primal_AdvancementsGenerator(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, ExistingFileHelper existingFileHelper) {
        super(output, lookupProvider, existingFileHelper, List.of(new Generator()));
    }

    private static Advancement.Builder addMarineAnimalsToFeedShark(Advancement.Builder builder) {
        Primal_Advancements.ANIMALS_SHARK_NEEDS_TO_KILL.forEach(marineEntity -> builder.addCriterion(EntityType.getKey((EntityType)marineEntity).toString(), SharkKillsEntity.Conditions.create(EntityPredicate.Builder.entity().of(marineEntity))));
        return builder;
    }

    private static final class Generator
    implements AdvancementProvider.AdvancementGenerator {
        private Generator() {
        }

        public void generate(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider registries, @NotNull Consumer<AdvancementHolder> consumer, @NotNull ExistingFileHelper existingFileHelper) {
            AdvancementHolder tameBear = Advancement.Builder.advancement().parent(ResourceLocation.withDefaultNamespace((String)"husbandry/tame_an_animal")).display((ItemLike)Items.HONEYCOMB, (Component)Component.translatable((String)"advancements.primal.tame_bear.title"), (Component)Component.translatable((String)"advancements.primal.tame_bear.description"), null, AdvancementType.GOAL, true, true, false).addCriterion("tame_bear", TameAnimalTrigger.TriggerInstance.tamedAnimal((EntityPredicate.Builder)EntityPredicate.Builder.entity().entityType(EntityTypePredicate.of((EntityType)((EntityType)Primal_Entities.BEAR.get()))))).save(consumer, "primal/tame_bear");
            Advancement.Builder.advancement().parent(tameBear).display((ItemLike)Items.BARREL, (Component)Component.translatable((String)"advancements.primal.tame_all_bears.title"), (Component)Component.translatable((String)"advancements.primal.tame_all_bears.description"), null, AdvancementType.CHALLENGE, true, true, false).rewards(AdvancementRewards.Builder.experience((int)50)).addCriterion("tame_grizzly", TameAnimalTrigger.TriggerInstance.tamedAnimal((EntityPredicate.Builder)Primal_Advancements.bearVariantTamed(BearEntity.Variant.GRIZZLY))).addCriterion("tame_grolar", TameAnimalTrigger.TriggerInstance.tamedAnimal((EntityPredicate.Builder)Primal_Advancements.bearVariantTamed(BearEntity.Variant.GROLAR))).addCriterion("tame_warm", TameAnimalTrigger.TriggerInstance.tamedAnimal((EntityPredicate.Builder)Primal_Advancements.bearVariantTamed(BearEntity.Variant.WARM))).save(consumer, "primal/tame_all_bears");
            Advancement.Builder.advancement().parent(ResourceLocation.withDefaultNamespace((String)"husbandry/root")).display((ItemLike)Items.WATER_BUCKET, (Component)Component.translatable((String)"advancements.primal.survive_shark.title"), (Component)Component.translatable((String)"advancements.primal.survive_shark.description"), null, AdvancementType.GOAL, true, true, false).addCriterion("survive_shark", Primal_CustomCriterion.Conditions.createSurviveShark()).save(consumer, "primal/survive_shark");
            Primal_AdvancementsGenerator.addMarineAnimalsToFeedShark(Advancement.Builder.advancement()).parent(ResourceLocation.withDefaultNamespace((String)"husbandry/root")).display((ItemLike)Primal_Items.SHARK_TOOTH.get(), (Component)Component.translatable((String)"advancements.primal.feed_shark.title"), (Component)Component.translatable((String)"advancements.primal.feed_shark.description"), null, AdvancementType.CHALLENGE, true, true, false).rewards(AdvancementRewards.Builder.experience((int)100)).save(consumer, "primal/feed_shark");
            Advancement.Builder.advancement().parent(ResourceLocation.withDefaultNamespace((String)"husbandry/root")).display((ItemLike)Items.HEART_OF_THE_SEA, (Component)Component.translatable((String)"advancements.primal.swim_with_shark.title"), (Component)Component.translatable((String)"advancements.primal.swim_with_shark.description"), null, AdvancementType.GOAL, true, true, false).addCriterion("swim_with_shark", Primal_CustomCriterion.Conditions.createSwimWithShark()).save(consumer, "primal/swim_with_shark");
            Advancement.Builder.advancement().parent(ResourceLocation.withDefaultNamespace((String)"husbandry/root")).display((ItemLike)Primal_Items.CROCODILE_SCUTE.get(), (Component)Component.translatable((String)"advancements.primal.punch_crocodile.title"), (Component)Component.translatable((String)"advancements.primal.punch_crocodile.description"), null, AdvancementType.TASK, true, true, false).addCriterion("punch_crocodile", Primal_CustomCriterion.Conditions.createPunchCrocodile()).save(consumer, "primal/punch_crocodile");
            Advancement.Builder.advancement().parent(ResourceLocation.withDefaultNamespace((String)"husbandry/root")).display((ItemLike)Items.CLOCK, (Component)Component.translatable((String)"advancements.primal.clock_croc.title"), (Component)Component.translatable((String)"advancements.primal.clock_croc.description"), null, AdvancementType.CHALLENGE, true, true, true).addCriterion("clock_croc", Primal_CustomCriterion.Conditions.createClockCroc()).save(consumer, "primal/clock_croc");
            Advancement.Builder.advancement().parent(ResourceLocation.withDefaultNamespace((String)"husbandry/root")).display((ItemLike)Items.FEATHER, (Component)Component.translatable((String)"advancements.primal.tickle_crocodile.title"), (Component)Component.translatable((String)"advancements.primal.tickle_crocodile.description"), null, AdvancementType.TASK, true, true, false).addCriterion("tickle_crocodile", Primal_CustomCriterion.Conditions.createTickleCrocodile()).save(consumer, "primal/tickle_crocodile");
            HolderLookup.RegistryLookup registrylookup = registries.lookupOrThrow(Registries.BANNER_PATTERN);
            Advancement.Builder.advancement().parent(ResourceLocation.withDefaultNamespace((String)"husbandry/root")).display(Raid.getLeaderBannerInstance((HolderGetter)registrylookup), (Component)Component.translatable((String)"advancements.primal.kill_captain.title"), (Component)Component.translatable((String)"advancements.primal.kill_captain.description"), null, AdvancementType.GOAL, true, true, false).addCriterion("kill_captain", Primal_CustomCriterion.Conditions.createKillCaptain()).save(consumer, "primal/kill_captain");
            Advancement.Builder.advancement().parent(ResourceLocation.withDefaultNamespace((String)"husbandry/tame_an_animal")).display((ItemLike)Items.EGG, (Component)Component.translatable((String)"advancements.primal.tame_all_birds.title"), (Component)Component.translatable((String)"advancements.primal.tame_all_birds.description"), null, AdvancementType.CHALLENGE, true, true, false).rewards(AdvancementRewards.Builder.experience((int)50)).addCriterion("tame_bald", TameAnimalTrigger.TriggerInstance.tamedAnimal((EntityPredicate.Builder)Primal_Advancements.eagleVariantTamed(EagleEntity.Variant.BALD))).addCriterion("tame_harpy", TameAnimalTrigger.TriggerInstance.tamedAnimal((EntityPredicate.Builder)Primal_Advancements.eagleVariantTamed(EagleEntity.Variant.HARPY))).addCriterion("tame_philippine", TameAnimalTrigger.TriggerInstance.tamedAnimal((EntityPredicate.Builder)Primal_Advancements.eagleVariantTamed(EagleEntity.Variant.PHILIPPINE))).addCriterion("tame_golden", TameAnimalTrigger.TriggerInstance.tamedAnimal((EntityPredicate.Builder)Primal_Advancements.eagleVariantTamed(EagleEntity.Variant.GOLDEN))).addCriterion("tame_blue", TameAnimalTrigger.TriggerInstance.tamedAnimal((EntityPredicate.Builder)Primal_Advancements.parrotVariantTamed(Parrot.Variant.BLUE))).addCriterion("tame_gray", TameAnimalTrigger.TriggerInstance.tamedAnimal((EntityPredicate.Builder)Primal_Advancements.parrotVariantTamed(Parrot.Variant.GRAY))).addCriterion("tame_green", TameAnimalTrigger.TriggerInstance.tamedAnimal((EntityPredicate.Builder)Primal_Advancements.parrotVariantTamed(Parrot.Variant.GREEN))).addCriterion("tame_red_blue", TameAnimalTrigger.TriggerInstance.tamedAnimal((EntityPredicate.Builder)Primal_Advancements.parrotVariantTamed(Parrot.Variant.RED_BLUE))).addCriterion("tame_yellow_blue", TameAnimalTrigger.TriggerInstance.tamedAnimal((EntityPredicate.Builder)Primal_Advancements.parrotVariantTamed(Parrot.Variant.YELLOW_BLUE))).save(consumer, "primal/tame_all_birds");
            Advancement.Builder.advancement().parent(ResourceLocation.withDefaultNamespace((String)"husbandry/root")).display((ItemLike)Primal_Items.EAGLE_EGG.get(), (Component)Component.translatable((String)"advancements.primal.get_eagle_egg.title"), (Component)Component.translatable((String)"advancements.primal.get_eagle_egg.description"), null, AdvancementType.TASK, true, true, false).addCriterion("eagle_egg", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)Primal_Items.EAGLE_EGG.get()})).save(consumer, "primal/get_eagle_egg");
            Advancement.Builder.advancement().parent(ResourceLocation.withDefaultNamespace((String)"husbandry/root")).display((ItemLike)Primal_Items.APPLE_FRITTER.get(), (Component)Component.translatable((String)"advancements.primal.eat_apple_fritter.title"), (Component)Component.translatable((String)"advancements.primal.eat_apple_fritter.description"), null, AdvancementType.GOAL, true, true, false).addCriterion("eat_apple_fritter", ConsumeItemTrigger.TriggerInstance.usedItem((ItemLike)((ItemLike)Primal_Items.APPLE_FRITTER.get()))).save(consumer, "primal/eat_apple_fritter");
        }
    }
}

