/*
 * Decompiled with CFR 0.152.
 */
package org.primal.entity.ai;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.EraseMemoryIf;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.RandomLookAround;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;
import org.primal.advancements.criterion.Primal_CustomCriterion;
import org.primal.entity.ai.behavior.generic.TriesReturnToWater;
import org.primal.entity.ai.behavior.shark.SharkFollowConduitPlayer;
import org.primal.entity.ai.behavior.shark.SharkGoesToConduit;
import org.primal.entity.ai.behavior.shark.SharkJumpOutWater;
import org.primal.entity.animal.SharkEntity;
import org.primal.registry.Primal_Activities;
import org.primal.registry.Primal_Advancements;
import org.primal.registry.Primal_MemoryModuleTypes;
import org.primal.registry.Primal_Sensors;

public class SharkAi {
    protected static final ImmutableList<SensorType<? extends Sensor<? super SharkEntity>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.NEAREST_LIVING_ENTITIES, (Object)SensorType.NEAREST_PLAYERS, (Object)SensorType.HURT_BY, (Object)SensorType.FROG_TEMPTATIONS, (Object)((SensorType)Primal_Sensors.SHARK_ATTACK_SENSOR.get()), (Object)((SensorType)Primal_Sensors.SHARK_NEAR_CONDUIT_PLAYER.get()), (Object)((SensorType)Primal_Sensors.SHARK_NEAREST_CONDUIT.get()));
    protected static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)MemoryModuleType.PATH, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryModuleType.ATTACK_COOLING_DOWN, (Object)MemoryModuleType.NEAREST_ATTACKABLE, (Object)MemoryModuleType.HURT_BY, (Object)MemoryModuleType.HURT_BY_ENTITY, (Object)MemoryModuleType.BREED_TARGET, (Object)MemoryModuleType.IS_PANICKING, (Object[])new MemoryModuleType[]{MemoryModuleType.TEMPTATION_COOLDOWN_TICKS, MemoryModuleType.IS_TEMPTED, MemoryModuleType.TEMPTING_PLAYER, MemoryModuleType.AVOID_TARGET, MemoryModuleType.HAS_HUNTING_COOLDOWN, (MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_CONDUIT_PLAYER.get(), (MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_IMPORTANT_BLOCK.get(), MemoryModuleType.ADMIRING_ITEM, (MemoryModuleType)Primal_MemoryModuleTypes.LAST_ATTACK_TARGET.get()});
    private static final UniformInt ADULT_FOLLOW_RANGE = UniformInt.of((int)5, (int)16);
    private static final UniformInt RETREAT_DURATION = TimeUtil.rangeOfSeconds((int)5, (int)20);

    private static void initMemories(SharkEntity SharkEntity2, RandomSource random) {
    }

    public static Brain.Provider<SharkEntity> brainProvider() {
        return Brain.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    public static Brain<?> makeBrain(Brain<SharkEntity> brain) {
        SharkAi.initCoreActivity(brain);
        SharkAi.initIdleActivity(brain);
        SharkAi.initFightActivity(brain);
        SharkAi.initRetreatActivity(brain);
        SharkAi.initBeachedActivity(brain);
        SharkAi.initJockeyActivity(brain);
        brain.setCoreActivities((Set)ImmutableSet.of((Object)Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.useDefaultActivity();
        return brain;
    }

    private static void initCoreActivity(Brain<SharkEntity> brain) {
        brain.addActivity(Activity.CORE, 0, ImmutableList.of((Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), (Object)((Object)new TriesReturnToWater()), (Object)EraseMemoryIf.create(shark -> shark.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).isPresent() && !shark.canAttack((LivingEntity)shark.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).get()), (MemoryModuleType)MemoryModuleType.ATTACK_TARGET)));
    }

    private static void initIdleActivity(Brain<SharkEntity> brain) {
        brain.addActivity(Activity.IDLE, 10, ImmutableList.of((Object)StartAttacking.create(SharkAi::findNearestValidAttackTarget), (Object)((Object)new SharkFollowConduitPlayer()), (Object)((Object)new SharkGoesToConduit()), (Object)SetEntityLookTargetSometimes.create((EntityType)EntityType.PLAYER, (float)6.0f, (UniformInt)UniformInt.of((int)30, (int)60)), (Object)new FollowTemptation(p_218740_ -> Float.valueOf(1.25f)), SharkAi.createIdleMovementBehaviors()));
    }

    private static void initBeachedActivity(Brain<SharkEntity> brain) {
        brain.addActivity((Activity)Primal_Activities.BEACHED.get(), 10, ImmutableList.of(SharkAi.createIdleMovementBehaviors()));
    }

    private static void initFightActivity(Brain<SharkEntity> brain) {
        brain.addActivityAndRemoveMemoryWhenStopped(Activity.FIGHT, 10, ImmutableList.of((Object)((Object)new SharkJumpOutWater()), (Object)SetWalkTargetFromAttackTargetIfTargetOutOfReach.create((float)1.0f), (Object)MeleeAttack.create((int)20), (Object)SetEntityLookTarget.create((float)50.0f), (Object)StopAttackingIfTargetInvalid.create()), MemoryModuleType.ATTACK_TARGET);
    }

    private static void initRetreatActivity(Brain<SharkEntity> brain) {
        brain.addActivityAndRemoveMemoryWhenStopped(Activity.AVOID, 10, ImmutableList.of((Object)SetWalkTargetAwayFrom.entity((MemoryModuleType)MemoryModuleType.AVOID_TARGET, (float)1.0f, (int)10, (boolean)false), SharkAi.createIdleMovementBehaviors(), (Object)SetEntityLookTargetSometimes.create((float)8.0f, (UniformInt)UniformInt.of((int)30, (int)60))), MemoryModuleType.AVOID_TARGET);
    }

    private static void initJockeyActivity(Brain<SharkEntity> brain) {
        brain.addActivity((Activity)Primal_Activities.JOCKEY.get(), 10, ImmutableList.of((Object)new RandomLookAround((IntProvider)UniformInt.of((int)150, (int)250), 30.0f, 0.0f, 0.0f)));
    }

    private static RunOne<SharkEntity> createIdleMovementBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)BehaviorBuilder.triggerIf(Predicate.not(Mob::isAggressive), (OneShot)RandomStroll.stroll((float)1.0f)), (Object)1), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    public static void wasHurtBy(SharkEntity bear, LivingEntity target) {
        Brain<SharkEntity> brain = bear.getBrain();
        brain.eraseMemory(MemoryModuleType.BREED_TARGET);
        if (bear.isBaby()) {
            SharkAi.retreatFromNearestTarget(bear, target);
        } else {
            bear.getBrain().setMemory(MemoryModuleType.ATTACK_TARGET, (Object)target);
        }
    }

    private static void retreatFromNearestTarget(SharkEntity bear, LivingEntity target) {
        Brain<SharkEntity> brain = bear.getBrain();
        LivingEntity avoidTarget = BehaviorUtils.getNearestTarget((LivingEntity)bear, (Optional)brain.getMemory(MemoryModuleType.AVOID_TARGET), (LivingEntity)target);
        avoidTarget = BehaviorUtils.getNearestTarget((LivingEntity)bear, (Optional)brain.getMemory(MemoryModuleType.ATTACK_TARGET), (LivingEntity)avoidTarget);
        SharkAi.setAvoidTarget(bear, avoidTarget);
    }

    private static void setAvoidTarget(SharkEntity bear, LivingEntity target) {
        bear.getBrain().eraseMemory(MemoryModuleType.ATTACK_TARGET);
        bear.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        bear.getBrain().setMemoryWithExpiry(MemoryModuleType.AVOID_TARGET, (Object)target, (long)RETREAT_DURATION.sample(bear.level().random));
    }

    public static void updateActivity(SharkEntity shark) {
        Brain<SharkEntity> brain = shark.getBrain();
        if (shark.isBaby()) {
            brain.setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.AVOID, (Object)Activity.IDLE));
        } else if (shark.shouldBeBeached()) {
            brain.setActiveActivityToFirstValid((List)ImmutableList.of((Object)((Activity)Primal_Activities.BEACHED.get())));
        } else {
            if (shark.isSharkJockey()) {
                brain.setActiveActivityToFirstValid((List)ImmutableList.of((Object)((Activity)Primal_Activities.JOCKEY.get())));
            } else {
                brain.setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.AVOID, (Object)Activity.FIGHT, (Object)Activity.IDLE));
            }
            shark.setAggressive(brain.hasMemoryValue(MemoryModuleType.ATTACK_TARGET));
        }
        SharkAi.triggerSurviveSharkAdvancement(brain, shark);
    }

    private static void triggerSurviveSharkAdvancement(Brain<SharkEntity> brain, SharkEntity shark) {
        ServerPlayer player;
        LivingEntity last_target;
        if (brain.getMemory(MemoryModuleType.ATTACK_TARGET).isPresent()) {
            brain.setMemoryWithExpiry((MemoryModuleType)Primal_MemoryModuleTypes.LAST_ATTACK_TARGET.get(), (Object)((LivingEntity)brain.getMemory(MemoryModuleType.ATTACK_TARGET).get()), 200L);
        }
        if (brain.getMemory((MemoryModuleType)Primal_MemoryModuleTypes.LAST_ATTACK_TARGET.get()).isPresent() && (last_target = (LivingEntity)brain.getMemory((MemoryModuleType)Primal_MemoryModuleTypes.LAST_ATTACK_TARGET.get()).get()) instanceof ServerPlayer && !shark.canAttack((LivingEntity)(player = (ServerPlayer)last_target)) && player.getHealth() >= player.getMaxHealth() && player.getLastHurtByMob() instanceof SharkEntity) {
            ((Primal_CustomCriterion)((Object)Primal_Advancements.SURVIVE_SHARK.get())).trigger(player);
        }
    }

    private static Optional<? extends LivingEntity> findNearestValidAttackTarget(SharkEntity shark) {
        return BehaviorUtils.isBreeding((LivingEntity)shark) ? Optional.empty() : shark.getBrain().getMemory(MemoryModuleType.NEAREST_ATTACKABLE);
    }
}

