/*
 * Decompiled with CFR 0.152.
 */
package org.primal.entity.ai.behavior.generic;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import org.jetbrains.annotations.NotNull;

public class BirdAvoidWhileAscending
extends Behavior<LivingEntity> {
    public BirdAvoidWhileAscending() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.AVOID_TARGET, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.IS_PANICKING, (Object)MemoryStatus.VALUE_ABSENT));
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel level, @NotNull LivingEntity owner) {
        return !owner.isBaby();
    }

    protected void start(@NotNull ServerLevel level, @NotNull LivingEntity entity, long gameTime) {
        BehaviorUtils.setWalkAndLookTargetMemories((LivingEntity)entity, (BlockPos)entity.getOnPos().offset(level.random.nextInt(0, 5), level.random.nextInt(3, 8), level.random.nextInt(0, 5)), (float)1.0f, (int)4);
    }

    protected void stop(@NotNull ServerLevel level, @NotNull LivingEntity entity, long gameTime) {
        entity.getBrain().setMemoryWithExpiry(MemoryModuleType.IS_PANICKING, (Object)true, 80L);
    }
}

