/*
 * Decompiled with CFR 0.152.
 */
package org.primal.entity.ai.sensors.shark;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.NearestLivingEntitySensor;
import net.minecraft.world.entity.ai.sensing.Sensor;
import org.jetbrains.annotations.NotNull;
import org.primal.entity.animal.SharkEntity;

public final class SharkAttackEntitySensor
extends NearestLivingEntitySensor<SharkEntity> {
    @NotNull
    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.copyOf((Iterable)Iterables.concat((Iterable)super.requires(), List.of(MemoryModuleType.NEAREST_ATTACKABLE)));
    }

    protected void doTick(@NotNull ServerLevel level, @NotNull SharkEntity shark) {
        super.doTick(level, (LivingEntity)shark);
        shark.getBrain().getMemory(MemoryModuleType.NEAREST_LIVING_ENTITIES).stream().flatMap(Collection::stream).filter(target -> Sensor.isEntityAttackable((LivingEntity)shark, (LivingEntity)target) && shark.canAttack((LivingEntity)target)).findFirst().ifPresentOrElse(ent -> shark.getBrain().setMemory(MemoryModuleType.NEAREST_ATTACKABLE, ent), () -> shark.getBrain().eraseMemory(MemoryModuleType.NEAREST_ATTACKABLE));
    }
}

