/*
 * Decompiled with CFR 0.152.
 */
package org.primal.mixin;

import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.PatrollingMonster;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import org.primal.advancements.criterion.Primal_CustomCriterion;
import org.primal.entity.animal.EagleEntity;
import org.primal.registry.Primal_Advancements;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Raider.class})
public abstract class RaiderMixin
extends PatrollingMonster {
    @Shadow
    public abstract boolean isCaptain();

    protected RaiderMixin(EntityType<? extends PatrollingMonster> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"die"}, at={@At(value="HEAD")})
    private void primal$triggerAdvancement(DamageSource cause, CallbackInfo ci) {
        List nearEagles;
        if (this.isCaptain() && !(nearEagles = this.level().getEntitiesOfClass(EagleEntity.class, this.getBoundingBox().inflate(30.0), eagle -> eagle.isTame() && eagle.isFollowing())).isEmpty()) {
            for (EagleEntity eagle2 : nearEagles) {
                LivingEntity livingEntity;
                if (eagle2.getOwner() == null || !((livingEntity = eagle2.getOwner()) instanceof ServerPlayer)) continue;
                ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                this.primal$triggerAdvancementKillCaptain(serverPlayer);
            }
        }
    }

    @Unique
    private void primal$triggerAdvancementKillCaptain(ServerPlayer serverPlayer) {
        ((Primal_CustomCriterion)((Object)Primal_Advancements.KILL_CAPTAIN.get())).trigger(serverPlayer);
    }
}

