/*
 * Decompiled with CFR 0.152.
 */
package org.primal.block;

import java.util.function.BiFunction;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class SeashellsBlock
extends Block {
    public static final IntegerProperty AMOUNT = IntegerProperty.m_61631_((String)"seashells_amount", (int)1, (int)4);
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final BiFunction<Direction, Integer, VoxelShape> SHAPE_BY_PROPERTIES = Util.m_143821_((direction, integer) -> {
        VoxelShape[] avoxelshape = new VoxelShape[]{Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)16.0, (double)1.0, (double)16.0), Block.m_49796_((double)7.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)9.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)9.0, (double)1.0, (double)9.0), Block.m_49796_((double)0.0, (double)0.0, (double)7.0, (double)9.0, (double)1.0, (double)16.0)};
        VoxelShape voxelshape = Shapes.m_83040_();
        for (int i = 0; i < integer; ++i) {
            int j = Math.floorMod(i - direction.m_122416_(), 4);
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)avoxelshape[j]);
        }
        return voxelshape;
    });

    public SeashellsBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AMOUNT, (Comparable)Integer.valueOf(1))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, AMOUNT, WATERLOGGED});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level levelaccessor = context.m_43725_();
        BlockState blockstate = context.m_43725_().m_8055_(context.m_8083_());
        BlockPos blockpos = context.m_8083_();
        return blockstate.m_60713_((Block)this) ? (BlockState)blockstate.m_61124_((Property)AMOUNT, (Comparable)Integer.valueOf(Math.min(4, (Integer)blockstate.m_61143_((Property)AMOUNT) + 1))) : (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(levelaccessor.m_6425_(blockpos).m_76152_() == Fluids.f_76193_));
    }

    @NotNull
    public BlockState m_7417_(BlockState state, @NotNull Direction directionUpdated, @NotNull BlockState facingState, @NotNull LevelAccessor level, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if (directionUpdated == Direction.DOWN && !this.m_7898_(state, (LevelReader)level, currentPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    public boolean m_7898_(@NotNull BlockState state, @NotNull LevelReader level, BlockPos pos) {
        return SeashellsBlock.m_49936_((BlockGetter)level, (BlockPos)pos.m_7495_());
    }

    @NotNull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public boolean m_6864_(@NotNull BlockState state, BlockPlaceContext context) {
        return !context.m_7078_() && context.m_43722_().m_150930_(this.m_5456_()) && (Integer)state.m_61143_((Property)AMOUNT) < 4 || super.m_6864_(state, context);
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, @NotNull BlockGetter blockGetter, @NotNull BlockPos blockPos, @NotNull CollisionContext context) {
        return SHAPE_BY_PROPERTIES.apply((Direction)state.m_61143_((Property)FACING), (Integer)state.m_61143_((Property)AMOUNT));
    }
}

