/*
 * Decompiled with CFR 0.152.
 */
package org.primal.block_entity;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.primal.util.AnimalEgg;

public class NestBlockEntity
extends BlockEntity {
    private final NonNullList<ItemStack> items = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);

    public NestBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(@NotNull Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public void updateBlock() {
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void removeEgg(@Nullable LivingEntity target) {
        BlockItem blockItem;
        Item item = this.getEgg().m_41720_();
        if (item instanceof BlockItem && (item = (blockItem = (BlockItem)item).m_40614_()) instanceof AnimalEgg) {
            AnimalEgg animalEgg = (AnimalEgg)item;
            if (target != null && this.m_58904_() != null) {
                List<Entity> allEntitiesList = this.m_58904_().m_45976_(Entity.class, new AABB(this.m_58899_()).m_82400_(10.0)).stream().filter(entity -> entity.m_6095_() == animalEgg.getAnimal().get()).toList();
                for (Entity entityNearby : allEntitiesList) {
                    LivingEntity animal;
                    if (!(entityNearby instanceof LivingEntity) || (animal = (LivingEntity)entityNearby).m_6162_()) continue;
                    Brain brain = animal.m_6274_();
                    brain.m_21936_(MemoryModuleType.f_26357_);
                    brain.m_21936_(MemoryModuleType.f_26375_);
                    brain.m_21879_(MemoryModuleType.f_26372_, (Object)target);
                }
            }
        }
        this.setItem(this.getEgg().m_41613_() - 1 <= 0 ? ItemStack.f_41583_ : new ItemStack((ItemLike)this.getEgg().m_41720_(), this.getEgg().m_41613_() - 1));
        this.updateBlock();
    }

    public void addEgg(ItemStack stack, @Nullable LivingEntity player) {
        this.setItem(new ItemStack((ItemLike)stack.m_41720_(), this.getEgg().m_41613_() + 1));
        this.updateBlock();
    }

    public void setEgg(ItemStack stack, @Nullable LivingEntity player) {
        this.setItem(stack);
        this.updateBlock();
    }

    public ItemStack getEgg() {
        return (ItemStack)this.items.get(0);
    }

    public int getEggsAmount() {
        return ((ItemStack)this.items.get(0)).m_41613_();
    }

    public void setItem(ItemStack stack) {
        this.items.set(0, (Object)stack);
    }
}

