/*
 * Decompiled with CFR 0.152.
 */
package org.primal.client.animation.entity;

import net.minecraft.world.entity.Pose;
import org.primal.entity.animal.CrocodileEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class CrocodileAnimations {
    public static final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.crocodile.idle");
    public static final RawAnimation WALK = RawAnimation.begin().thenLoop("animation.crocodile.walk");
    public static final RawAnimation BASKING_START = RawAnimation.begin().thenPlay("animation.crocodile.basking_start");
    public static final RawAnimation BASKING = RawAnimation.begin().thenPlay("animation.crocodile.basking_start").thenLoop("animation.crocodile.basking");
    public static final RawAnimation BASKING_END = RawAnimation.begin().thenPlay("animation.crocodile.basking_end");
    public static final RawAnimation VOMITS = RawAnimation.begin().thenPlay("animation.crocodile.vomits");
    public static final RawAnimation SWIM = RawAnimation.begin().thenLoop("animation.crocodile.swim");
    public static final RawAnimation SWIM_IDLE = RawAnimation.begin().thenLoop("animation.crocodile.swim_idle");
    public static final RawAnimation ATTACK = RawAnimation.begin().thenPlay("animation.crocodile.attack");
    public static final RawAnimation TRASH = RawAnimation.begin().thenLoop("animation.crocodile.thrash");
    public static final RawAnimation ATTACK_UNDERWATER = RawAnimation.begin().thenPlay("animation.crocodile.attack_underwater");
    public static final RawAnimation TRASH_UNDERWATER = RawAnimation.begin().thenLoop("animation.crocodile.thrash_underwater");
    public static final RawAnimation RUN = RawAnimation.begin().thenLoop("animation.crocodile.run");

    public static AnimationController<CrocodileEntity> mainController(CrocodileEntity animatable) {
        return new AnimationController((GeoAnimatable)animatable, state -> {
            state.getController().transitionLength(0);
            if (state.getController().isPlayingTriggeredAnimation()) {
                state.getController().transitionLength(0);
                state.setControllerSpeed(1.0f);
                return PlayState.CONTINUE;
            }
            if (animatable.m_20089_() == Pose.SPIN_ATTACK) {
                state.setControllerSpeed(1.0f);
                return state.setAndContinue(animatable.m_20069_() ? TRASH_UNDERWATER : TRASH);
            }
            if (animatable.m_20089_() == Pose.CROAKING) {
                if (state.getController().getCurrentAnimation() != null && state.getController().getCurrentAnimation().animation().name().equals(((RawAnimation.Stage)BASKING.getAnimationStages().get(0)).animationName())) {
                    state.getController().transitionLength(5);
                }
                return state.setAndContinue(BASKING);
            }
            if (state.isMoving()) {
                if (animatable.m_20069_()) {
                    state.setControllerSpeed(state.getLimbSwingAmount() * (animatable.m_6162_() ? 8.0f : 4.0f));
                    return state.setAndContinue(SWIM);
                }
                if (animatable.m_20142_()) {
                    state.setControllerSpeed(state.getLimbSwingAmount() * (animatable.m_6162_() ? 4.0f : 2.0f));
                    return state.setAndContinue(RUN);
                }
                state.setControllerSpeed(state.getLimbSwingAmount() * (animatable.m_6162_() ? 6.0f : 5.0f));
                return state.setAndContinue(WALK);
            }
            state.getController().transitionLength(2);
            state.setControllerSpeed(1.0f);
            return state.setAndContinue(animatable.m_5842_() ? SWIM : (animatable.m_20069_() ? SWIM_IDLE : IDLE));
        });
    }
}

