/*
 * Decompiled with CFR 0.152.
 */
package org.primal.datagen.providers;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.registries.ForgeRegistries;
import org.primal.biome_modifiers.features.EagleNest_BiomeModifier;
import org.primal.biome_modifiers.features.RiverReeds_BiomeModifier;
import org.primal.biome_modifiers.features.Seashells_BiomeModifier;
import org.primal.biome_modifiers.mobs.BearGroup_BiomeModifier;
import org.primal.biome_modifiers.mobs.BearSingle_BiomeModifier;
import org.primal.biome_modifiers.mobs.CrocodileNormal_BiomeModifier;
import org.primal.biome_modifiers.mobs.CrocodileWarm_BiomeModifier;
import org.primal.biome_modifiers.mobs.SharkGroup_BiomeModifier;
import org.primal.biome_modifiers.mobs.SharkSingle_BiomeModifier;

public class Primal_BiomeModifiersGenerator {
    public static void bootstrap(BootstapContext<BiomeModifier> bootstrap) {
        Primal_BiomeModifiersGenerator.register(bootstrap, "spawn/bear_single", BearSingle_BiomeModifier::new);
        Primal_BiomeModifiersGenerator.register(bootstrap, "spawn/bear_group", BearGroup_BiomeModifier::new);
        Primal_BiomeModifiersGenerator.register(bootstrap, "spawn/shark_single", SharkSingle_BiomeModifier::new);
        Primal_BiomeModifiersGenerator.register(bootstrap, "spawn/shark_group", SharkGroup_BiomeModifier::new);
        Primal_BiomeModifiersGenerator.register(bootstrap, "spawn/crocodile", CrocodileNormal_BiomeModifier::new);
        Primal_BiomeModifiersGenerator.register(bootstrap, "spawn/crocodile_warm", CrocodileWarm_BiomeModifier::new);
        Primal_BiomeModifiersGenerator.register(bootstrap, "feature/river_reeds", RiverReeds_BiomeModifier::new);
        Primal_BiomeModifiersGenerator.register(bootstrap, "feature/seashells", Seashells_BiomeModifier::new);
        Primal_BiomeModifiersGenerator.register(bootstrap, "feature/eagle_nest", EagleNest_BiomeModifier::new);
    }

    public static void register(BootstapContext<BiomeModifier> bootstrap, String name, Supplier<? extends BiomeModifier> sup) {
        bootstrap.m_255272_(Primal_BiomeModifiersGenerator.modifierFor(name), (Object)sup.get());
    }

    public static void registerVegetation(BootstapContext<BiomeModifier> bootstrap, String biomeModifier, TagKey<Biome> spawnTag, ResourceKey<PlacedFeature> placedFeature) {
        Primal_BiomeModifiersGenerator.registerVegetation(bootstrap, Primal_BiomeModifiersGenerator.modifierFor(biomeModifier), spawnTag, placedFeature);
    }

    public static void registerVegetation(BootstapContext<BiomeModifier> bootstrap, ResourceKey<BiomeModifier> biomeModifierResourceKey, TagKey<Biome> spawnTag, ResourceKey<PlacedFeature> placedFeature) {
        Primal_BiomeModifiersGenerator.registerFeature(bootstrap, biomeModifierResourceKey, spawnTag, placedFeature, GenerationStep.Decoration.VEGETAL_DECORATION);
    }

    public static void registerFeature(BootstapContext<BiomeModifier> bootstrap, ResourceKey<BiomeModifier> biomeModifierResourceKey, TagKey<Biome> spawnTag, ResourceKey<PlacedFeature> placedFeature, GenerationStep.Decoration step) {
        HolderGetter biomes = bootstrap.m_255420_(Registries.f_256952_);
        HolderGetter placedFeatures = bootstrap.m_255420_(Registries.f_256988_);
        bootstrap.m_255272_(biomeModifierResourceKey, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.m_254956_(spawnTag), (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{placedFeatures.m_255043_(placedFeature)}), step));
    }

    public static void registerMobSpawn(BootstapContext<BiomeModifier> bootstrap, String biomeModifier, TagKey<Biome> spawnTag, EntityType<?> mob, int weight, int minGroupSize, int maxGroupSize) {
        Primal_BiomeModifiersGenerator.registerMobSpawn(bootstrap, Primal_BiomeModifiersGenerator.modifierFor(biomeModifier), spawnTag, mob, weight, minGroupSize, maxGroupSize);
    }

    public static void registerMobSpawn(BootstapContext<BiomeModifier> bootstrap, ResourceKey<BiomeModifier> biomeModifierResourceKey, TagKey<Biome> spawnTag, EntityType<?> mob, int weight, int minGroupSize, int maxGroupSize) {
        HolderGetter biomes = bootstrap.m_255420_(Registries.f_256952_);
        bootstrap.m_255272_(biomeModifierResourceKey, (Object)new ForgeBiomeModifiers.AddSpawnsBiomeModifier((HolderSet)biomes.m_254956_(spawnTag), List.of(new MobSpawnSettings.SpawnerData(mob, weight, minGroupSize, maxGroupSize))));
    }

    public static ResourceKey<BiomeModifier> modifierFor(String id) {
        return ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"primal", (String)id));
    }
}

