/*
 * Decompiled with CFR 0.152.
 */
package org.primal.entity.ai;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalMakeLove;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.EraseMemoryIf;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.RandomLookAround;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.TryFindLand;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.primal.entity.ai.behavior.eagle.EagleDetectHostile;
import org.primal.entity.ai.behavior.eagle.EagleRemoveHome;
import org.primal.entity.ai.behavior.eagle.EagleSearchHome;
import org.primal.entity.ai.behavior.eagle.EagleSnatch;
import org.primal.entity.ai.behavior.eagle.EagleStartAttack;
import org.primal.entity.ai.behavior.generic.AnimalGoesToNest;
import org.primal.entity.ai.behavior.generic.AnimalSitting;
import org.primal.entity.ai.behavior.generic.AnimalWanderFromScared;
import org.primal.entity.ai.behavior.generic.BirdAvoidWhileAscending;
import org.primal.entity.ai.behavior.generic.BirdReturnHome;
import org.primal.entity.ai.behavior.generic.ConditionalSwim;
import org.primal.entity.ai.behavior.generic.FollowOwner;
import org.primal.entity.ai.behavior.generic.TryLayEggOnLandOrNest;
import org.primal.entity.animal.EagleEntity;
import org.primal.injection.IsEagleTarget;
import org.primal.registry.Primal_Activities;
import org.primal.registry.Primal_Blocks;
import org.primal.registry.Primal_Entities;
import org.primal.registry.Primal_MemoryModuleTypes;
import org.primal.registry.Primal_Sensors;
import org.primal.util.MiscUtil;

public class EagleAi {
    private static final ImmutableList<SensorType<? extends Sensor<? super EagleEntity>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.f_26811_, (Object)SensorType.f_26814_, (Object)((SensorType)Primal_Sensors.NEAREST_BABY.get()), (Object)SensorType.f_26812_, (Object)SensorType.f_26822_, (Object)((SensorType)Primal_Sensors.EAGLE_ATTACK_SENSOR.get()), (Object)((SensorType)Primal_Sensors.EAGLE_TEMPTATIONS_SENSOR.get()), (Object)((SensorType)Primal_Sensors.EAGLE_SCARE_SENSOR.get()), (Object)((SensorType)Primal_Sensors.EAGLE_HOSTILE_SENSOR.get()), (Object)((SensorType)Primal_Sensors.NEAREST_NEST.get()));
    private static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.f_148204_, (Object)MemoryModuleType.f_148205_, (Object)MemoryModuleType.f_26371_, (Object)MemoryModuleType.f_26370_, (Object)MemoryModuleType.f_26326_, (Object)MemoryModuleType.f_26377_, (Object)MemoryModuleType.f_26372_, (Object)MemoryModuleType.f_26373_, (Object)MemoryModuleType.f_148194_, (Object)MemoryModuleType.f_217782_, (Object)MemoryModuleType.f_26381_, (Object)MemoryModuleType.f_26382_, (Object[])new MemoryModuleType[]{MemoryModuleType.f_26375_, MemoryModuleType.f_217768_, MemoryModuleType.f_148197_, MemoryModuleType.f_148198_, MemoryModuleType.f_148196_, MemoryModuleType.f_26383_, MemoryModuleType.f_148201_, MemoryModuleType.f_26356_, MemoryModuleType.f_217767_, MemoryModuleType.f_26357_, MemoryModuleType.f_26336_, MemoryModuleType.f_26323_, (MemoryModuleType)Primal_MemoryModuleTypes.CHIRP_COOLDOWN.get(), (MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_VISIBLE_BABY.get(), (MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_IMPORTANT_BLOCK.get(), (MemoryModuleType)Primal_MemoryModuleTypes.IS_STUNNED.get(), (MemoryModuleType)Primal_MemoryModuleTypes.IS_SNATCHING.get(), (MemoryModuleType)Primal_MemoryModuleTypes.AMOUNT_ATTACKED.get(), (MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_SCARED.get(), MemoryModuleType.f_26359_, MemoryModuleType.f_148202_, (MemoryModuleType)Primal_MemoryModuleTypes.ATTACKED_LIST.get(), (MemoryModuleType)Primal_MemoryModuleTypes.LAST_ATTACK_TARGET.get()});
    private static final UniformInt ADULT_FOLLOW_RANGE = UniformInt.m_146622_((int)5, (int)16);
    private static final UniformInt RETREAT_DURATION = TimeUtil.m_145020_((int)5, (int)20);

    public static Ingredient getTemptations() {
        return Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42699_});
    }

    public static void initMemories(EagleEntity eagle, RandomSource random) {
    }

    public static Brain.Provider<EagleEntity> brainProvider() {
        return Brain.m_21923_(MEMORY_TYPES, SENSOR_TYPES);
    }

    public static Brain<?> makeBrain(Brain<EagleEntity> brain) {
        EagleAi.initCoreActivity(brain);
        EagleAi.initIdleActivity(brain);
        EagleAi.initFightActivity(brain);
        EagleAi.initSnatchActivity(brain);
        EagleAi.initLayEggActivity(brain);
        EagleAi.initRetreatActivity(brain);
        EagleAi.initNestedActivity(brain);
        EagleAi.initFollowActivity(brain);
        EagleAi.initSitActivity(brain);
        brain.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        brain.m_21944_(Activity.f_37979_);
        brain.m_21962_();
        return brain;
    }

    private static void initCoreActivity(Brain<EagleEntity> brain) {
        brain.m_21891_(Activity.f_37978_, 0, ImmutableList.of((Object)((Object)new ConditionalSwim(0.8f, eagle -> eagle.m_6162_() || eagle.m_6274_().m_21954_((Activity)Primal_Activities.SIT.get()))), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink()));
    }

    private static void initIdleActivity(Brain<EagleEntity> brain) {
        brain.m_21891_(Activity.f_37979_, 10, ImmutableList.of((Object)StartAttacking.m_257710_(EagleAi::findNearestValidAttackTarget), (Object)((Object)new EagleRemoveHome()), (Object)((Object)new EagleSearchHome()), (Object)((Object)new BirdReturnHome(1600, 25, true)), (Object)new AnimalMakeLove((EntityType)Primal_Entities.EAGLE.get(), 1.0f), (Object)SetEntityLookTargetSometimes.m_257472_((EntityType)EntityType.f_20532_, (float)6.0f, (UniformInt)UniformInt.m_146622_((int)30, (int)60)), (Object)new FollowTemptation(livingEntity -> Float.valueOf(1.0f), livingEntity -> livingEntity.m_6162_() ? 2.5 : 3.5), (Object)((Object)new AnimalWanderFromScared(5, 8, 5, 10)), EagleAi.createIdleMovementBehaviors()));
    }

    private static void initFightActivity(Brain<EagleEntity> brain) {
        brain.m_21895_(Activity.f_37988_, 10, ImmutableList.of((Object)SetWalkTargetFromAttackTargetIfTargetOutOfReach.m_257469_((float)1.0f), (Object)SetEntityLookTarget.m_257660_((float)50.0f), (Object)((Object)new EagleStartAttack(10)), (Object)StopAttackingIfTargetInvalid.m_257822_(), (Object)EraseMemoryIf.m_258093_(eagle -> {
            Optional lastEntity;
            Entity patt7371$temp;
            Optional attackedList = eagle.m_6274_().m_21952_((MemoryModuleType)Primal_MemoryModuleTypes.ATTACKED_LIST.get());
            Optional<UUID> lastUuid = attackedList.map(list -> (UUID)list.get(list.size() - 1));
            if (lastUuid.isPresent() && !eagle.m_9236_().f_46443_ && (patt7371$temp = ((ServerLevel)eagle.m_9236_()).m_8791_(lastUuid.get())) instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)patt7371$temp;
                v0 = Optional.of(living);
            } else {
                v0 = lastEntity = Optional.empty();
            }
            if (lastEntity.isPresent() && !eagle.m_6274_().m_21938_(MemoryModuleType.f_26372_, (Object)((LivingEntity)lastEntity.get()))) {
                return true;
            }
            return eagle.m_27593_() || !eagle.m_20197_().isEmpty();
        }, (MemoryModuleType)MemoryModuleType.f_26372_)), MemoryModuleType.f_26372_);
    }

    private static void initSnatchActivity(Brain<EagleEntity> brain) {
        brain.m_21895_((Activity)Primal_Activities.SNATCH.get(), 10, ImmutableList.of((Object)((Object)new EagleSnatch(60))), (MemoryModuleType)Primal_MemoryModuleTypes.IS_SNATCHING.get());
    }

    private static void initFollowActivity(Brain<EagleEntity> brain) {
        brain.m_21891_((Activity)Primal_Activities.FOLLOW.get(), 10, ImmutableList.of((Object)StartAttacking.m_257710_(EagleAi::findNearestValidAttackTarget), (Object)((Object)new EagleRemoveHome()), (Object)((Object)new EagleSearchHome()), (Object)((Object)new EagleDetectHostile()), (Object)new AnimalMakeLove((EntityType)Primal_Entities.EAGLE.get(), 1.0f), (Object)((Object)new FollowOwner()), (Object)new FollowTemptation(livingEntity -> Float.valueOf(1.0f), livingEntity -> livingEntity.m_6162_() ? 2.5 : 3.5), (Object)new RandomLookAround((IntProvider)UniformInt.m_146622_((int)150, (int)250), 30.0f, 0.0f, 0.0f), EagleAi.createIdleMovementBehaviors()));
    }

    private static void initSitActivity(Brain<EagleEntity> brain) {
        brain.m_21900_((Activity)Primal_Activities.SIT.get(), ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new AnimalSitting()))));
    }

    private static void initRetreatActivity(Brain<EagleEntity> brain) {
        brain.m_21895_(Activity.f_37991_, 10, ImmutableList.of((Object)((Object)new BirdAvoidWhileAscending()), (Object)SetWalkTargetAwayFrom.m_257370_((MemoryModuleType)MemoryModuleType.f_26383_, (float)1.0f, (int)20, (boolean)false)), MemoryModuleType.f_26383_);
    }

    private static void initNestedActivity(Brain<EagleEntity> brain) {
        brain.m_21891_((Activity)Primal_Activities.NESTED.get(), 10, ImmutableList.of((Object)StartAttacking.m_257710_(EagleAi::findNearestValidAttackTarget), (Object)((Object)new EagleRemoveHome()), (Object)((Object)new EagleSearchHome()), (Object)SetEntityLookTargetSometimes.m_257472_((EntityType)EntityType.f_20532_, (float)3.0f, (UniformInt)UniformInt.m_146622_((int)30, (int)60)), (Object)SetEntityLookTargetSometimes.m_257472_((EntityType)((EntityType)Primal_Entities.EAGLE.get()), (float)16.0f, (UniformInt)UniformInt.m_146622_((int)30, (int)60)), (Object)new RandomLookAround((IntProvider)UniformInt.m_146622_((int)150, (int)250), 30.0f, 0.0f, 0.0f), (Object)((Object)new BirdReturnHome(1, 1, false)), EagleAi.createIdleMovementBehaviors()));
    }

    public static void wasHurtBy(EagleEntity eagle, LivingEntity target) {
        Brain<EagleEntity> brain = eagle.m_6274_();
        brain.m_21936_(MemoryModuleType.f_26357_);
        brain.m_21936_(MemoryModuleType.f_26375_);
        if (eagle.m_6162_()) {
            EagleAi.retreatFromNearestTarget(eagle, target);
            for (EagleEntity nearEagle : EagleAi.getNearestAdultEagles(eagle)) {
                nearEagle.m_6274_().m_21879_(MemoryModuleType.f_26372_, (Object)target);
            }
        } else {
            eagle.m_6274_().m_21879_(MemoryModuleType.f_26372_, (Object)target);
        }
    }

    private static List<EagleEntity> getNearestAdultEagles(EagleEntity eagle) {
        return eagle.m_9236_().m_45976_(EagleEntity.class, eagle.m_20191_().m_82377_(30.0, 5.0, 30.0)).stream().filter(crocodile1 -> !crocodile1.m_6162_()).toList();
    }

    private static void retreatFromNearestTarget(EagleEntity eagle, LivingEntity target) {
        Brain<EagleEntity> brain = eagle.m_6274_();
        LivingEntity avoidTarget = BehaviorUtils.m_22625_((LivingEntity)eagle, (Optional)brain.m_21952_(MemoryModuleType.f_26383_), (LivingEntity)target);
        avoidTarget = BehaviorUtils.m_22625_((LivingEntity)eagle, (Optional)brain.m_21952_(MemoryModuleType.f_26372_), (LivingEntity)avoidTarget);
        EagleAi.setAvoidTarget(eagle, avoidTarget);
    }

    private static void setAvoidTarget(EagleEntity eagle, LivingEntity target) {
        eagle.m_6274_().m_21936_(MemoryModuleType.f_26372_);
        eagle.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        eagle.m_6274_().m_21882_(MemoryModuleType.f_26383_, (Object)target, (long)RETREAT_DURATION.m_214085_(eagle.m_9236_().f_46441_));
    }

    private static void initLayEggActivity(Brain<EagleEntity> brain) {
        brain.m_21903_(Activity.f_219848_, ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new AnimalGoesToNest())), (Object)Pair.of((Object)1, TryLayEggOnLandOrNest.create((Block)Primal_Blocks.EAGLE_EGG.get(), MiscUtil.EGGS_2, 2, 1)), (Object)Pair.of((Object)2, (Object)TryFindLand.m_257647_((int)16, (float)1.0f)), (Object)Pair.of((Object)3, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.m_257965_((float)1.0f), (Object)2), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.m_257764_((float)1.0f, (int)3), (Object)1), (Object)Pair.of((Object)BehaviorBuilder.m_257590_(Entity::m_20096_), (Object)1))))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.f_217767_, (Object)MemoryStatus.VALUE_PRESENT)));
    }

    private static RunOne<EagleEntity> createIdleMovementBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)BehaviorBuilder.m_257845_(Predicate.not(eagle -> eagle.m_5912_() || eagle.m_6162_() && eagle.m_6274_().m_21874_(MemoryModuleType.f_26359_)), (OneShot)RandomStroll.m_257965_((float)1.0f)), (Object)1), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    public static void updateActivity(EagleEntity eagle) {
        Brain<EagleEntity> brain = eagle.m_6274_();
        if (eagle.isSitting()) {
            eagle.m_6274_().m_21889_((Activity)Primal_Activities.SIT.get());
        } else if (eagle.isFollowing()) {
            eagle.m_6274_().m_21926_((List)ImmutableList.of((Object)Activity.f_37991_, (Object)((Activity)Primal_Activities.SNATCH.get()), (Object)Activity.f_37988_, (Object)Activity.f_219848_, (Object)((Activity)Primal_Activities.FOLLOW.get())));
        } else if (eagle.m_6162_()) {
            brain.m_21926_((List)ImmutableList.of((Object)Activity.f_37991_, (Object)Activity.f_37988_, (Object)((Activity)Primal_Activities.NESTED.get())));
        } else {
            brain.m_21926_((List)ImmutableList.of((Object)Activity.f_37991_, (Object)((Activity)Primal_Activities.SNATCH.get()), (Object)Activity.f_37988_, (Object)Activity.f_219848_, (Object)Activity.f_37979_));
        }
        eagle.m_21561_(brain.m_21874_(MemoryModuleType.f_26372_) || brain.m_21874_((MemoryModuleType)Primal_MemoryModuleTypes.IS_SNATCHING.get()));
        EagleAi.handleEagleQueue(brain, eagle);
        if (brain.m_21952_(MemoryModuleType.f_26372_).isPresent()) {
            ((IsEagleTarget)brain.m_21952_(MemoryModuleType.f_26372_).get()).primal$setEagleAttacking(eagle.m_20148_());
            brain.m_21882_((MemoryModuleType)Primal_MemoryModuleTypes.LAST_ATTACK_TARGET.get(), (Object)((LivingEntity)brain.m_21952_(MemoryModuleType.f_26372_).get()), 80L);
        }
        if (brain.m_21952_((MemoryModuleType)Primal_MemoryModuleTypes.LAST_ATTACK_TARGET.get()).isPresent() && brain.m_21952_(MemoryModuleType.f_26372_).isPresent() && !brain.m_21938_((MemoryModuleType)Primal_MemoryModuleTypes.LAST_ATTACK_TARGET.get(), (Object)((LivingEntity)brain.m_21952_(MemoryModuleType.f_26372_).get())) && MiscUtil.isSameEagleAttacking((LivingEntity)brain.m_21952_((MemoryModuleType)Primal_MemoryModuleTypes.LAST_ATTACK_TARGET.get()).get(), (LivingEntity)eagle)) {
            ((IsEagleTarget)brain.m_21952_((MemoryModuleType)Primal_MemoryModuleTypes.LAST_ATTACK_TARGET.get()).get()).primal$setEagleAttacking(null);
        }
    }

    private static void handleEagleQueue(Brain<EagleEntity> brain, EagleEntity eagle) {
        ArrayList<UUID> attackedList;
        if (eagle.m_6274_().m_21874_(MemoryModuleType.f_148194_)) {
            List<UUID> list = attackedList = brain.m_21874_((MemoryModuleType)Primal_MemoryModuleTypes.ATTACKED_LIST.get()) ? (List)brain.m_21952_((MemoryModuleType)Primal_MemoryModuleTypes.ATTACKED_LIST.get()).get() : Lists.newArrayList();
            if (!attackedList.contains(((LivingEntity)brain.m_21952_(MemoryModuleType.f_148194_).get()).m_20148_())) {
                attackedList.add(0, ((LivingEntity)brain.m_21952_(MemoryModuleType.f_148194_).get()).m_20148_());
            }
            if (attackedList.size() > 2) {
                attackedList.remove(attackedList.size() - 1);
            }
            brain.m_21879_((MemoryModuleType)Primal_MemoryModuleTypes.ATTACKED_LIST.get(), attackedList);
        }
        if (brain.m_21874_((MemoryModuleType)Primal_MemoryModuleTypes.ATTACKED_LIST.get())) {
            attackedList = new ArrayList<UUID>((Collection)brain.m_21952_((MemoryModuleType)Primal_MemoryModuleTypes.ATTACKED_LIST.get()).get());
            attackedList.removeIf(uuid -> {
                LivingEntity target;
                Entity patt17789$temp = ((ServerLevel)eagle.m_9236_()).m_8791_(uuid);
                return patt17789$temp instanceof LivingEntity && (target = (LivingEntity)patt17789$temp).m_21224_() || ((ServerLevel)eagle.m_9236_()).m_8791_(uuid) == null;
            });
            if (attackedList.isEmpty()) {
                brain.m_21936_((MemoryModuleType)Primal_MemoryModuleTypes.ATTACKED_LIST.get());
            } else {
                brain.m_21879_((MemoryModuleType)Primal_MemoryModuleTypes.ATTACKED_LIST.get(), attackedList);
            }
        }
    }

    private static Optional<? extends LivingEntity> findNearestValidAttackTarget(EagleEntity eagle) {
        if (BehaviorUtils.m_217126_((LivingEntity)eagle) || eagle.m_9236_().f_46443_) {
            return Optional.empty();
        }
        if (eagle.m_6274_().m_21874_((MemoryModuleType)Primal_MemoryModuleTypes.ATTACKED_LIST.get())) {
            List attackedList = (List)eagle.m_6274_().m_21952_((MemoryModuleType)Primal_MemoryModuleTypes.ATTACKED_LIST.get()).get();
            Entity entity = ((ServerLevel)eagle.m_9236_()).m_8791_((UUID)attackedList.get(attackedList.size() - 1));
            if (entity instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)entity;
                return Optional.of(target);
            }
        }
        return Optional.empty();
    }
}

