/*
 * Decompiled with CFR 0.152.
 */
package org.primal.entity.ai.behavior.bear;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.primal.entity.animal.BearEntity;
import org.primal.registry.Primal_MemoryModuleTypes;

public class BearRaidSweetBerryBush
extends Behavior<BearEntity> {
    public BearRaidSweetBerryBush() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_217782_, (Object)MemoryStatus.VALUE_ABSENT, (Object)((MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_BEEHIVE.get()), (Object)MemoryStatus.VALUE_ABSENT, (Object)((MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_SWEET_BERRY_BUSH.get()), (Object)MemoryStatus.VALUE_PRESENT));
    }

    protected boolean canStillUse(@NotNull ServerLevel level, BearEntity entity, long gameTime) {
        return entity.m_6274_().m_21952_((MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_SWEET_BERRY_BUSH.get()).isPresent();
    }

    protected void start(@NotNull ServerLevel level, BearEntity entity, long gameTime) {
        entity.m_6274_().m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget((BlockPos)entity.m_6274_().m_21952_((MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_SWEET_BERRY_BUSH.get()).get(), 1.0f, 2));
    }

    protected void tick(@NotNull ServerLevel level, BearEntity bear, long gameTime) {
        BlockPos nearestBush = bear.m_6274_().m_21952_((MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_SWEET_BERRY_BUSH.get()).orElse(null);
        if (nearestBush != null && (float)bear.m_20183_().m_123333_((Vec3i)nearestBush) <= 3.0f) {
            BlockState originalState = level.m_8055_(nearestBush);
            if (!originalState.m_60713_(Blocks.f_50685_) || !originalState.m_61138_((Property)SweetBerryBushBlock.f_57244_)) {
                return;
            }
            level.m_46953_(nearestBush, false, (Entity)bear);
            bear.triggerAnim("attack", "attack");
            bear.m_5496_(SoundEvents.f_12457_, 1.0f, 1.0f);
        }
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel level, BearEntity owner) {
        if (owner.m_6162_() || owner.getHoneyCounter() > 0) {
            return false;
        }
        BlockPos nearestBushPos = owner.m_6274_().m_21952_((MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_SWEET_BERRY_BUSH.get()).orElse(null);
        return level.m_8055_(nearestBushPos).m_60713_(Blocks.f_50685_) && level.m_8055_(nearestBushPos).m_61138_((Property)SweetBerryBushBlock.f_57244_) && (Integer)level.m_8055_(nearestBushPos).m_61143_((Property)SweetBerryBushBlock.f_57244_) >= 2;
    }
}

