/*
 * Decompiled with CFR 0.152.
 */
package org.primal.entity.ai.behavior.eagle;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ProjectileWeaponItem;
import org.jetbrains.annotations.NotNull;
import org.primal.entity.animal.EagleEntity;
import org.primal.registry.Primal_MemoryModuleTypes;
import org.primal.util.MiscUtil;

public class EagleStartAttack
extends Behavior<EagleEntity> {
    private final int cooldownBetweenAttacks;

    public EagleStartAttack(int cooldownBetweenAttacks) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.f_26373_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_148205_, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.f_26383_, (Object)MemoryStatus.VALUE_ABSENT, (Object)((MemoryModuleType)Primal_MemoryModuleTypes.AMOUNT_ATTACKED.get()), (Object)MemoryStatus.REGISTERED));
        this.cooldownBetweenAttacks = cooldownBetweenAttacks;
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel level, @NotNull EagleEntity eagle) {
        LivingEntity target = (LivingEntity)eagle.m_6274_().m_21952_(MemoryModuleType.f_26372_).get();
        NearestVisibleLivingEntities nearestVisibleLivingEntities = (NearestVisibleLivingEntities)eagle.m_6274_().m_21952_(MemoryModuleType.f_148205_).get();
        return !EagleStartAttack.isHoldingUsableProjectileWeapon((Mob)eagle) && eagle.m_217066_(target) && nearestVisibleLivingEntities.m_186107_(target) && eagle.m_20197_().isEmpty();
    }

    protected void start(@NotNull ServerLevel level, @NotNull EagleEntity eagle, long gameTime) {
        LivingEntity target = (LivingEntity)eagle.m_6274_().m_21952_(MemoryModuleType.f_26372_).get();
        eagle.m_6274_().m_21879_(MemoryModuleType.f_26371_, (Object)new EntityTracker((Entity)target, true));
        eagle.m_6674_(InteractionHand.MAIN_HAND);
        double speed = eagle.m_20184_().m_82553_();
        if (speed > 0.5) {
            target.m_6469_(level.m_269111_().m_269333_((LivingEntity)eagle), 1.0f);
        }
        if (eagle.canPickUpEntity((Entity)target)) {
            target.m_20329_((Entity)eagle);
            eagle.setHealthWhenStartRiding(eagle.m_21223_());
            eagle.m_6274_().m_21879_((MemoryModuleType)Primal_MemoryModuleTypes.IS_SNATCHING.get(), (Object)true);
            this.stop(level, eagle, gameTime);
        } else {
            eagle.m_7327_((Entity)target);
            if (!eagle.m_6162_()) {
                MiscUtil.addToAttackCount((LivingEntity)eagle);
                if (eagle.m_6274_().m_21952_((MemoryModuleType)Primal_MemoryModuleTypes.AMOUNT_ATTACKED.get()).isPresent() && (Integer)eagle.m_6274_().m_21952_((MemoryModuleType)Primal_MemoryModuleTypes.AMOUNT_ATTACKED.get()).get() > 3) {
                    eagle.m_6274_().m_21882_(MemoryModuleType.f_26383_, (Object)target, (long)level.m_213780_().m_216332_(60, 100));
                    eagle.m_6274_().m_21879_((MemoryModuleType)Primal_MemoryModuleTypes.AMOUNT_ATTACKED.get(), (Object)0);
                }
            }
            this.stop(level, eagle, gameTime);
        }
    }

    protected void tick(@NotNull ServerLevel level, @NotNull EagleEntity eagle, long gameTime) {
    }

    protected void stop(@NotNull ServerLevel level, EagleEntity eagle, long gameTime) {
        if (!eagle.m_6162_()) {
            eagle.m_6274_().m_21882_(MemoryModuleType.f_26373_, (Object)true, (long)this.cooldownBetweenAttacks);
        }
    }

    private static boolean isHoldingUsableProjectileWeapon(Mob mob) {
        return mob.m_21093_(stack -> {
            Item item = stack.m_41720_();
            return item instanceof ProjectileWeaponItem && mob.m_5886_((ProjectileWeaponItem)item);
        });
    }
}

