/*
 * Decompiled with CFR 0.152.
 */
package org.primal.entity.ai.behavior.generic;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import org.jetbrains.annotations.NotNull;

public class ConditionalSwim
extends Behavior<Mob> {
    private final float chance;
    private final Predicate<Mob> canSwim;

    public ConditionalSwim(float chance, Predicate<Mob> canSwim) {
        super((Map)ImmutableMap.of());
        this.chance = chance;
        this.canSwim = canSwim;
    }

    public static boolean shouldSwim(Mob mob, Predicate<Mob> canSwim) {
        return canSwim.test(mob) && mob.m_20069_() && mob.m_204036_(FluidTags.f_13131_) > mob.m_20204_() || mob.m_20077_() || mob.isInFluidType((fluidType, height) -> mob.canSwimInFluidType(fluidType) && height > mob.m_20204_());
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel level, @NotNull Mob owner) {
        return ConditionalSwim.shouldSwim(owner, this.canSwim);
    }

    protected boolean canStillUse(@NotNull ServerLevel level, @NotNull Mob entity, long gameTime) {
        return this.checkExtraStartConditions(level, entity);
    }

    protected void tick(@NotNull ServerLevel level, Mob owner, long gameTime) {
        if (owner.m_217043_().m_188501_() < this.chance) {
            owner.m_21569_().m_24901_();
        }
    }
}

