/*
 * Decompiled with CFR 0.152.
 */
package org.primal.util;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.primal.injection.IsEagleTarget;
import org.primal.registry.Primal_MemoryModuleTypes;
import org.primal.registry.Primal_Tags;
import org.primal.util.HostileMount;

public class MiscUtil {
    public static final IntegerProperty EGGS_2 = IntegerProperty.m_61631_((String)"eggs", (int)1, (int)2);
    public static final IntegerProperty EGGS_3 = IntegerProperty.m_61631_((String)"eggs", (int)1, (int)3);
    public static final IntegerProperty EGGS_4 = IntegerProperty.m_61631_((String)"eggs", (int)1, (int)4);

    public static boolean isMoving(LivingEntity entity, float motionThreshold) {
        float limbSwingAmount = 0.0f;
        if (entity.m_6084_() && (limbSwingAmount = entity.f_267362_.m_267711_((float)entity.f_19797_)) > 1.0f) {
            limbSwingAmount = 1.0f;
        }
        Vec3 velocity = entity.m_20184_();
        float avgVelocity = (float)((Math.abs(velocity.f_82479_) + Math.abs(velocity.f_82481_)) / 2.0);
        return avgVelocity >= motionThreshold && limbSwingAmount != 0.0f;
    }

    public static boolean isSeeingTarget(Entity target, Entity watcher, float angle) {
        Vec3 vec3d = target.m_20182_();
        Vec3 vec3d2 = watcher.m_20171_(0.0f, watcher.m_6080_());
        Vec3 vec3d3 = vec3d.m_82505_(watcher.m_20182_());
        vec3d3 = new Vec3(vec3d3.f_82479_, 0.0, vec3d3.f_82481_).m_82541_();
        return vec3d3.m_82526_(vec3d2) < (double)angle;
    }

    public static float smoothAngle(float current, float target, float maxChange) {
        float delta = Mth.m_14177_((float)(target - current));
        delta = Mth.m_14036_((float)delta, (float)(-maxChange), (float)maxChange);
        return current + delta;
    }

    public static boolean isRidingUnfriendly(LivingEntity entity) {
        return entity.m_20159_() && entity.m_20202_() instanceof HostileMount;
    }

    public static void extendLootPool(LootPool pool, List<LootPoolEntryContainer> newEntries) {
        ArrayList<LootPoolEntryContainer> merged = new ArrayList<LootPoolEntryContainer>(Arrays.asList(pool.f_79023_));
        merged.addAll(newEntries);
        pool.f_79023_ = merged.toArray(new LootPoolEntryContainer[0]);
    }

    public static boolean isNotNeverAttack(LivingEntity entity) {
        return !entity.m_6095_().m_204039_(Primal_Tags.NEVER_ATTACK);
    }

    public static void addToAttackCount(LivingEntity entity) {
        if (entity.m_6274_().m_21874_((MemoryModuleType)Primal_MemoryModuleTypes.AMOUNT_ATTACKED.get())) {
            entity.m_6274_().m_21879_((MemoryModuleType)Primal_MemoryModuleTypes.AMOUNT_ATTACKED.get(), (Object)((Integer)entity.m_6274_().m_21952_((MemoryModuleType)Primal_MemoryModuleTypes.AMOUNT_ATTACKED.get()).get() + 1));
        } else {
            entity.m_6274_().m_21879_((MemoryModuleType)Primal_MemoryModuleTypes.AMOUNT_ATTACKED.get(), (Object)1);
        }
    }

    public static boolean isSameEagleAttacking(LivingEntity target, LivingEntity eagle) {
        if (((IsEagleTarget)target).primal$eagleAttacking().isPresent()) {
            if (eagle.m_6162_()) {
                return true;
            }
            return ((IsEagleTarget)target).primal$eagleAttacking().get() == eagle.m_20148_();
        }
        return true;
    }

    public static void insertItemsAfter(BuildCreativeModeTabContentsEvent event, ItemStack after, ItemStack ... itemStacks) {
        for (int i = 0; i < itemStacks.length; ++i) {
            if (i == 0) {
                event.getEntries().putAfter((Object)after, (Object)itemStacks[i], (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                continue;
            }
            event.getEntries().putAfter((Object)itemStacks[i - 1], (Object)itemStacks[i], (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
    }

    public static void consumeStack(int i, @Nullable LivingEntity arg, ItemStack stack) {
        Player player;
        if (arg == null || !(arg instanceof Player) || !(player = (Player)arg).m_7500_()) {
            stack.m_41774_(i);
        }
    }

    public static EquipmentSlot getSlotForHand(InteractionHand interactionHand) {
        return interactionHand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
    }

    public static void createBiomeModifier(Holder<Biome> biome, ModifiableBiomeInfo.BiomeInfo.Builder builder, TagKey<Biome> biomeTagSpawn, List<String> extraBiomes, boolean enabled, int spawnWeight, int minGroupSize, int maxGroupSize, EntityType<?> entityType) {
        if (enabled) {
            boolean matchesExtra = extraBiomes.stream().anyMatch(b -> {
                String[] stringArray;
                ResourceLocation loc = ResourceLocation.m_135820_((String)b);
                if (b.contains("#") && (stringArray = b.split("#")).length >= 1) {
                    String biomeTag = stringArray[1];
                    ResourceLocation tagLoc = ResourceLocation.m_135820_((String)biomeTag);
                    return tagLoc != null && biome.m_203656_(TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)tagLoc));
                }
                return loc != null && biome.m_203543_().map(key -> key.m_135782_().equals((Object)loc)).orElse(false) != false;
            });
            if ((biome.m_203656_(biomeTagSpawn) || matchesExtra) && spawnWeight > 0 && minGroupSize > 0 && maxGroupSize > 0) {
                builder.getMobSpawnSettings().getSpawner(entityType.m_20674_()).add(new MobSpawnSettings.SpawnerData(entityType, spawnWeight, minGroupSize, maxGroupSize));
            }
        }
    }

    public static <FC extends FeatureConfiguration, F extends Feature<FC>> void createBiomeModifier(Holder<Biome> biome, ModifiableBiomeInfo.BiomeInfo.Builder builder, TagKey<Biome> biomeTagSpawn, List<String> extraBiomes, GenerationStep.Decoration step, boolean enabled, F feature, FC config, PlacementModifier heightmap, int rarity) {
        if (enabled) {
            boolean matchesExtra = extraBiomes.stream().anyMatch(b -> {
                String[] stringArray;
                ResourceLocation loc = ResourceLocation.m_135820_((String)b);
                if (b.contains("#") && (stringArray = b.split("#")).length >= 1) {
                    String biomeTag = stringArray[1];
                    ResourceLocation tagLoc = ResourceLocation.m_135820_((String)biomeTag);
                    return tagLoc != null && biome.m_203656_(TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)tagLoc));
                }
                return loc != null && biome.m_203543_().map(key -> key.m_135782_().equals((Object)loc)).orElse(false) != false;
            });
            if (biome.m_203656_(biomeTagSpawn) || matchesExtra) {
                ConfiguredFeature configured = new ConfiguredFeature(feature, config);
                List<BiomeFilter> modifiers = List.of(RarityFilter.m_191900_((int)rarity), InSquarePlacement.m_191715_(), heightmap, BiomeFilter.m_191561_());
                Holder placedFeature = Holder.m_205709_((Object)new PlacedFeature(Holder.m_205709_((Object)configured), modifiers));
                builder.getGenerationSettings().m_255419_(step, placedFeature);
            }
        }
    }

    public static RegistryObject<Codec<? extends BiomeModifier>> createBiomeModifierSerializer(String name) {
        return RegistryObject.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"primal", (String)name), (ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"primal");
    }
}

