/*
 * Decompiled with CFR 0.152.
 */
package org.primal.worldgen;

import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.synth.PerlinSimplexNoise;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;
import org.primal.block.RiverReeds;
import org.primal.block.properties.TripleBlockHalf;
import org.primal.registry.Primal_Blocks;
import org.primal.worldgen.RandomPatchCustomConfig;

public class RiverReedsFeature
extends Feature<RandomPatchCustomConfig> {
    public RiverReedsFeature(Codec<RandomPatchCustomConfig> configCodec) {
        super(configCodec);
    }

    public boolean m_142674_(@NotNull FeaturePlaceContext<RandomPatchCustomConfig> context) {
        boolean isTooBelowSeaLevel;
        RandomPatchCustomConfig randomPatchConfiguration = (RandomPatchCustomConfig)context.m_159778_();
        RandomSource randomsource = context.m_225041_();
        BlockPos origin = context.m_159777_();
        WorldGenLevel level = context.m_159774_();
        BlockPredicate isNearWater = BlockPredicate.m_190430_((BlockPredicate[])new BlockPredicate[]{BlockPredicate.m_224777_((Vec3i)new BlockPos(1, -1, 0), (Fluid[])new Fluid[]{Fluids.f_76193_, Fluids.f_76192_}), BlockPredicate.m_224777_((Vec3i)new BlockPos(-1, -1, 0), (Fluid[])new Fluid[]{Fluids.f_76193_, Fluids.f_76192_}), BlockPredicate.m_224777_((Vec3i)new BlockPos(0, -1, 1), (Fluid[])new Fluid[]{Fluids.f_76193_, Fluids.f_76192_}), BlockPredicate.m_224777_((Vec3i)new BlockPos(0, -1, -1), (Fluid[])new Fluid[]{Fluids.f_76193_, Fluids.f_76192_})});
        boolean bl = isTooBelowSeaLevel = origin.m_123342_() < level.m_5736_() - 3;
        if (!isNearWater.test((Object)level, (Object)origin) || isTooBelowSeaLevel) {
            return false;
        }
        int i = 0;
        BlockPos.MutableBlockPos desiredPosition = new BlockPos.MutableBlockPos();
        int lateralDistance = randomPatchConfiguration.xzSpread() + 1;
        int verticalDistance = randomPatchConfiguration.ySpread() + 1;
        BlockState defaultStateShortReeds = ((Block)Primal_Blocks.SHORT_RIVER_REEDS.get()).m_49966_();
        BlockState defaultStateLongReeds = ((Block)Primal_Blocks.RIVER_REEDS.get()).m_49966_();
        PerlinSimplexNoise reedsNoise = new PerlinSimplexNoise(randomsource, List.of(Integer.valueOf(0)));
        for (int dx = -lateralDistance; dx <= lateralDistance; ++dx) {
            for (int dz = -lateralDistance; dz <= lateralDistance; ++dz) {
                for (int dy = -verticalDistance; dy <= verticalDistance; ++dy) {
                    boolean generateDouble;
                    boolean generateShort;
                    double noiseValue = reedsNoise.m_75449_((double)(origin.m_123341_() + dx) * 0.1, (double)(origin.m_123343_() + dz) * 0.1, false);
                    if (!(noiseValue > 0.1) || !defaultStateLongReeds.m_60710_((LevelReader)level, (BlockPos)(desiredPosition = desiredPosition.m_122154_((Vec3i)origin, dx, dy, dz))) || !this.canGenerateHere(level, (BlockPos)desiredPosition)) continue;
                    boolean isUnderwater = level.m_8055_((BlockPos)desiredPosition).m_60713_(Blocks.f_49990_);
                    boolean isUnderwaterAbove = level.m_8055_(desiredPosition.m_7494_()).m_60713_(Blocks.f_49990_);
                    boolean isUnderwaterAboveAbove = level.m_8055_(desiredPosition.m_7494_().m_7494_()).m_60713_(Blocks.f_49990_);
                    boolean bl2 = generateShort = level.m_213780_().m_216339_(0, 3) == 0;
                    if (generateShort) continue;
                    int age = level.m_213780_().m_216339_(1, 5) >= 4 ? 1 : 0;
                    boolean bl3 = generateDouble = level.m_213780_().m_216339_(0, 3) == 0;
                    if (isUnderwater && !generateDouble && this.canGenerateHere(level, (BlockPos)desiredPosition) && this.canGenerateHere(level, desiredPosition.m_7494_()) && this.canGenerateHere(level, desiredPosition.m_7494_().m_7494_())) {
                        if (isUnderwater && isUnderwaterAbove && isUnderwaterAboveAbove || !level.m_7731_((BlockPos)desiredPosition, (BlockState)((BlockState)((BlockState)defaultStateLongReeds.m_61124_(RiverReeds.HALF, (Comparable)((Object)TripleBlockHalf.LOWER))).m_61124_((Property)RiverReeds.AGE, (Comparable)Integer.valueOf(age))).m_61124_((Property)RiverReeds.WATERLOGGED, (Comparable)Boolean.valueOf(isUnderwater)), 2) || !level.m_7731_(desiredPosition.m_7494_(), (BlockState)((BlockState)((BlockState)defaultStateLongReeds.m_61124_(RiverReeds.HALF, (Comparable)((Object)TripleBlockHalf.MIDDLE))).m_61124_((Property)RiverReeds.AGE, (Comparable)Integer.valueOf(age))).m_61124_((Property)RiverReeds.WATERLOGGED, (Comparable)Boolean.valueOf(isUnderwaterAbove)), 2) || !level.m_7731_(desiredPosition.m_7494_().m_7494_(), (BlockState)((BlockState)((BlockState)defaultStateLongReeds.m_61124_(RiverReeds.HALF, (Comparable)((Object)TripleBlockHalf.UPPER))).m_61124_((Property)RiverReeds.AGE, (Comparable)Integer.valueOf(age))).m_61124_((Property)RiverReeds.WATERLOGGED, (Comparable)Boolean.valueOf(isUnderwaterAboveAbove)), 2)) continue;
                        ++i;
                        continue;
                    }
                    if (!this.canGenerateHere(level, (BlockPos)desiredPosition) || !this.canGenerateHere(level, desiredPosition.m_7494_()) || isUnderwater && isUnderwaterAbove) continue;
                    if (level.m_7731_((BlockPos)desiredPosition, (BlockState)((BlockState)((BlockState)defaultStateLongReeds.m_61124_(RiverReeds.HALF, (Comparable)((Object)TripleBlockHalf.LOWER))).m_61124_((Property)RiverReeds.AGE, (Comparable)Integer.valueOf(age))).m_61124_((Property)RiverReeds.WATERLOGGED, (Comparable)Boolean.valueOf(isUnderwater)), 2) && level.m_7731_(desiredPosition.m_7494_(), (BlockState)((BlockState)((BlockState)defaultStateLongReeds.m_61124_(RiverReeds.HALF, (Comparable)((Object)TripleBlockHalf.UPPER))).m_61124_((Property)RiverReeds.AGE, (Comparable)Integer.valueOf(age))).m_61124_((Property)RiverReeds.WATERLOGGED, (Comparable)Boolean.valueOf(isUnderwaterAbove)), 2)) {
                        ++i;
                        continue;
                    }
                    if (!level.m_7731_((BlockPos)desiredPosition, (BlockState)defaultStateShortReeds.m_61124_((Property)RiverReeds.WATERLOGGED, (Comparable)Boolean.valueOf(isUnderwater)), 2)) continue;
                    ++i;
                }
            }
        }
        return i > 0;
    }

    public boolean canGenerateHere(WorldGenLevel level, BlockPos pos) {
        return level.m_8055_(pos).m_60795_() || level.m_8055_(pos).m_60713_(Blocks.f_49990_);
    }
}

