/*
 * Decompiled with CFR 0.152.
 */
package org.primal.block;

import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.primal.block.properties.SharkToothThickness;
import org.primal.registry.Primal_DamageTypes;

public class SharkToothBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final EnumProperty<SharkToothThickness> THICKNESS = EnumProperty.m_61587_((String)"thickness", SharkToothThickness.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private final Map<Direction, VoxelShape> tipShapesByDirection = Map.of(Direction.UP, Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0), Direction.DOWN, Block.m_49796_((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0), Direction.NORTH, Block.m_49796_((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)16.0), Direction.SOUTH, Block.m_49796_((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)11.0), Direction.EAST, Block.m_49796_((double)0.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0), Direction.WEST, Block.m_49796_((double)5.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0));
    private final Map<Direction, VoxelShape> baseShapesByDirection = Map.of(Direction.UP, Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0), Direction.DOWN, Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0), Direction.NORTH, Block.m_49796_((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)16.0), Direction.SOUTH, Block.m_49796_((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)16.0), Direction.EAST, Block.m_49796_((double)0.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0), Direction.WEST, Block.m_49796_((double)0.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0));

    public SharkToothBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.UP)).m_61124_(THICKNESS, (Comparable)((Object)SharkToothThickness.TIP))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, THICKNESS, WATERLOGGED});
    }

    public boolean m_7898_(BlockState state, @NotNull LevelReader level, @NotNull BlockPos pos) {
        return this.isValidPointedDripstonePlacement(level, pos, (Direction)state.m_61143_((Property)FACING));
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_7417_(BlockState state, @NotNull Direction directionUpdated, @NotNull BlockState facingState, @NotNull LevelAccessor level, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if (this.updateOpposites(state, directionUpdated) && !facingState.m_60713_((Block)this) && !this.m_7898_(state, (LevelReader)level, currentPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        if (this.isValueForConnection(state, Direction.UP, directionUpdated, facingState) || this.isValueForConnection(state, Direction.DOWN, directionUpdated, facingState) || this.isValueForConnection(state, Direction.NORTH, directionUpdated, facingState) || this.isValueForConnection(state, Direction.SOUTH, directionUpdated, facingState) || this.isValueForConnection(state, Direction.EAST, directionUpdated, facingState) || this.isValueForConnection(state, Direction.WEST, directionUpdated, facingState)) {
            return (BlockState)state.m_61124_(THICKNESS, (Comparable)((Object)SharkToothThickness.BASE));
        }
        if (state.m_61143_(THICKNESS) == SharkToothThickness.BASE && !facingState.m_60713_((Block)this) && directionUpdated == state.m_61143_((Property)FACING)) {
            return (BlockState)state.m_61124_(THICKNESS, (Comparable)((Object)SharkToothThickness.TIP));
        }
        return state;
    }

    private boolean isValueForConnection(BlockState state, Direction directionToCheck, Direction directionUpdated, BlockState facingState) {
        return state.m_61143_(THICKNESS) == SharkToothThickness.TIP && state.m_61143_((Property)FACING) == directionToCheck && directionUpdated == directionToCheck && facingState.m_60713_((Block)this) && facingState.m_61143_((Property)FACING) == directionToCheck;
    }

    private boolean updateOpposite(BlockState state, Direction directionToCheck, Direction directionUpdated) {
        return state.m_61143_((Property)FACING) == directionToCheck && directionUpdated == directionToCheck.m_122424_();
    }

    private boolean updateOpposites(BlockState state, Direction directionUpdated) {
        return this.updateOpposite(state, Direction.UP, directionUpdated) || this.updateOpposite(state, Direction.DOWN, directionUpdated) || this.updateOpposite(state, Direction.NORTH, directionUpdated) || this.updateOpposite(state, Direction.SOUTH, directionUpdated) || this.updateOpposite(state, Direction.EAST, directionUpdated) || this.updateOpposite(state, Direction.WEST, directionUpdated);
    }

    private boolean isValidPointedDripstonePlacement(LevelReader level, BlockPos pos, Direction dir) {
        BlockPos blockpos = pos.m_121945_(dir.m_122424_());
        BlockState blockstate = level.m_8055_(blockpos);
        return (blockstate.m_60713_(Blocks.f_50110_) || blockstate.m_60659_((BlockGetter)level, blockpos, dir, SupportType.CENTER) || blockstate.m_60713_((Block)this) && blockstate.m_61143_((Property)FACING) == dir) && !blockstate.m_60795_();
    }

    private boolean isToothWithDirection(BlockState state, Direction dir) {
        return state.m_60713_((Block)this) && state.m_61143_((Property)FACING) == dir;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockpos;
        Level levelaccessor = context.m_43725_();
        SharkToothThickness sharkToothThickness = this.calculateToothThickness((LevelReader)levelaccessor, blockpos = context.m_8083_(), context.m_43719_().m_122424_());
        return sharkToothThickness == null ? null : (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_43719_())).m_61124_(THICKNESS, (Comparable)((Object)sharkToothThickness))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(levelaccessor.m_6425_(blockpos).m_76152_() == Fluids.f_76193_));
    }

    private SharkToothThickness calculateToothThickness(LevelReader level, BlockPos pos, Direction dir) {
        BlockState onBlockPlacedState = level.m_8055_(pos.m_121945_(dir));
        if (this.isToothWithDirection(onBlockPlacedState, dir)) {
            return SharkToothThickness.BASE;
        }
        return SharkToothThickness.TIP;
    }

    @NotNull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @NotNull
    public VoxelShape m_7952_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return Shapes.m_83040_();
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return state.m_61143_(THICKNESS) == SharkToothThickness.TIP ? this.tipShapesByDirection.get(state.m_61143_((Property)FACING)) : this.baseShapesByDirection.get(state.m_61143_((Property)FACING));
    }

    public boolean m_180643_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return false;
    }

    public void m_142072_(@NotNull Level level, BlockState state, @NotNull BlockPos pos, @NotNull Entity entity, float fallDistance) {
        if (state.m_61143_((Property)FACING) == Direction.UP && state.m_61143_(THICKNESS) == SharkToothThickness.TIP) {
            entity.m_142535_(fallDistance + 4.0f, 2.0f, Primal_DamageTypes.sharkTooth(level));
        } else {
            super.m_142072_(level, state, pos, entity, fallDistance);
        }
    }

    public boolean collisionExtendsVertically(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull Entity collidingEntity) {
        return super.collisionExtendsVertically(state, level, pos, collidingEntity);
    }

    public void m_7892_(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Entity entity) {
        if (level.f_46443_) {
            return;
        }
        AABB blockBox = new AABB(pos);
        AABB entityBox = entity.m_20191_();
        if (!blockBox.m_82381_(entityBox)) {
            return;
        }
        Direction face = SharkToothBlock.getDirection(entityBox, blockBox);
        if (face != null) {
            if (entity.m_6144_() && face == Direction.UP) {
                return;
            }
            if (state.m_61143_((Property)FACING) == face) {
                entity.m_6469_(Primal_DamageTypes.sharkTooth(level), 2.0f);
            }
        }
    }

    @Nullable
    private static Direction getDirection(AABB eBox, AABB blockBox) {
        double dxWest = eBox.f_82291_ - blockBox.f_82288_;
        double dxEast = blockBox.f_82291_ - eBox.f_82288_;
        double dzNorth = eBox.f_82293_ - blockBox.f_82290_;
        double dzSouth = blockBox.f_82293_ - eBox.f_82290_;
        double dyDown = eBox.f_82292_ - blockBox.f_82289_;
        double dyUp = blockBox.f_82292_ - eBox.f_82289_;
        double min = Double.MAX_VALUE;
        Direction face = null;
        if (dxWest >= 0.0 && dxWest < min) {
            min = dxWest;
            face = Direction.WEST;
        }
        if (dxEast >= 0.0 && dxEast < min) {
            min = dxEast;
            face = Direction.EAST;
        }
        if (dzNorth >= 0.0 && dzNorth < min) {
            min = dzNorth;
            face = Direction.NORTH;
        }
        if (dzSouth >= 0.0 && dzSouth < min) {
            min = dzSouth;
            face = Direction.SOUTH;
        }
        if (dyDown >= 0.0 && dyDown < min) {
            min = dyDown;
            face = Direction.DOWN;
        }
        if (dyUp >= 0.0 && dyUp < min) {
            min = dyUp;
            face = Direction.UP;
        }
        return face;
    }

    public boolean m_7357_(@NotNull BlockState state, @NotNull BlockGetter blockGetter, @NotNull BlockPos pos, @NotNull PathComputationType pathComputationType) {
        return false;
    }
}

