/*
 * Decompiled with CFR 0.152.
 */
package org.primal.client.animation.entity;

import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import org.primal.block.NestBlock;
import org.primal.entity.animal.EagleEntity;
import org.primal.registry.Primal_Blocks;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class EagleAnimations {
    public static final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.eagle.idle");
    public static final RawAnimation FLY = RawAnimation.begin().thenLoop("animation.eagle.fly");
    public static final RawAnimation WALK = RawAnimation.begin().thenLoop("animation.eagle.walk");
    public static final RawAnimation SIT = RawAnimation.begin().thenLoop("animation.eagle.sit");
    public static final RawAnimation IDLE_BREAK_ONE = RawAnimation.begin().thenLoop("animation.eagle.idle_break_one");
    public static final RawAnimation GLIDE = RawAnimation.begin().thenLoop("animation.eagle.glide");
    public static final RawAnimation SWOOP = RawAnimation.begin().thenLoop("animation.eagle.swoop");
    public static final RawAnimation IDLE_BABY = RawAnimation.begin().thenLoop("animation.eagle_chick.idle");
    public static final RawAnimation WALK_BABY = RawAnimation.begin().thenLoop("animation.eagle_chick.walk");
    public static final RawAnimation SIT_BABY = RawAnimation.begin().thenLoop("animation.eagle_chick.sit");

    public static AnimationController<EagleEntity> mainController(EagleEntity eagle) {
        return new AnimationController((GeoAnimatable)eagle, state -> {
            state.setControllerSpeed(1.0f);
            switch (eagle.m_20089_()) {
                case SITTING: {
                    return state.setAndContinue(eagle.m_6162_() ? SIT_BABY : SIT);
                }
            }
            if (eagle.m_6162_()) {
                state.getController().transitionLength(0);
                if (state.getController().isPlayingTriggeredAnimation()) {
                    state.getController().transitionLength(0);
                    state.setControllerSpeed(1.0f);
                    return PlayState.CONTINUE;
                }
                if (state.isMoving()) {
                    state.setControllerSpeed(state.getLimbSwingAmount() * 4.0f);
                    return state.setAndContinue(WALK_BABY);
                }
                if (eagle.m_9236_().m_8055_(eagle.m_20097_()).m_60713_((Block)Primal_Blocks.NEST_BLOCK.get()) && !((Boolean)eagle.m_9236_().m_8055_(eagle.m_20097_()).m_61143_((Property)NestBlock.HAS_EGG)).booleanValue()) {
                    state.setControllerSpeed(1.0f);
                    return state.setAndContinue(SIT_BABY);
                }
                state.getController().transitionLength(2);
                state.setControllerSpeed(1.0f);
                return state.setAndContinue(IDLE_BABY);
            }
            state.getController().transitionLength(0);
            if (state.getController().isPlayingTriggeredAnimation()) {
                state.getController().transitionLength(0);
                state.setControllerSpeed(1.0f);
                return PlayState.CONTINUE;
            }
            if (state.isMoving()) {
                double speed = eagle.m_20184_().m_82553_();
                state.setControllerSpeed(state.getLimbSwingAmount() * 1.0f);
                return state.setAndContinue(!eagle.m_20096_() && eagle.m_146909_() > 50.0f ? SWOOP : (eagle.m_20096_() ? WALK : (speed > 0.3 ? GLIDE : FLY)));
            }
            state.getController().transitionLength(2);
            state.setControllerSpeed(1.0f);
            return state.setAndContinue(eagle.m_20096_() ? IDLE : FLY);
        });
    }
}

