/*
 * Decompiled with CFR 0.152.
 */
package org.primal.client.animation.replaced;

import net.minecraft.world.entity.animal.PolarBear;
import org.primal.entity.replaced.PolarBearReplaced;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class PolarBearAnimations {
    public static final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.polar_bear.idle");
    public static final RawAnimation WALK = RawAnimation.begin().thenLoop("animation.polar_bear.walk");
    public static final RawAnimation RUN = RawAnimation.begin().thenLoop("animation.polar_bear.run");
    public static final RawAnimation SWIM = RawAnimation.begin().thenLoop("animation.polar_bear.swim");
    public static final RawAnimation ATTACK = RawAnimation.begin().thenPlay("animation.polar_bear.attack");

    public static AnimationController<PolarBearReplaced> mainController(PolarBearReplaced animatable) {
        return new AnimationController((GeoAnimatable)animatable, state -> {
            PolarBear polarBear = animatable.getEntityFromState((AnimationState<PolarBearReplaced>)state);
            state.setControllerSpeed(1.0f);
            state.getController().transitionLength(0);
            if (state.getController().isPlayingTriggeredAnimation()) {
                state.getController().transitionLength(5);
                return PlayState.CONTINUE;
            }
            if (state.isMoving()) {
                if (polarBear.m_20069_()) {
                    state.setControllerSpeed(1.0f);
                    return state.setAndContinue(SWIM);
                }
                if (polarBear.m_5912_()) {
                    state.setControllerSpeed(state.getLimbSwingAmount() * (polarBear.m_6162_() ? 2.0f : 1.0f));
                    return state.setAndContinue(RUN);
                }
                state.setControllerSpeed(state.getLimbSwingAmount() * (float)(polarBear.m_6162_() ? 5 : 2));
                return state.setAndContinue(WALK);
            }
            state.setControllerSpeed(polarBear.m_20069_() && !state.isMoving() ? 0.5f : 1.0f);
            state.getController().transitionLength(20);
            return state.setAndContinue(polarBear.m_20069_() ? SWIM : IDLE);
        });
    }
}

