/*
 * Decompiled with CFR 0.152.
 */
package org.primal.datagen;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.primal.datagen.providers.Primal_AdvancementsGenerator;
import org.primal.datagen.providers.Primal_BannerPatternTagsGenerator;
import org.primal.datagen.providers.Primal_BiomeModifiersGenerator;
import org.primal.datagen.providers.Primal_BiomeTagGenerator;
import org.primal.datagen.providers.Primal_BlockModelGenerator;
import org.primal.datagen.providers.Primal_BlockStateGenerator;
import org.primal.datagen.providers.Primal_BlockTagsGenerator;
import org.primal.datagen.providers.Primal_DamageTypesTagGenerator;
import org.primal.datagen.providers.Primal_EntityTagGenerator;
import org.primal.datagen.providers.Primal_ItemModelGenerator;
import org.primal.datagen.providers.Primal_ItemTagsGenerator;
import org.primal.datagen.providers.Primal_LanguageFileGenerator;
import org.primal.datagen.providers.Primal_LootTablesBlocksGenerator;
import org.primal.datagen.providers.Primal_LootTablesEntitiesGenerator;
import org.primal.datagen.providers.Primal_RecipesGenerator;
import org.primal.datagen.providers.Primal_SoundsJsonGenerator;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="primal")
public final class Primal_DataGenerator {
    private static final RegistrySetBuilder BUILDER = new RegistrySetBuilder().m_254916_(ForgeRegistries.Keys.BIOME_MODIFIERS, Primal_BiomeModifiersGenerator::bootstrap);

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        generator.addProvider(event.includeClient(), (DataProvider)new Primal_BlockModelGenerator(output, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new Primal_BlockStateGenerator(output, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new Primal_ItemModelGenerator(output, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new Primal_SoundsJsonGenerator(output, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new Primal_LanguageFileGenerator(output));
        generator.addProvider(true, (DataProvider)new DatapackBuiltinEntriesProvider(output, lookupProvider, BUILDER, Set.of("minecraft", "primal")));
        generator.addProvider(event.includeServer(), (DataProvider)new Primal_EntityTagGenerator(output, lookupProvider, existingFileHelper));
        Primal_BlockTagsGenerator blockTagGenerator = (Primal_BlockTagsGenerator)generator.addProvider(event.includeServer(), (DataProvider)new Primal_BlockTagsGenerator(output, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new Primal_BiomeTagGenerator(output, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new Primal_DamageTypesTagGenerator(output, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new Primal_ItemTagsGenerator(output, lookupProvider, blockTagGenerator.m_274426_(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new Primal_BannerPatternTagsGenerator(output, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new Primal_RecipesGenerator(output));
        generator.addProvider(event.includeServer(), (DataProvider)Primal_DataGenerator.createLootTableProviders(output));
        generator.addProvider(event.includeServer(), (DataProvider)new Primal_AdvancementsGenerator(output, lookupProvider, existingFileHelper));
    }

    public static LootTableProvider createLootTableProviders(PackOutput output) {
        return new LootTableProvider(output, Set.of(), List.of(new LootTableProvider.SubProviderEntry(Primal_LootTablesBlocksGenerator::new, LootContextParamSets.f_81421_), new LootTableProvider.SubProviderEntry(Primal_LootTablesEntitiesGenerator::new, LootContextParamSets.f_81415_)));
    }
}

