/*
 * Decompiled with CFR 0.152.
 */
package org.primal.datagen.providers;

import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BannerPatternItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraftforge.common.data.LanguageProvider;
import org.primal.Primal_Registries;
import org.primal.registry.Primal_BannerPatterns;

public class Primal_LanguageFileGenerator
extends LanguageProvider {
    public Primal_LanguageFileGenerator(PackOutput output) {
        super(output, "primal", "en_us");
    }

    protected void addTranslations() {
        this.add("itemGroup.primal", "Primal");
        Primal_Registries.ENTITIES.getEntries().stream().filter(entry -> entry.getKey().m_135782_().m_135827_().equals("primal")).forEach(entry -> this.addEntityTranslation(entry.getKey()));
        Primal_Registries.ITEMS.getEntries().stream().filter(entry -> entry.getKey().m_135782_().m_135827_().equals("primal") && !(entry.get() instanceof BlockItem)).forEach(entry -> this.addItemTranslation((ResourceKey<Item>)entry.getKey()));
        Primal_Registries.BLOCKS.getEntries().stream().filter(entry -> entry.getKey().m_135782_().m_135827_().equals("primal")).forEach(entry -> this.addBlockTranslation((ResourceKey<Block>)entry.getKey()));
        Primal_Registries.MOB_EFFECTS.getEntries().stream().filter(entry -> entry.getKey().m_135782_().m_135827_().equals("primal")).forEach(entry -> {
            this.addEffectTranslation((ResourceKey<MobEffect>)entry.getKey());
            this.addPotionTranslation((ResourceKey<MobEffect>)entry.getKey());
        });
        this.add("subtitles.primal.entity.zombie.destroy_generic_egg", "Animal Egg stomped");
        this.add("subtitles.primal.entity.generic.chest", "Animal Chest equips");
        this.add("subtitles.primal.entity.generic.places_egg", "Places an egg");
        this.add("subtitles.primal.entity.generic.lays_egg", "Animal lays egg");
        this.add("subtitles.primal.entity.generic.egg_break", "Animal Egg breaks");
        this.add("subtitles.primal.entity.generic.egg_crack", "Animal Egg cracks");
        this.add("subtitles.primal.entity.generic.egg_hatch", "Animal Egg hatches");
        this.add("subtitles.primal.entity.bear.idle", "Bear growls");
        this.add("subtitles.primal.entity.bear.idle_angry", "Bear growls angrily");
        this.add("subtitles.primal.entity.bear.hurt", "Bear hurts");
        this.add("subtitles.primal.entity.bear.death", "Bear dies");
        this.add("subtitles.primal.entity.bear.roar", "Bear roars");
        this.add("subtitles.primal.entity.bear.snoring", "Bear snores");
        this.add("subtitles.primal.entity.bear.wake_up", "Bear wakes up");
        this.add("subtitles.primal.entity.bear.eat", "Bear eats");
        this.add("subtitles.primal.entity.shark.idle", "Shark groans");
        this.add("subtitles.primal.entity.shark.attack", "Shark attacks");
        this.add("subtitles.primal.entity.shark.hurt", "Shark hurts");
        this.add("subtitles.primal.entity.shark.death", "Shark dies");
        this.add("subtitles.primal.entity.shark.flop", "Shark flops");
        this.add("subtitles.primal.entity.crocodile.idle", "Crocodile growls");
        this.add("subtitles.primal.entity.crocodile.attack", "Crocodile attacks");
        this.add("subtitles.primal.entity.crocodile.hurt", "Crocodile hurts");
        this.add("subtitles.primal.entity.crocodile.death", "Crocodile dies");
        this.add("subtitles.primal.entity.crocodile.eat", "Crocodile eats");
        this.add("subtitles.primal.entity.crocodile.thrash", "Crocodile thrashes");
        this.add("subtitles.primal.entity.crocodile.splashes", "Violent water splashes");
        this.add("subtitles.primal.entity.crocodile.vomit", "Crocodile spit item");
        this.add("subtitles.primal.entity.crocodile.clock", "Tick-tock clock sounds");
        this.add("subtitles.primal.entity.common.armadillo_brush", "Scute is brushed off");
        this.add("subtitles.primal.entity.eagle.idle", "Eagle screeches");
        this.add("subtitles.primal.entity.eagle.flap", "Eagle flaps");
        this.add("subtitles.primal.entity.eagle.hurt", "Eagle hurts");
        this.add("subtitles.primal.entity.eagle.death", "Eagle dies");
        this.add("subtitles.primal.entity.eagle.eat", "Eagle eats");
        this.add("subtitles.primal.entity.eagle.shriek", "Eagle shrieks");
        this.add("subtitles.primal.entity.eagle.freedom", "FREEDOM");
        this.add("death.attack.shark_tooth", "%1$s was killed by a dead shark");
        this.add("death.attack.shark_tooth.player", "%1$s was killed by a dead shark while fighting %2$s");
        this.add("primal.gui.animal_wandering", "%1$s will wander around");
        this.add("primal.gui.animal_following", "%1$s will follow you");
        this.add("primal.gui.animal_sitting", "%1$s will sit down");
        this.add("advancements.primal.tame_bear.title", "Friend-Shaped Beast");
        this.add("advancements.primal.tame_bear.description", "Had strong enough confidence to tame a bear");
        this.add("advancements.primal.tame_all_bears.title", "We Bare Bears");
        this.add("advancements.primal.tame_all_bears.description", "Tame all Bear variants!");
        this.add("advancements.primal.survive_shark.title", "Test The Waters");
        this.add("advancements.primal.survive_shark.description", "Get back to full health after facing a shark attack");
        this.add("advancements.primal.swim_with_shark.title", "A Sense Of Empowerment");
        this.add("advancements.primal.swim_with_shark.description", "Power the sea with a Conduit and tip your supremacy over sharks");
        this.add("advancements.primal.feed_shark.title", "One Hungry Shark");
        this.add("advancements.primal.feed_shark.description", "Bring all passive oceanic mobs to the shark's table");
        this.add("advancements.primal.punch_crocodile.title", "Florida Shenanigans");
        this.add("advancements.primal.punch_crocodile.description", "Punch a crocodile with your bare hands");
        this.add("advancements.primal.clock_croc.title", "Tick-Tock Croc");
        this.add("advancements.primal.clock_croc.description", "Feed a crocodile with a clock, this probably will scare pillagers!");
        this.add("advancements.primal.tickle_crocodile.title", "Tickle tickle");
        this.add("advancements.primal.tickle_crocodile.description", "Tickle a crocodile with a feather and retrieve some items from its stomach");
        this.add("advancements.primal.kill_captain.title", "FREEDOM!!!!!");
        this.add("advancements.primal.kill_captain.description", "Kill a raid captain alongside your eagle");
        this.add("advancements.primal.tame_all_birds.title", "Birds Of Feathers");
        this.add("advancements.primal.tame_all_birds.description", "Tame all Birds including their variants. (Parrots & Eagle)");
        this.add("advancements.primal.get_eagle_egg.title", "Angry Birds");
        this.add("advancements.primal.get_eagle_egg.description", "Get an eagle egg. Don\u2019t forget to feed raw chicken to the baby, be a good parent!");
        this.add("advancements.primal.eat_apple_fritter.title", "Double-Glazed");
        this.add("advancements.primal.eat_apple_fritter.description", "Consume and absorb the nutrients of one apple fritter");
        Primal_BannerPatterns.Banner_Patterns.forEach(this::addBannerTranslation);
    }

    private void addBannerTranslation(ResourceKey<BannerPattern> banner) {
        String path = banner.m_135782_().m_135815_();
        String baseBannerTranslation = this.translate(path);
        String baseBannerTranslationKey = "block.minecraft.banner.primal." + path;
        this.add(baseBannerTranslationKey, baseBannerTranslation);
        for (DyeColor dyeColor : DyeColor.values()) {
            String translatedDyeColor = this.translate(dyeColor.m_41065_());
            this.add(baseBannerTranslationKey + "." + dyeColor.m_41065_(), translatedDyeColor + " " + baseBannerTranslation);
        }
    }

    private void addPotionTranslation(ResourceKey<MobEffect> effectKey) {
        String effect = effectKey.m_135782_().m_135815_();
        List<Pair> types = List.of(Pair.of((Object)"potion", (Object)"Potion of "), Pair.of((Object)"splash_potion", (Object)"Splash Potion of "), Pair.of((Object)"lingering_potion", (Object)"Lingering Potion of "), Pair.of((Object)"tipped_arrow", (Object)"Arrow of "));
        for (Pair type : types) {
            String id = "item.minecraft." + (String)type.getFirst() + ".effect." + effect;
            String translation = (String)type.getSecond() + this.translate(effect);
            this.add(id, translation);
        }
    }

    private void addEntityTranslation(ResourceKey<EntityType<?>> item) {
        String path = item.m_135782_().m_135815_();
        String translation = this.translate(path);
        this.add((EntityType)BuiltInRegistries.f_256780_.m_7745_(item.m_135782_()), translation);
    }

    private void addItemTranslation(ResourceKey<Item> item) {
        String path = item.m_135782_().m_135815_();
        String translation = this.translate(path);
        Object object = BuiltInRegistries.f_257033_.m_7745_(item.m_135782_());
        if (object instanceof BannerPatternItem) {
            BannerPatternItem bannerPatternItem = (BannerPatternItem)object;
            String resourceKeyPath = bannerPatternItem.m_220010_().f_203868_().m_135815_();
            String[] resourceKeySplitted = resourceKeyPath.split("/");
            this.add((Item)BuiltInRegistries.f_257033_.m_7745_(item.m_135782_()), "Banner Pattern");
            String translationBanner = this.translate(resourceKeySplitted[1]);
            this.add(((Item)BuiltInRegistries.f_257033_.m_7745_(item.m_135782_())).m_5524_() + ".desc", translationBanner);
        } else {
            this.add((Item)BuiltInRegistries.f_257033_.m_7745_(item.m_135782_()), translation);
        }
    }

    private void addBlockTranslation(ResourceKey<Block> block) {
        String path = block.m_135782_().m_135815_();
        String translation = this.translate(path);
        this.add((Block)BuiltInRegistries.f_256975_.m_7745_(block.m_135782_()), translation);
    }

    private void addEffectTranslation(ResourceKey<MobEffect> block) {
        String path = block.m_135782_().m_135815_();
        String translation = this.translate(path);
        this.add((MobEffect)BuiltInRegistries.f_256974_.m_7745_(block.m_135782_()), translation);
    }

    private String translate(String path) {
        return Arrays.stream(path.split("_")).map(word -> Character.toUpperCase(word.charAt(0)) + word.substring(1)).collect(Collectors.joining(" "));
    }
}

