/*
 * Decompiled with CFR 0.152.
 */
package org.primal.datagen.providers;

import net.minecraft.data.PackOutput;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.SoundDefinition;
import net.minecraftforge.common.data.SoundDefinitionsProvider;
import net.minecraftforge.registries.RegistryObject;
import org.primal.registry.Primal_Sounds;

public class Primal_SoundsJsonGenerator
extends SoundDefinitionsProvider {
    public Primal_SoundsJsonGenerator(PackOutput output, ExistingFileHelper helper) {
        super(output, "primal", helper);
    }

    public void registerSounds() {
        this.addSpecificSound(Primal_Sounds.ANIMAL_CHEST, "minecraft:mob/chicken/plop");
        this.addSpecificSound(Primal_Sounds.PLACES_EGG, "minecraft:mob/chicken/plop");
        this.addSpecificSound(Primal_Sounds.LAYS_EGG, "minecraft:mob/turtle/egg/drop_egg1", "minecraft:mob/turtle/egg/drop_egg2");
        this.addSpecificSound(Primal_Sounds.ZOMBIE_DESTROY_GENERIC_EGG, "minecraft:mob/turtle/egg/jump_egg1", "minecraft:mob/turtle/egg/jump_egg2", "minecraft:mob/turtle/egg/jump_egg3", "minecraft:mob/turtle/egg/jump_egg4");
        this.addSpecificSound(Primal_Sounds.EGG_BREAK, "minecraft:mob/turtle/egg/egg_break1", "minecraft:mob/turtle/egg/egg_break2");
        this.addSpecificSound(Primal_Sounds.EGG_HATCH, "minecraft:mob/turtle/baby/egg_hatched1", "minecraft:mob/turtle/baby/egg_hatched2", "minecraft:mob/turtle/baby/egg_hatched3");
        this.addSpecificSound(Primal_Sounds.EGG_CRACK, "minecraft:mob/turtle/egg/egg_crack1", "minecraft:mob/turtle/egg/egg_crack2", "minecraft:mob/turtle/egg/egg_crack3", "minecraft:mob/turtle/egg/egg_crack4", "minecraft:mob/turtle/egg/egg_crack5");
        this.addSoundEntity(Primal_Sounds.BEAR_IDLE, 5);
        this.addSoundEntity(Primal_Sounds.BEAR_IDLE_ANGRY, 4);
        this.addSoundEntity(Primal_Sounds.BEAR_HURT, 4);
        this.addSoundEntity(Primal_Sounds.BEAR_DEATH, 4);
        this.addSoundEntity(Primal_Sounds.BEAR_ROAR, 1);
        this.addSoundEntity(Primal_Sounds.BEAR_SNORING, 1);
        this.addSoundEntity(Primal_Sounds.BEAR_WAKE_UP, 1);
        this.addSpecificSound(Primal_Sounds.BEAR_EAT, "minecraft:mob/sniffer/eat1", "minecraft:mob/sniffer/eat2", "minecraft:mob/sniffer/eat3");
        this.addSoundEntity(Primal_Sounds.SHARK_IDLE, 4);
        this.addSoundEntity(Primal_Sounds.SHARK_ATTACK, 3);
        this.addSoundEntity(Primal_Sounds.SHARK_HURT, 4);
        this.addSoundEntity(Primal_Sounds.SHARK_DEATH, 1);
        this.addSpecificSound(Primal_Sounds.SHARK_FLOP, "minecraft:entity/fish/flop1", "minecraft:entity/fish/flop2", "minecraft:entity/fish/flop3", "minecraft:entity/fish/flop4");
        this.addSoundEntity(Primal_Sounds.CROCODILE_IDLE, 5);
        this.addSoundEntity(Primal_Sounds.CROCODILE_HURT, 3);
        this.addSoundEntity(Primal_Sounds.CROCODILE_ATTACK, 3);
        this.addSoundEntity(Primal_Sounds.CROCODILE_DEATH, 2);
        this.addSoundEntity(Primal_Sounds.CROCODILE_EAT, 3);
        this.addSoundEntity(Primal_Sounds.CROCODILE_VOMIT, 4);
        this.addSoundEntity(Primal_Sounds.CROCODILE_THRASH, 1);
        this.addSoundEntity(Primal_Sounds.CROCODILE_SPLASHES, 1);
        this.addSpecificSound(Primal_Sounds.CROCODILE_CLOCK, "minecraft:note/hat");
        this.addSoundEntity(Primal_Sounds.ARMADILLO_BRUSH, 2);
        this.addSoundEntity(Primal_Sounds.EAGLE_IDLE, 5);
        this.addSoundEntity(Primal_Sounds.EAGLE_HURT, 4);
        this.addSoundEntity(Primal_Sounds.EAGLE_FLAP, 3);
        this.addSoundEntity(Primal_Sounds.EAGLE_DEATH, 1);
        this.addSpecificSound(Primal_Sounds.EAGLE_EAT, "minecraft:mob/parrot/eat1", "minecraft:mob/parrot/eat2", "minecraft:mob/parrot/eat3");
        this.addSoundEntity(Primal_Sounds.EAGLE_SHRIEK, 2);
        this.addSoundEntity(Primal_Sounds.EAGLE_FREEDOM, 1);
    }

    private void addSpecificSound(RegistryObject<SoundEvent> sound, String ... sounds) {
        SoundDefinition definition = Primal_SoundsJsonGenerator.definition().subtitle("subtitles.primal." + sound.getId().m_135815_());
        for (String name : sounds) {
            definition.with(Primal_SoundsJsonGenerator.sound((String)name));
        }
        this.add((SoundEvent)sound.get(), definition);
    }

    private void addSoundEntity(RegistryObject<SoundEvent> sound, int soundVariationAmount) {
        SoundDefinition definition = Primal_SoundsJsonGenerator.definition().subtitle("subtitles.primal." + sound.getId().m_135815_());
        String[] soundPathSplitted = sound.getId().m_135815_().split("\\.");
        String mobType = soundPathSplitted[1];
        String soundType = soundPathSplitted[2];
        String finalPath = mobType.equals("common") ? soundType : mobType + "_" + soundType;
        for (int i = 1; i <= soundVariationAmount; ++i) {
            definition.with(Primal_SoundsJsonGenerator.sound((String)("primal:entity/" + mobType + "/" + finalPath + i)));
        }
        this.add((SoundEvent)sound.get(), definition);
    }
}

