/*
 * Decompiled with CFR 0.152.
 */
package org.primal.entity.ai;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalMakeLove;
import net.minecraft.world.entity.ai.behavior.BabyFollowAdult;
import net.minecraft.world.entity.ai.behavior.BecomePassiveIfMemoryPresent;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.EraseMemoryIf;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.RandomLookAround;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.primal.entity.ai.behavior.bear.BearBeg;
import org.primal.entity.ai.behavior.bear.BearDefeated;
import org.primal.entity.ai.behavior.bear.BearRaidBeehive;
import org.primal.entity.ai.behavior.bear.BearRaidSweetBerryBush;
import org.primal.entity.ai.behavior.bear.BearRoar;
import org.primal.entity.ai.behavior.bear.BearSitting;
import org.primal.entity.ai.behavior.bear.BearSleep;
import org.primal.entity.ai.behavior.bear.SetBearLookRoarTarget;
import org.primal.entity.ai.behavior.bear.SetBearRoarTarget;
import org.primal.entity.ai.behavior.generic.FollowOwner;
import org.primal.entity.animal.BearEntity;
import org.primal.registry.Primal_Activities;
import org.primal.registry.Primal_Entities;
import org.primal.registry.Primal_Sensors;

public final class BearAi {
    private static final ImmutableList<SensorType<? extends Sensor<? super BearEntity>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.f_26811_, (Object)SensorType.f_26814_, (Object)((SensorType)Primal_Sensors.NEAREST_ADULT_BEAR.get()), (Object)((SensorType)Primal_Sensors.NEAREST_BABY.get()), (Object)SensorType.f_26812_, (Object)((SensorType)Primal_Sensors.BEAR_ATTACK_SENSOR.get()), (Object)((SensorType)Primal_Sensors.BEAR_NEAREST_BEEHIVE_SENSOR.get()), (Object)((SensorType)Primal_Sensors.BEAR_NEAREST_SWEET_BERRY_BUSH_SENSOR.get()), (Object)((SensorType)Primal_Sensors.BEAR_TEMPTATIONS_SENSOR.get()), (Object)((SensorType)Primal_Sensors.BEAR_REPELLENT_SENSOR.get()));
    private static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.f_148204_, (Object)MemoryModuleType.f_148205_, (Object)MemoryModuleType.f_26371_, (Object)MemoryModuleType.f_26370_, (Object)MemoryModuleType.f_26326_, (Object)MemoryModuleType.f_26377_, (Object)MemoryModuleType.f_26372_, (Object)MemoryModuleType.f_26373_, (Object)MemoryModuleType.f_148194_, (Object)MemoryModuleType.f_217782_, (Object)MemoryModuleType.f_217771_, (Object)MemoryModuleType.f_26381_, (Object[])new MemoryModuleType[]{MemoryModuleType.f_26382_, MemoryModuleType.f_26375_, MemoryModuleType.f_217768_, MemoryModuleType.f_148197_, MemoryModuleType.f_148198_, MemoryModuleType.f_148196_, MemoryModuleType.f_26383_, MemoryModuleType.f_26356_});
    private static final UniformInt ADULT_FOLLOW_RANGE = UniformInt.m_146622_((int)5, (int)16);
    private static final UniformInt RETREAT_DURATION = TimeUtil.m_145020_((int)5, (int)20);

    public static Ingredient getTemptations() {
        return Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42457_});
    }

    private static void initMemories(BearEntity BearEntity2, RandomSource random) {
    }

    public static Brain.Provider<BearEntity> brainProvider() {
        return Brain.m_21923_(MEMORY_TYPES, SENSOR_TYPES);
    }

    public static Brain<?> makeBrain(Brain<BearEntity> brain) {
        BearAi.initCoreActivity(brain);
        BearAi.initIdleActivity(brain);
        BearAi.initRoarActivity(brain);
        BearAi.initFightActivity(brain);
        BearAi.initRetreatActivity(brain);
        BearAi.initFollowActivity(brain);
        BearAi.initSitActivity(brain);
        BearAi.initJockeyActivity(brain);
        brain.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        brain.m_21944_(Activity.f_37979_);
        brain.m_21962_();
        return brain;
    }

    private static void initCoreActivity(Brain<BearEntity> brain) {
        brain.m_21891_(Activity.f_37978_, 0, ImmutableList.of((Object)new Swim(0.8f), SetBearLookRoarTarget.create(), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink()));
    }

    private static void initRoarActivity(Brain<BearEntity> brain) {
        brain.m_21895_(Activity.f_219851_, 10, ImmutableList.of((Object)((Object)new BearRoar())), MemoryModuleType.f_217782_);
    }

    private static void initIdleActivity(Brain<BearEntity> brain) {
        brain.m_21891_(Activity.f_37979_, 10, ImmutableList.of((Object)((Object)new BearDefeated()), (Object)BecomePassiveIfMemoryPresent.m_257393_((MemoryModuleType)MemoryModuleType.f_26356_, (int)200), (Object)SetWalkTargetAwayFrom.m_257620_((MemoryModuleType)MemoryModuleType.f_26356_, (float)1.5f, (int)8, (boolean)true), (Object)((Object)new BearSleep()), (Object)new AnimalMakeLove((EntityType)Primal_Entities.BEAR.get(), 1.0f), (Object)new AnimalMakeLove(EntityType.f_20514_, 1.0f), (Object)((Object)new BearBeg()), SetBearRoarTarget.create(), (Object)((Object)new BearRaidBeehive()), (Object)((Object)new BearRaidSweetBerryBush()), (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)new FollowTemptation(livingEntity -> Float.valueOf(1.0f), livingEntity -> livingEntity.m_6162_() ? 2.5 : 3.5), (Object)4), (Object)Pair.of((Object)BehaviorBuilder.m_257845_(Predicate.not(BearEntity::refuseToMove), (OneShot)BabyFollowAdult.m_257685_((UniformInt)ADULT_FOLLOW_RANGE, (float)1.0f)), (Object)1))), (Object)SetEntityLookTargetSometimes.m_257472_((EntityType)EntityType.f_20532_, (float)6.0f, (UniformInt)UniformInt.m_146622_((int)30, (int)60)), (Object[])new BehaviorControl[]{new RandomLookAround((IntProvider)UniformInt.m_146622_((int)150, (int)250), 30.0f, 0.0f, 0.0f), BearAi.createIdleMovementBehaviors()}));
    }

    private static void initFollowActivity(Brain<BearEntity> brain) {
        brain.m_21891_((Activity)Primal_Activities.FOLLOW.get(), 10, ImmutableList.of((Object)((Object)new BearDefeated()), (Object)new AnimalMakeLove((EntityType)Primal_Entities.BEAR.get(), 1.0f), (Object)new AnimalMakeLove(EntityType.f_20514_, 1.0f), (Object)((Object)new BearBeg()), SetBearRoarTarget.create(), (Object)((Object)new FollowOwner(pet -> {
            BearEntity bear;
            return pet instanceof BearEntity && !(bear = (BearEntity)((Object)pet)).bearCollapses();
        })), (Object)SetEntityLookTargetSometimes.m_257472_((EntityType)EntityType.f_20532_, (float)6.0f, (UniformInt)UniformInt.m_146622_((int)30, (int)60)), (Object)new RandomLookAround((IntProvider)UniformInt.m_146622_((int)150, (int)250), 30.0f, 0.0f, 0.0f), BearAi.createIdleMovementBehaviors()));
    }

    private static void initSitActivity(Brain<BearEntity> brain) {
        brain.m_21900_((Activity)Primal_Activities.SIT.get(), ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new BearSitting()))));
    }

    private static void initFightActivity(Brain<BearEntity> brain) {
        brain.m_21895_(Activity.f_37988_, 10, ImmutableList.of((Object)BecomePassiveIfMemoryPresent.m_257393_((MemoryModuleType)MemoryModuleType.f_26356_, (int)200), (Object)SetWalkTargetFromAttackTargetIfTargetOutOfReach.m_257469_((float)1.0f), (Object)MeleeAttack.m_257733_((int)20), (Object)SetEntityLookTarget.m_257660_((float)50.0f), (Object)StopAttackingIfTargetInvalid.m_257822_(), (Object)EraseMemoryIf.m_258093_(bear -> bear.m_27593_() || bear.bearCollapses(), (MemoryModuleType)MemoryModuleType.f_26372_)), MemoryModuleType.f_26372_);
    }

    private static void initJockeyActivity(Brain<BearEntity> brain) {
        brain.m_21891_((Activity)Primal_Activities.JOCKEY.get(), 10, ImmutableList.of((Object)((Object)new BearDefeated()), (Object)new RandomLookAround((IntProvider)UniformInt.m_146622_((int)150, (int)250), 30.0f, 0.0f, 0.0f)));
    }

    private static void initRetreatActivity(Brain<BearEntity> brain) {
        brain.m_21895_(Activity.f_37991_, 10, ImmutableList.of((Object)SetWalkTargetAwayFrom.m_257370_((MemoryModuleType)MemoryModuleType.f_26383_, (float)1.2f, (int)20, (boolean)false), BearAi.createIdleMovementBehaviors(), (Object)SetEntityLookTargetSometimes.m_257458_((float)8.0f, (UniformInt)UniformInt.m_146622_((int)30, (int)60)), (Object)EraseMemoryIf.m_258093_(bear -> !bear.m_6162_(), (MemoryModuleType)MemoryModuleType.f_26383_)), MemoryModuleType.f_26383_);
    }

    public static void wasHurtBy(BearEntity bear, LivingEntity target) {
        Brain<BearEntity> brain = bear.m_6274_();
        brain.m_21936_(MemoryModuleType.f_26375_);
        if (bear.m_6162_()) {
            BearAi.retreatFromNearestTarget(bear, target);
            for (BearEntity nearBear : BearAi.getNearestAdultBears(bear)) {
                nearBear.m_6274_().m_21879_(MemoryModuleType.f_26372_, (Object)target);
            }
        } else {
            bear.m_6274_().m_21879_(MemoryModuleType.f_26372_, (Object)target);
        }
    }

    private static void retreatFromNearestTarget(BearEntity bear, LivingEntity target) {
        Brain<BearEntity> brain = bear.m_6274_();
        LivingEntity avoidTarget = BehaviorUtils.m_22625_((LivingEntity)bear, (Optional)brain.m_21952_(MemoryModuleType.f_26383_), (LivingEntity)target);
        avoidTarget = BehaviorUtils.m_22625_((LivingEntity)bear, (Optional)brain.m_21952_(MemoryModuleType.f_26372_), (LivingEntity)avoidTarget);
        BearAi.setAvoidTarget(bear, avoidTarget);
    }

    private static void setAvoidTarget(BearEntity bear, LivingEntity target) {
        bear.m_6274_().m_21936_(MemoryModuleType.f_26372_);
        bear.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        bear.m_6274_().m_21882_(MemoryModuleType.f_26383_, (Object)target, (long)RETREAT_DURATION.m_214085_(bear.m_9236_().f_46441_));
    }

    private static List<BearEntity> getNearestAdultBears(BearEntity bear) {
        return bear.m_9236_().m_45976_(BearEntity.class, bear.m_20191_().m_82377_(20.0, 5.0, 20.0)).stream().filter(bear1 -> !bear1.m_21824_() && !bear1.m_6162_()).toList();
    }

    private static RunOne<BearEntity> createIdleMovementBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)BehaviorBuilder.m_257845_(Predicate.not(BearEntity::refuseToMove), (OneShot)RandomStroll.m_257965_((float)1.0f)), (Object)1), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    public static void updateActivity(BearEntity bear) {
        if (bear.isSitting()) {
            bear.m_6274_().m_21889_((Activity)Primal_Activities.SIT.get());
        } else if (bear.isFollowing()) {
            bear.m_6274_().m_21926_((List)ImmutableList.of((Object)Activity.f_219851_, (Object)Activity.f_37988_, (Object)((Activity)Primal_Activities.FOLLOW.get())));
            bear.m_21561_(bear.m_6274_().m_21874_(MemoryModuleType.f_26372_));
        } else if (bear.m_6162_()) {
            if (bear.isBearJockey()) {
                bear.m_6274_().m_21926_((List)ImmutableList.of((Object)((Activity)Primal_Activities.JOCKEY.get())));
            } else {
                bear.m_6274_().m_21926_((List)ImmutableList.of((Object)Activity.f_37991_, (Object)Activity.f_37979_));
            }
        } else {
            bear.m_6274_().m_21926_((List)ImmutableList.of((Object)Activity.f_219851_, (Object)Activity.f_37988_, (Object)Activity.f_37979_));
            bear.m_21561_(bear.m_6274_().m_21874_(MemoryModuleType.f_26372_));
        }
    }

    public static boolean isPosNearNearestRepellent(BearEntity bear, BlockPos pos) {
        Optional optional = bear.m_6274_().m_21952_(MemoryModuleType.f_26356_);
        return optional.isPresent() && ((BlockPos)optional.get()).m_123314_((Vec3i)pos, 8.0);
    }
}

