/*
 * Decompiled with CFR 0.152.
 */
package org.primal.entity.ai;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.EraseMemoryIf;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.RandomLookAround;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;
import org.primal.entity.ai.behavior.generic.TriesReturnToWater;
import org.primal.entity.ai.behavior.shark.SharkFollowConduitPlayer;
import org.primal.entity.ai.behavior.shark.SharkGoesToConduit;
import org.primal.entity.ai.behavior.shark.SharkJumpOutWater;
import org.primal.entity.animal.SharkEntity;
import org.primal.registry.Primal_Activities;
import org.primal.registry.Primal_Advancements;
import org.primal.registry.Primal_MemoryModuleTypes;
import org.primal.registry.Primal_Sensors;

public class SharkAi {
    protected static final ImmutableList<SensorType<? extends Sensor<? super SharkEntity>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.f_26811_, (Object)SensorType.f_26812_, (Object)SensorType.f_26814_, (Object)SensorType.f_217822_, (Object)((SensorType)Primal_Sensors.SHARK_ATTACK_SENSOR.get()), (Object)((SensorType)Primal_Sensors.SHARK_NEAR_CONDUIT_PLAYER.get()), (Object)((SensorType)Primal_Sensors.SHARK_NEAREST_CONDUIT.get()));
    protected static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.f_148205_, (Object)MemoryModuleType.f_26371_, (Object)MemoryModuleType.f_26370_, (Object)MemoryModuleType.f_26326_, (Object)MemoryModuleType.f_26377_, (Object)MemoryModuleType.f_26372_, (Object)MemoryModuleType.f_26373_, (Object)MemoryModuleType.f_148194_, (Object)MemoryModuleType.f_26381_, (Object)MemoryModuleType.f_26382_, (Object)MemoryModuleType.f_26375_, (Object)MemoryModuleType.f_217768_, (Object[])new MemoryModuleType[]{MemoryModuleType.f_148197_, MemoryModuleType.f_148198_, MemoryModuleType.f_148196_, MemoryModuleType.f_26383_, MemoryModuleType.f_148201_, (MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_CONDUIT_PLAYER.get(), (MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_IMPORTANT_BLOCK.get(), MemoryModuleType.f_26336_, (MemoryModuleType)Primal_MemoryModuleTypes.LAST_ATTACK_TARGET.get()});
    private static final UniformInt ADULT_FOLLOW_RANGE = UniformInt.m_146622_((int)5, (int)16);
    private static final UniformInt RETREAT_DURATION = TimeUtil.m_145020_((int)5, (int)20);

    private static void initMemories(SharkEntity SharkEntity2, RandomSource random) {
    }

    public static Brain.Provider<SharkEntity> brainProvider() {
        return Brain.m_21923_(MEMORY_TYPES, SENSOR_TYPES);
    }

    public static Brain<?> makeBrain(Brain<SharkEntity> brain) {
        SharkAi.initCoreActivity(brain);
        SharkAi.initIdleActivity(brain);
        SharkAi.initFightActivity(brain);
        SharkAi.initRetreatActivity(brain);
        SharkAi.initBeachedActivity(brain);
        SharkAi.initJockeyActivity(brain);
        brain.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        brain.m_21944_(Activity.f_37979_);
        brain.m_21962_();
        return brain;
    }

    private static void initCoreActivity(Brain<SharkEntity> brain) {
        brain.m_21891_(Activity.f_37978_, 0, ImmutableList.of((Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), (Object)((Object)new TriesReturnToWater()), (Object)EraseMemoryIf.m_258093_(shark -> shark.m_6274_().m_21952_(MemoryModuleType.f_26372_).isPresent() && !shark.m_6779_((LivingEntity)shark.m_6274_().m_21952_(MemoryModuleType.f_26372_).get()), (MemoryModuleType)MemoryModuleType.f_26372_)));
    }

    private static void initIdleActivity(Brain<SharkEntity> brain) {
        brain.m_21891_(Activity.f_37979_, 10, ImmutableList.of((Object)StartAttacking.m_257710_(SharkAi::findNearestValidAttackTarget), (Object)((Object)new SharkFollowConduitPlayer()), (Object)((Object)new SharkGoesToConduit()), (Object)SetEntityLookTargetSometimes.m_257472_((EntityType)EntityType.f_20532_, (float)6.0f, (UniformInt)UniformInt.m_146622_((int)30, (int)60)), (Object)new FollowTemptation(p_218740_ -> Float.valueOf(1.25f)), SharkAi.createIdleMovementBehaviors()));
    }

    private static void initBeachedActivity(Brain<SharkEntity> brain) {
        brain.m_21891_((Activity)Primal_Activities.BEACHED.get(), 10, ImmutableList.of(SharkAi.createIdleMovementBehaviors()));
    }

    private static void initFightActivity(Brain<SharkEntity> brain) {
        brain.m_21895_(Activity.f_37988_, 10, ImmutableList.of((Object)((Object)new SharkJumpOutWater()), (Object)SetWalkTargetFromAttackTargetIfTargetOutOfReach.m_257469_((float)1.0f), (Object)MeleeAttack.m_257733_((int)20), (Object)SetEntityLookTarget.m_257660_((float)50.0f), (Object)StopAttackingIfTargetInvalid.m_257822_()), MemoryModuleType.f_26372_);
    }

    private static void initRetreatActivity(Brain<SharkEntity> brain) {
        brain.m_21895_(Activity.f_37991_, 10, ImmutableList.of((Object)SetWalkTargetAwayFrom.m_257370_((MemoryModuleType)MemoryModuleType.f_26383_, (float)1.0f, (int)10, (boolean)false), SharkAi.createIdleMovementBehaviors(), (Object)SetEntityLookTargetSometimes.m_257458_((float)8.0f, (UniformInt)UniformInt.m_146622_((int)30, (int)60))), MemoryModuleType.f_26383_);
    }

    private static void initJockeyActivity(Brain<SharkEntity> brain) {
        brain.m_21891_((Activity)Primal_Activities.JOCKEY.get(), 10, ImmutableList.of((Object)new RandomLookAround((IntProvider)UniformInt.m_146622_((int)150, (int)250), 30.0f, 0.0f, 0.0f)));
    }

    private static RunOne<SharkEntity> createIdleMovementBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)BehaviorBuilder.m_257845_(Predicate.not(Mob::m_5912_), (OneShot)RandomStroll.m_257965_((float)1.0f)), (Object)1), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    public static void wasHurtBy(SharkEntity bear, LivingEntity target) {
        Brain<SharkEntity> brain = bear.m_6274_();
        brain.m_21936_(MemoryModuleType.f_26375_);
        if (bear.m_6162_()) {
            SharkAi.retreatFromNearestTarget(bear, target);
        } else {
            bear.m_6274_().m_21879_(MemoryModuleType.f_26372_, (Object)target);
        }
    }

    private static void retreatFromNearestTarget(SharkEntity bear, LivingEntity target) {
        Brain<SharkEntity> brain = bear.m_6274_();
        LivingEntity avoidTarget = BehaviorUtils.m_22625_((LivingEntity)bear, (Optional)brain.m_21952_(MemoryModuleType.f_26383_), (LivingEntity)target);
        avoidTarget = BehaviorUtils.m_22625_((LivingEntity)bear, (Optional)brain.m_21952_(MemoryModuleType.f_26372_), (LivingEntity)avoidTarget);
        SharkAi.setAvoidTarget(bear, avoidTarget);
    }

    private static void setAvoidTarget(SharkEntity bear, LivingEntity target) {
        bear.m_6274_().m_21936_(MemoryModuleType.f_26372_);
        bear.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        bear.m_6274_().m_21882_(MemoryModuleType.f_26383_, (Object)target, (long)RETREAT_DURATION.m_214085_(bear.m_9236_().f_46441_));
    }

    public static void updateActivity(SharkEntity shark) {
        Brain<SharkEntity> brain = shark.m_6274_();
        if (shark.m_6162_()) {
            brain.m_21926_((List)ImmutableList.of((Object)Activity.f_37991_, (Object)Activity.f_37979_));
        } else if (shark.shouldBeBeached()) {
            brain.m_21926_((List)ImmutableList.of((Object)((Activity)Primal_Activities.BEACHED.get())));
        } else {
            if (shark.isSharkJockey()) {
                brain.m_21926_((List)ImmutableList.of((Object)((Activity)Primal_Activities.JOCKEY.get())));
            } else {
                brain.m_21926_((List)ImmutableList.of((Object)Activity.f_37991_, (Object)Activity.f_37988_, (Object)Activity.f_37979_));
            }
            shark.m_21561_(brain.m_21874_(MemoryModuleType.f_26372_));
        }
        SharkAi.triggerSurviveSharkAdvancement(brain, shark);
    }

    private static void triggerSurviveSharkAdvancement(Brain<SharkEntity> brain, SharkEntity shark) {
        ServerPlayer player;
        LivingEntity last_target;
        if (brain.m_21952_(MemoryModuleType.f_26372_).isPresent()) {
            brain.m_21882_((MemoryModuleType)Primal_MemoryModuleTypes.LAST_ATTACK_TARGET.get(), (Object)((LivingEntity)brain.m_21952_(MemoryModuleType.f_26372_).get()), 200L);
        }
        if (brain.m_21952_((MemoryModuleType)Primal_MemoryModuleTypes.LAST_ATTACK_TARGET.get()).isPresent() && (last_target = (LivingEntity)brain.m_21952_((MemoryModuleType)Primal_MemoryModuleTypes.LAST_ATTACK_TARGET.get()).get()) instanceof ServerPlayer && !shark.m_6779_((LivingEntity)(player = (ServerPlayer)last_target)) && player.m_21223_() >= player.m_21233_() && player.m_21188_() instanceof SharkEntity) {
            Primal_Advancements.SURVIVE_SHARK.trigger(player);
        }
    }

    private static Optional<? extends LivingEntity> findNearestValidAttackTarget(SharkEntity shark) {
        return BehaviorUtils.m_217126_((LivingEntity)shark) ? Optional.empty() : shark.m_6274_().m_21952_(MemoryModuleType.f_148194_);
    }
}

