/*
 * Decompiled with CFR 0.152.
 */
package org.primal.entity.ai.behavior.bear;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.behavior.Behavior;
import org.jetbrains.annotations.NotNull;
import org.primal.entity.animal.BearEntity;

public class BearDefeated
extends Behavior<BearEntity> {
    public BearDefeated() {
        super((Map)ImmutableMap.of(), Integer.MAX_VALUE);
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel level, @NotNull BearEntity owner) {
        return this.canStillUse(level, owner, 0L);
    }

    protected boolean canStillUse(@NotNull ServerLevel level, @NotNull BearEntity entity, long gameTime) {
        return entity.bearCollapses();
    }

    protected void start(@NotNull ServerLevel level, BearEntity bear, long gameTime) {
        bear.stopMoving();
        if (!bear.isBearSleeping()) {
            bear.triggerAnim("base_controller", "sleep_start");
        }
        bear.m_20124_(Pose.CROAKING);
        if (bear.m_20160_()) {
            bear.m_20153_();
        }
        bear.setBearSleeping(true);
    }

    protected void tick(@NotNull ServerLevel level, @NotNull BearEntity bear, long gameTime) {
        bear.stopMoving();
    }

    protected void stop(@NotNull ServerLevel level, BearEntity entity, long gameTime) {
        entity.triggerAnim("base_controller", "sleep_end");
        entity.m_20124_(Pose.STANDING);
        if (entity.getWakeUpSound() != null) {
            entity.m_5496_(entity.getWakeUpSound(), 1.0f, 0.8f + (float)entity.m_217043_().m_216332_(0, 2) * 0.1f);
        }
        entity.setBearSleeping(false);
    }
}

