/*
 * Decompiled with CFR 0.152.
 */
package org.primal.entity.ai.behavior.bear;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.primal.entity.animal.BearEntity;
import org.primal.registry.Primal_MemoryModuleTypes;

public class BearRaidBeehive
extends Behavior<BearEntity> {
    public BearRaidBeehive() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_217782_, (Object)MemoryStatus.VALUE_ABSENT, (Object)((MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_BEEHIVE.get()), (Object)MemoryStatus.VALUE_PRESENT));
    }

    protected boolean canStillUse(@NotNull ServerLevel level, BearEntity entity, long gameTime) {
        return entity.m_6274_().m_21952_((MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_BEEHIVE.get()).isPresent();
    }

    protected void start(@NotNull ServerLevel level, BearEntity entity, long gameTime) {
        entity.m_6274_().m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget((BlockPos)entity.m_6274_().m_21952_((MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_BEEHIVE.get()).get(), 1.0f, 2));
    }

    protected void tick(@NotNull ServerLevel level, BearEntity owner, long gameTime) {
        BlockPos nearestBeehive = owner.m_6274_().m_21952_((MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_BEEHIVE.get()).orElse(null);
        if (nearestBeehive != null && (float)owner.m_20183_().m_123333_((Vec3i)nearestBeehive) <= 2.0f) {
            BlockState state = level.m_8055_(nearestBeehive);
            if (!state.m_204336_(BlockTags.f_13072_)) {
                return;
            }
            BeehiveBlockEntity beehiveBlockEntity = (BeehiveBlockEntity)level.m_7702_(nearestBeehive);
            if (beehiveBlockEntity == null) {
                return;
            }
            for (Entity entity : beehiveBlockEntity.m_58759_(state, BeehiveBlockEntity.BeeReleaseStatus.EMERGENCY)) {
                ((Bee)entity).m_6710_((LivingEntity)owner);
            }
            level.m_46953_(nearestBeehive, false, (Entity)owner);
            owner.triggerAnim("attack", "attack");
            owner.setHoneyCounter(12000);
        }
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel level, BearEntity owner) {
        if (owner.m_6162_() || owner.getHoneyCounter() > 0) {
            return false;
        }
        BlockPos blockPosBeehive = owner.m_6274_().m_21952_((MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_BEEHIVE.get()).orElse(null);
        return level.m_7702_(blockPosBeehive) instanceof BeehiveBlockEntity && BeehiveBlockEntity.m_58752_((BlockState)level.m_8055_(blockPosBeehive)) >= 5;
    }
}

