/*
 * Decompiled with CFR 0.152.
 */
package org.primal.entity.ai.behavior.crocodile;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import org.jetbrains.annotations.NotNull;
import org.primal.entity.animal.CrocodileEntity;
import org.primal.registry.Primal_MemoryModuleTypes;

public class CrocodileBasking
extends Behavior<CrocodileEntity> {
    private long endTimestamp = 10L;

    public CrocodileBasking(int defaultDuration) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_ABSENT, (Object)((MemoryModuleType)Primal_MemoryModuleTypes.WAS_BASKING.get()), (Object)MemoryStatus.VALUE_ABSENT), defaultDuration);
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel level, @NotNull CrocodileEntity crocodile) {
        return level.m_46461_() && !crocodile.m_20069_();
    }

    protected boolean canStillUse(@NotNull ServerLevel level, @NotNull CrocodileEntity entity, long gameTime) {
        return level.m_46461_() && this.m_22543_((LivingEntity)entity);
    }

    protected void tick(@NotNull ServerLevel level, @NotNull CrocodileEntity crocodile, long gameTime) {
        crocodile.stopMoving();
    }

    protected void start(@NotNull ServerLevel level, @NotNull CrocodileEntity crocodile, long gameTime) {
        int finalDuration = level.m_213780_().m_216332_(300, 500);
        crocodile.stopMoving();
        crocodile.m_20124_(Pose.CROAKING);
        this.endTimestamp = gameTime + (long)finalDuration;
    }

    protected void stop(@NotNull ServerLevel level, @NotNull CrocodileEntity entity, long gameTime) {
        entity.triggerAnim("base_controller", "basking_end");
        entity.m_20124_(Pose.STANDING);
        entity.m_6274_().m_21882_((MemoryModuleType)Primal_MemoryModuleTypes.WAS_BASKING.get(), (Object)true, 400L);
    }

    protected boolean m_7773_(long gameTime) {
        return gameTime > this.endTimestamp;
    }
}

