/*
 * Decompiled with CFR 0.152.
 */
package org.primal.entity.ai.behavior.shark;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.primal.entity.animal.SharkEntity;

public class SharkJumpOutWater
extends Behavior<SharkEntity> {
    private boolean breached;

    public SharkJumpOutWater() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_PRESENT), 60);
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel level, @NotNull SharkEntity shark) {
        Optional target = shark.m_6274_().m_21952_(MemoryModuleType.f_26372_);
        Direction direction = shark.m_6374_();
        int i = direction.m_122429_();
        int j = direction.m_122431_();
        BlockPos blockpos = shark.m_20183_();
        return target.isPresent() && !((LivingEntity)target.get()).m_20069_() && shark.m_20069_();
    }

    protected boolean canStillUse(@NotNull ServerLevel level, @NotNull SharkEntity entity, long gameTime) {
        return true;
    }

    protected void start(@NotNull ServerLevel level, @NotNull SharkEntity shark, long gameTime) {
        Optional target = shark.m_6274_().m_21952_(MemoryModuleType.f_26372_);
        if (target.isEmpty()) {
            return;
        }
        shark.m_21573_().m_26573_();
        BehaviorUtils.m_22595_((LivingEntity)shark, (LivingEntity)((LivingEntity)target.get()));
    }

    protected void tick(@NotNull ServerLevel level, @NotNull SharkEntity shark, long gameTime) {
    }

    protected void stop(@NotNull ServerLevel level, @NotNull SharkEntity shark, long gameTime) {
        boolean flag = this.breached;
        if (!flag) {
            FluidState fluidstate = shark.m_9236_().m_6425_(shark.m_20183_());
            this.breached = fluidstate.m_205070_(FluidTags.f_13131_);
        }
        Direction direction = shark.m_6374_();
        shark.m_20256_(shark.m_20184_().m_82520_((double)direction.m_122429_() * 0.3, 0.4, (double)direction.m_122431_() * 0.3));
        Vec3 vec3 = shark.m_20184_();
        if (vec3.f_82480_ * vec3.f_82480_ < (double)0.03f && shark.m_146909_() != 0.0f) {
            shark.m_146926_(Mth.m_14189_((float)0.2f, (float)shark.m_146909_(), (float)0.0f));
        } else if (vec3.m_82553_() > (double)1.0E-5f) {
            double d0 = vec3.m_165924_();
            double d1 = Math.atan2(-vec3.f_82480_, d0) * 180.0 / 3.1415927410125732;
            shark.m_146926_((float)d1);
        }
    }

    private boolean waterIsClear(@NotNull SharkEntity shark, BlockPos pos, int dx, int dz, int scale) {
        BlockPos blockpos = pos.m_7918_(dx * scale, 0, dz * scale);
        return shark.m_9236_().m_6425_(blockpos).m_205070_(FluidTags.f_13131_) && !shark.m_9236_().m_8055_(blockpos).m_280555_();
    }

    private boolean surfaceIsClear(@NotNull SharkEntity shark, BlockPos pos, int dx, int dz, int scale) {
        return shark.m_9236_().m_8055_(pos.m_7918_(dx * scale, 1, dz * scale)).m_60795_() && shark.m_9236_().m_8055_(pos.m_7918_(dx * scale, 2, dz * scale)).m_60795_();
    }
}

