/*
 * Decompiled with CFR 0.152.
 */
package org.primal.entity.misc;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public abstract class TamableAnimalExtension
extends TamableAnimal {
    protected TamableAnimalExtension(EntityType<? extends TamableAnimal> type, Level level) {
        super(type, level);
    }

    public boolean shouldTryTeleportToOwner() {
        LivingEntity livingentity = this.m_269323_();
        return livingentity != null && this.m_20280_((Entity)this.m_269323_()) >= 144.0;
    }

    public void tryToTeleportToOwner() {
        LivingEntity livingentity = this.m_269323_();
        if (livingentity != null) {
            this.teleportToAroundBlockPos(livingentity.m_20183_());
        }
    }

    private void teleportToAroundBlockPos(BlockPos arg) {
        for (int i = 0; i < 10; ++i) {
            int j = this.f_19796_.m_216332_(-3, 3);
            int k = this.f_19796_.m_216332_(-3, 3);
            if (Math.abs(j) < 2 && Math.abs(k) < 2) continue;
            int l = this.f_19796_.m_216332_(-1, 1);
            if (!this.maybeTeleportTo(arg.m_123341_() + j, arg.m_123342_() + l, arg.m_123343_() + k)) continue;
            return;
        }
    }

    private boolean maybeTeleportTo(int i, int j, int k) {
        if (!this.canTeleportTo(new BlockPos(i, j, k))) {
            return false;
        }
        this.m_7678_((double)i + 0.5, j, (double)k + 0.5, this.m_146908_(), this.m_146909_());
        this.f_21344_.m_26573_();
        return true;
    }

    private boolean canTeleportTo(BlockPos arg) {
        BlockPathTypes pathtype = WalkNodeEvaluator.m_77604_((BlockGetter)this.m_9236_(), (BlockPos.MutableBlockPos)arg.m_122032_());
        if (pathtype != BlockPathTypes.WALKABLE) {
            return false;
        }
        BlockState blockstate = this.m_9236_().m_8055_(arg.m_7495_());
        if (!this.canFlyToOwner() && blockstate.m_60734_() instanceof LeavesBlock) {
            return false;
        }
        BlockPos blockpos = arg.m_121996_((Vec3i)this.m_20183_());
        return this.m_9236_().m_45756_((Entity)this, this.m_20191_().m_82338_(blockpos));
    }

    protected boolean canFlyToOwner() {
        return false;
    }

    public final boolean unableToMoveToOwner() {
        return this.m_21827_() || this.m_20159_() || this.m_21523_();
    }
}

