/*
 * Decompiled with CFR 0.152.
 */
package org.primal.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.primal.registry.Primal_Sounds;
import org.primal.util.VariantHolderPrimal;

public interface AnimalEgg {
    public static final IntegerProperty HATCH = BlockStateProperties.f_61416_;

    default public void destroyEgg(Level level, BlockState state, BlockPos pos, Entity entity, int chance, Block block, IntegerProperty eggsProperty) {
        if (this.canDestroyEgg(level, entity) && !level.f_46443_ && level.f_46441_.m_188503_(chance) == 0 && state.m_60713_(block)) {
            this.decreaseEggs(level, pos, state, eggsProperty);
        }
    }

    default public void decreaseEggs(Level level, BlockPos pos, BlockState state, IntegerProperty eggsProperty) {
        level.m_5594_(null, pos, (SoundEvent)Primal_Sounds.EGG_BREAK.get(), SoundSource.BLOCKS, 0.7f, 0.9f + level.f_46441_.m_188501_() * 0.2f);
        int i = (Integer)state.m_61143_((Property)eggsProperty);
        if (i <= 1) {
            level.m_46961_(pos, false);
        } else {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)eggsProperty, (Comparable)Integer.valueOf(i - 1)), 2);
            level.m_220407_(GameEvent.f_157794_, pos, GameEvent.Context.m_223722_((BlockState)state));
            level.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
        }
    }

    public RegistryObject<? extends EntityType<? extends Animal>> getAnimal();

    default public void randomTick(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random, IntegerProperty eggsProperty) {
        if (AnimalEgg.shouldUpdateHatchLevel((Level)level)) {
            int i = (Integer)state.m_61143_((Property)HATCH);
            if (i < 2) {
                level.m_5594_(null, pos, (SoundEvent)Primal_Sounds.EGG_CRACK.get(), SoundSource.BLOCKS, 0.7f, 0.9f + random.m_188501_() * 0.2f);
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)HATCH, (Comparable)Integer.valueOf(i + 1)), 2);
                level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223722_((BlockState)state));
            } else {
                level.m_5594_(null, pos, (SoundEvent)Primal_Sounds.EGG_HATCH.get(), SoundSource.BLOCKS, 0.7f, 0.9f + random.m_188501_() * 0.2f);
                level.m_7471_(pos, false);
                level.m_220407_(GameEvent.f_157794_, pos, GameEvent.Context.m_223722_((BlockState)state));
                for (int j = 0; j < (Integer)state.m_61143_((Property)eggsProperty); ++j) {
                    level.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
                    Animal animal = (Animal)((EntityType)this.getAnimal().get()).m_20615_((Level)level);
                    if (animal == null) continue;
                    Holder holder = level.m_204166_(pos);
                    animal.m_146762_(-24000);
                    if (animal instanceof VariantHolderPrimal) {
                        VariantHolderPrimal variantWhenHatches = (VariantHolderPrimal)animal;
                        if (animal instanceof VariantHolder) {
                            VariantHolder variantHolder = (VariantHolder)animal;
                            VariantHolderPrimal variantHolderCast = variantWhenHatches;
                            if (variantHolderCast.getRareVariant(animal) != null && variantWhenHatches.getRareVariantProbability((Level)level)) {
                                variantHolder.m_28464_(variantHolderCast.getRareVariant(animal));
                            } else {
                                variantHolderCast.setVariantFromBiome(animal, (Holder<Biome>)holder);
                            }
                        }
                    }
                    animal.m_7678_((double)pos.m_123341_() + 0.3 + (double)j * 0.2, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.3, 0.0f, 0.0f);
                    level.m_7967_((Entity)animal);
                }
            }
        }
    }

    public static boolean shouldUpdateHatchLevel(Level level) {
        float f = level.m_46942_(1.0f);
        return (double)f < 0.69 && (double)f > 0.65 || level.f_46441_.m_188503_(500) == 0;
    }

    private boolean canDestroyEgg(Level level, Entity entity) {
        if (this.entityCannotDestroyEgg(entity)) {
            return false;
        }
        return entity instanceof LivingEntity && (entity instanceof Player || ForgeEventFactory.getMobGriefingEvent((Level)level, (Entity)entity));
    }

    public boolean entityCannotDestroyEgg(Entity var1);
}

