/*
 * Decompiled with CFR 0.152.
 */
package dev.huey.cloudPack;

import dev.huey.cloudPack.EventManager;
import dev.huey.cloudPack.ItemManager;
import dev.huey.cloudPack.PackSpace;
import dev.huey.cloudPack.Storage;
import dev.huey.cloudPack.Utils;
import java.lang.invoke.CallSite;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Stream;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Wolf;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class CloudPack
extends JavaPlugin
implements CommandExecutor,
TabCompleter {
    Listener eventManager = new EventManager();

    public CloudPack() {
        Storage.plugin = this;
    }

    public void onEnable() {
        ConfigurationSerialization.registerClass(PackSpace.class);
        PluginCommand command = this.getCommand("cloudpack");
        if (command != null) {
            command.setTabCompleter((TabCompleter)this);
            command.setExecutor((CommandExecutor)this);
        }
        this.getServer().getPluginManager().registerEvents(this.eventManager, (Plugin)this);
        ItemManager.registerRecipes();
        Utils.load();
        Utils.startAutoSave();
        this.getLogger().info("Enabled");
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!(sender instanceof Player)) {
            return List.of();
        }
        Player pl = (Player)sender;
        Function<Stream, List> filter = stream -> stream.filter(s -> s.contains(args[args.length - 1])).toList();
        Function<Boolean, List> packLister = includeHeld -> {
            HashSet<CallSite> list = new HashSet<CallSite>(List.of("universal", "personal." + pl.getName()));
            if (includeHeld.booleanValue()) {
                list.add((CallSite)((Object)("held." + pl.getName())));
            }
            for (PackSpace pack : Storage.packs.values()) {
                if (pack.isHeld() || !pack.canSeeBy(pl)) continue;
                list.add((CallSite)((Object)pack.identifier().literal()));
            }
            return (List)filter.apply(list.stream());
        };
        List commands = filter.apply(Stream.of("help", "query", "pull", "push", "transfer", "save"));
        switch (args.length) {
            case 1: {
                return commands;
            }
            case 2: {
                switch (args[0]) {
                    case "help": {
                        return commands;
                    }
                    case "query": {
                        return packLister.apply(true);
                    }
                    case "push": 
                    case "pull": 
                    case "transfer": {
                        return packLister.apply(false);
                    }
                }
                break;
            }
            case 3: {
                switch (args[0]) {
                    case "query": 
                    case "push": 
                    case "pull": {
                        return filter.apply(Storage.allMaterialNames.stream());
                    }
                    case "transfer": {
                        return packLister.apply(false);
                    }
                }
                break;
            }
            case 4: {
                switch (args[0]) {
                    case "push": 
                    case "pull": {
                        return List.of("<amount>");
                    }
                    case "transfer": {
                        return filter.apply(Storage.allMaterialNames.stream());
                    }
                }
                break;
            }
            case 5: {
                switch (args[0]) {
                    case "transfer": {
                        return List.of("<amount>");
                    }
                }
            }
        }
        return List.of();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            return true;
        }
        Player pl = (Player)sender;
        if (args.length < 1) {
            return true;
        }
        Function<String, PackSpace> packFinder = text -> {
            PackSpace.Identifier key = PackSpace.Identifier.from(text);
            if (key == null) {
                Utils.send((Audience)sender, "Invalid pack identifier");
                return null;
            }
            if (!Storage.packs.containsKey(key)) {
                PackSpace created = Utils.createMissingPack(key, pl);
                if (created == null) {
                    Utils.send((Audience)sender, "Can't find the target pack");
                } else {
                    Storage.packs.put(key, created);
                }
                return created;
            }
            return Storage.packs.get(key);
        };
        switch (args[0]) {
            case "help": {
                Utils.send((Audience)sender, "Just imagine!");
                break;
            }
            case "save": {
                if (!pl.isOp()) {
                    Utils.send((Audience)sender, "This command is admins only!");
                    return true;
                }
                Utils.save();
                Utils.send((Audience)sender, "Packs data saved to file!");
                break;
            }
            case "query": {
                if (args.length < 2) {
                    Utils.send((Audience)sender, new Component[]{Component.text((String)"Usage: "), Component.text((String)"/cloudpack query <pack> [material] [count]").color((TextColor)NamedTextColor.GREEN)});
                    return true;
                }
                PackSpace pack = packFinder.apply(args[1]);
                if (pack == null) {
                    return true;
                }
                pack.refresh();
                Map<Material, Long> contents = pack.contents();
                BiConsumer<Material, Long> reporter = (material, count) -> Utils.send((Audience)sender, new Component[]{Component.text((String)"| "), Component.text((String)Utils.formatMaterial(material)).color((TextColor)NamedTextColor.YELLOW), Component.text((String)" \u00d7 "), Component.text((long)count).color((TextColor)NamedTextColor.GOLD)});
                if (args.length >= 3) {
                    Material material2 = Material.matchMaterial((String)args[2]);
                    if (material2 == null) {
                        Utils.send((Audience)sender, "Can't find the material");
                        return true;
                    }
                    Utils.send((Audience)sender, new Component[]{Component.text((String)"In pack "), Component.text((String)args[1]).color((TextColor)NamedTextColor.LIGHT_PURPLE), Component.text((String)":")});
                    reporter.accept(material2, contents.get(material2));
                    break;
                }
                Utils.send((Audience)sender, new Component[]{Component.text((String)"There's "), Component.text((long)pack.totalCount()).color((TextColor)NamedTextColor.GOLD), Component.text((String)" items in pack "), Component.text((String)args[1]).color((TextColor)NamedTextColor.LIGHT_PURPLE), Component.text((String)":")});
                for (Material material3 : contents.keySet()) {
                    reporter.accept(material3, contents.get(material3));
                }
                break;
            }
            case "push": {
                Object packName = args.length < 2 ? "personal." + pl.getName() : args[1];
                PackSpace pack = packFinder.apply((String)packName);
                if (pack == null) {
                    return true;
                }
                if (pack.isHeld()) {
                    Utils.send((Audience)sender, "Held pack isn't a valid target!");
                    return true;
                }
                PackSpace held = Utils.findHeldPack(pl);
                Long maxCount = null;
                if (args.length >= 4) {
                    try {
                        maxCount = Long.parseLong(args[3]);
                    }
                    catch (NumberFormatException material3) {
                        // empty catch block
                    }
                }
                long count2 = held.transferTo(pack, args.length < 3 ? null : Material.matchMaterial((String)args[2]), maxCount);
                Utils.putPack(held);
                Utils.putPack(pack);
                Utils.send((Audience)sender, new Component[]{Component.text((String)"Pushed "), Component.text((long)count2).color((TextColor)NamedTextColor.GOLD), Component.text((String)" items to "), Component.text((String)packName).color((TextColor)NamedTextColor.LIGHT_PURPLE), Component.text((String)"")});
                break;
            }
            case "pull": {
                Object packName = args.length < 2 ? "personal." + pl.getName() : args[1];
                PackSpace pack = packFinder.apply((String)packName);
                if (pack == null) {
                    return true;
                }
                if (pack.isHeld()) {
                    Utils.send((Audience)sender, "Held pack isn't a valid target!");
                    return true;
                }
                PackSpace held = Utils.findHeldPack(pl);
                Long maxCount2 = null;
                if (args.length >= 4) {
                    try {
                        maxCount2 = Long.parseLong(args[3]);
                    }
                    catch (NumberFormatException count2) {
                        // empty catch block
                    }
                }
                long count3 = pack.transferTo(held, args.length < 3 ? null : Material.matchMaterial((String)args[2]), maxCount2);
                Utils.putPack(held);
                Utils.putPack(pack);
                Utils.send((Audience)sender, new Component[]{Component.text((String)"Pulled "), Component.text((long)count3).color((TextColor)NamedTextColor.GOLD), Component.text((String)" items from "), Component.text((String)packName).color((TextColor)NamedTextColor.LIGHT_PURPLE), Component.text((String)"")});
                break;
            }
            case "transfer": {
                if (args.length < 3) {
                    Utils.send((Audience)sender, new Component[]{Component.text((String)"Usage: "), Component.text((String)"/cloudpack transfer <origin> <destination> [material] [count]").color((TextColor)NamedTextColor.GREEN)});
                    return true;
                }
                PackSpace origin = packFinder.apply(args[1]);
                PackSpace destin = packFinder.apply(args[2]);
                if (origin.isHeld() || destin.isHeld()) {
                    Utils.send((Audience)sender, "Held pack isn't a valid target!");
                    return true;
                }
                Long maxCount = null;
                if (args.length >= 5) {
                    try {
                        maxCount = Long.parseLong(args[4]);
                    }
                    catch (NumberFormatException maxCount2) {
                        // empty catch block
                    }
                }
                long count4 = origin.transferTo(destin, args.length < 4 ? null : Material.matchMaterial((String)args[3]), maxCount);
                Utils.putPack(origin);
                Utils.putPack(destin);
                Utils.send((Audience)sender, new Component[]{Component.text((String)"Transferred "), Component.text((long)count4).color((TextColor)NamedTextColor.GOLD), Component.text((String)" items from "), Component.text((String)args[1]).color((TextColor)NamedTextColor.LIGHT_PURPLE), Component.text((String)" to "), Component.text((String)args[2]).color((TextColor)NamedTextColor.LIGHT_PURPLE), Component.text((String)"")});
                break;
            }
            case "spawndogs": {
                if (!pl.isOp()) {
                    return true;
                }
                for (double a = 0.0; a < Math.PI * 2; a += 0.7853981633974483) {
                    Location loc = pl.getLocation().add(Math.cos(a) * 4.0, 0.0, Math.sin(a) * 4.0);
                    while (!loc.getWorld().getBlockAt(loc).isEmpty()) {
                        loc.add(0.0, 1.0, 0.0);
                    }
                    Wolf dog = (Wolf)loc.getWorld().spawnEntity(loc, EntityType.WOLF);
                    dog.setVariant(Utils.pick(List.of(Wolf.Variant.PALE, Wolf.Variant.SPOTTED, Wolf.Variant.SNOWY, Wolf.Variant.BLACK, Wolf.Variant.ASHEN, Wolf.Variant.RUSTY, Wolf.Variant.WOODS, Wolf.Variant.CHESTNUT, Wolf.Variant.STRIPED)));
                    dog.setOwner((AnimalTamer)pl);
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + args[0]);
            }
        }
        return true;
    }

    public void onDisable() {
        Utils.save();
        this.getLogger().info("Disabled");
    }
}

