/*
 * Decompiled with CFR 0.152.
 */
package dev.huey.cloudPack;

import dev.huey.cloudPack.Storage;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;

public class ItemManager {
    static final String uploaderDesc = "Upload container contents to the cloud";
    static final String downloaderDesc = "Download cloud contents to containers";

    static ItemStack getUploader() {
        ItemStack itemStack = new ItemStack(Material.SNOWBALL);
        itemStack.editMeta(meta -> {
            meta.setEnchantmentGlintOverride(Boolean.valueOf(true));
            meta.itemName(Component.text((String)"Cloud Pack Uploader").color((TextColor)NamedTextColor.AQUA));
            meta.lore(List.of((TextComponent)Component.text((String)uploaderDesc).color((TextColor)NamedTextColor.DARK_PURPLE)));
        });
        return itemStack;
    }

    static ItemStack getDownloader() {
        ItemStack itemStack = new ItemStack(Material.ENDER_EYE);
        itemStack.editMeta(meta -> {
            meta.setEnchantmentGlintOverride(Boolean.valueOf(true));
            meta.itemName(Component.text((String)"Cloud Pack Downloader").color((TextColor)NamedTextColor.BLUE));
            meta.lore(List.of((TextComponent)Component.text((String)downloaderDesc).color((TextColor)NamedTextColor.DARK_PURPLE)));
        });
        return itemStack;
    }

    static boolean compareLore(ItemStack itemStack, String lore) {
        if (itemStack == null || itemStack.lore() == null || itemStack.lore().isEmpty()) {
            return false;
        }
        return itemStack.lore().stream().anyMatch(c -> {
            TextComponent tc;
            return c instanceof TextComponent && (tc = (TextComponent)c).content().equals(lore);
        });
    }

    static boolean isUploader(ItemStack itemStack) {
        return ItemManager.compareLore(itemStack, uploaderDesc);
    }

    static boolean isDownloader(ItemStack itemStack) {
        return ItemManager.compareLore(itemStack, downloaderDesc);
    }

    static void registerRecipes() {
        Bukkit.getServer().addRecipe((Recipe)new ShapedRecipe(new NamespacedKey(Storage.plugin.getName().toLowerCase(), "uploader"), ItemManager.getUploader()).shape(new String[]{" E ", " S ", " S "}).setIngredient('E', (RecipeChoice)new RecipeChoice.MaterialChoice(Material.EMERALD)).setIngredient('S', (RecipeChoice)new RecipeChoice.MaterialChoice(Material.STICK)));
        Bukkit.getServer().addRecipe((Recipe)new ShapedRecipe(new NamespacedKey(Storage.plugin.getName().toLowerCase(), "downloader"), ItemManager.getDownloader()).shape(new String[]{" S ", " S ", " E "}).setIngredient('E', (RecipeChoice)new RecipeChoice.MaterialChoice(Material.EMERALD)).setIngredient('S', (RecipeChoice)new RecipeChoice.MaterialChoice(Material.STICK)));
    }
}

