/*
 * Decompiled with CFR 0.152.
 */
package dev.huey.cloudPack;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.ShulkerBox;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class PackSpace
implements ConfigurationSerializable {
    private final Identifier identifier;
    private final UUID ownerId;
    private final List<UUID> sharedIds;
    private final Long limit;
    private long totalCount = 0L;
    private Map<Material, Long> contents = new HashMap<Material, Long>();

    @NotNull
    public Map<String, Object> serialize() {
        this.refresh();
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("identifier", this.identifier.literal());
        if (this.hasOwner()) {
            data.put("ownerId", this.ownerId.toString());
        }
        if (this.isShared()) {
            data.put("sharedIds", this.sharedIds.stream().map(UUID::toString).toList());
        }
        if (this.hasLimit()) {
            data.put("limit", this.limit);
        }
        HashMap<String, Long> contentsSerialized = new HashMap<String, Long>();
        for (Map.Entry<Material, Long> entry : this.contents.entrySet()) {
            contentsSerialized.put(entry.getKey().name(), entry.getValue());
        }
        data.put("contents", contentsSerialized);
        return data;
    }

    public static PackSpace deserialize(Map<String, Object> data) {
        Identifier identifier = Identifier.from((String)data.get("identifier"));
        UUID ownerId = data.containsKey("ownerId") ? UUID.fromString((String)data.get("ownerId")) : null;
        List<UUID> sharedIds = data.containsKey("sharedIds") ? ((List)data.get("sharedIds")).stream().map(UUID::fromString).toList() : null;
        Long limit = data.containsKey("limit") ? Long.valueOf(((Number)data.get("limit")).longValue()) : null;
        Map contentsMap = (Map)data.get("contents");
        HashMap<Material, Long> contents = new HashMap<Material, Long>();
        for (Map.Entry entry : contentsMap.entrySet()) {
            contents.put(Material.valueOf((String)((String)entry.getKey())), ((Number)entry.getValue()).longValue());
        }
        PackSpace packSpace = new PackSpace(identifier, limit, ownerId, sharedIds);
        packSpace.contents = contents;
        packSpace.refresh();
        return packSpace;
    }

    PackSpace(Identifier identifier, Long limit, UUID ownerId, List<UUID> sharedIds) {
        this.identifier = identifier;
        this.limit = limit;
        this.ownerId = ownerId;
        this.sharedIds = sharedIds;
    }

    PackSpace(Identifier identifier, Long limit, UUID ownerId) {
        this(identifier, limit, ownerId, null);
    }

    PackSpace(Identifier identifier, Long limit) {
        this(identifier, limit, null);
    }

    PackSpace(Identifier identifier) {
        this(identifier, null);
    }

    static PackSpace universal() {
        return new PackSpace(Identifier.universal());
    }

    static PackSpace group(String name, UUID ownerId, List<UUID> sharedIds) {
        return new PackSpace(Identifier.group(name), 0x200000L, ownerId, sharedIds);
    }

    static PackSpace group(String name, Player owner, List<Player> sharedIds) {
        return PackSpace.group(name, owner.getUniqueId(), sharedIds.stream().map(Entity::getUniqueId).toList());
    }

    static PackSpace group(String name, UUID ownerId) {
        return PackSpace.group(name, ownerId, List.of());
    }

    static PackSpace group(String name, Player owner) {
        return PackSpace.group(name, owner.getUniqueId());
    }

    static PackSpace personal(OfflinePlayer pl) {
        return new PackSpace(Identifier.personal(pl.getName()), 0x200000L, pl.getUniqueId());
    }

    static PackSpace personal(UUID ownerId) {
        return PackSpace.personal(Bukkit.getOfflinePlayer((UUID)ownerId));
    }

    static PackSpace held(OfflinePlayer pl) {
        return new PackSpace(Identifier.held(pl.getName()), 8192L, pl.getUniqueId());
    }

    static PackSpace held(UUID ownerId) {
        return PackSpace.held(Bukkit.getOfflinePlayer((UUID)ownerId));
    }

    static PackSpace from(Identifier identifier, UUID ownerId) {
        PackSpace pack = null;
        switch (identifier.type().ordinal()) {
            case 0: {
                pack = PackSpace.universal();
                break;
            }
            case 1: {
                pack = PackSpace.group(identifier.name, ownerId);
                break;
            }
            case 2: {
                OfflinePlayer offPl = Bukkit.getOfflinePlayer((String)identifier.name);
                if (!offPl.hasPlayedBefore()) break;
                pack = PackSpace.personal(offPl.getUniqueId());
                break;
            }
            case 3: {
                pack = PackSpace.held(ownerId);
            }
        }
        return pack;
    }

    public Identifier identifier() {
        return this.identifier;
    }

    public boolean isHeld() {
        return this.identifier.type().equals((Object)Identifier.Type.HELD);
    }

    public UUID ownerId() {
        return this.ownerId;
    }

    public List<UUID> sharedIds() {
        return this.sharedIds;
    }

    public Long limit() {
        return this.limit;
    }

    public boolean hasOwner() {
        return this.ownerId != null;
    }

    public boolean isShared() {
        return this.sharedIds != null;
    }

    public boolean hasLimit() {
        return this.limit != null;
    }

    public long totalCount() {
        return this.totalCount;
    }

    public boolean isFull() {
        return this.hasLimit() && this.totalCount >= this.limit;
    }

    public Map<Material, Long> contents() {
        return this.contents;
    }

    boolean canSeeBy(UUID playerId) {
        return !this.hasOwner() || this.ownerId.equals(playerId) || this.sharedIds.contains(playerId);
    }

    boolean canSeeBy(Player pl) {
        return this.canSeeBy(pl.getUniqueId());
    }

    boolean hasSpaceFor(long amount) {
        return !this.hasLimit() || this.totalCount + amount <= this.limit;
    }

    boolean hasSpaceForAll(Map<Material, Long> addingContents) {
        return this.totalCount + addingContents.values().stream().mapToLong(Long::longValue).sum() <= this.limit;
    }

    void refresh() {
        this.contents.entrySet().removeIf(entry -> (Long)entry.getValue() <= 0L);
        this.totalCount = 0L;
        for (long count : this.contents.values()) {
            this.totalCount += count;
        }
    }

    void forceAdd(Material type, long amount) {
        this.totalCount += amount;
        this.contents.put(type, this.contents.getOrDefault(type, 0L) + amount);
    }

    public long add(Material type, long amount) {
        if (!this.hasSpaceFor(amount)) {
            long leftCount = this.totalCount + amount - this.limit;
            this.add(type, this.limit - this.totalCount);
            return leftCount;
        }
        this.forceAdd(type, amount);
        return 0L;
    }

    public Map<Material, Long> addAll(Map<Material, Long> addingContents) {
        for (Material type : addingContents.keySet()) {
            long leftoverCount = this.add(type, addingContents.get(type));
            addingContents.put(type, leftoverCount);
            if (leftoverCount <= 0L) continue;
            break;
        }
        return addingContents;
    }

    public Map<Material, Long> empty() {
        HashMap<Material, Long> contentsClone = new HashMap<Material, Long>(this.contents);
        this.contents.clear();
        return contentsClone;
    }

    public long transferTo(PackSpace that, Material material, Long maxCount) {
        long oldCount = this.totalCount;
        if (material == null) {
            Map<Material, Long> movingContents = this.empty();
            this.contents = that.addAll(movingContents);
        } else {
            long count = this.contents.getOrDefault(material, 0L);
            if (maxCount != null && maxCount < count) {
                long leftCount = that.add(material, maxCount);
                this.contents.put(material, count - maxCount + leftCount);
            } else {
                long leftCount = that.add(material, count);
                this.contents.put(material, leftCount);
            }
        }
        this.refresh();
        return oldCount - this.totalCount;
    }

    public long takeFromInventory(Inventory inventory) {
        long oldCount = this.totalCount;
        Map<Material, Long> inventoryContents = new HashMap<Material, Long>();
        for (ItemStack itemStack : inventory.getContents()) {
            BlockStateMeta bsm;
            ItemMeta itemMeta;
            if (itemStack == null || itemStack.getType().isAir() || itemStack.hasItemMeta() && itemStack.getItemMeta().hasDisplayName() || itemStack.hasItemMeta() && (itemMeta = itemStack.getItemMeta()) instanceof BlockStateMeta && (bsm = (BlockStateMeta)itemMeta).getBlockState() instanceof ShulkerBox) continue;
            inventoryContents.put(itemStack.getType(), inventoryContents.getOrDefault(itemStack.getType(), 0L) + (long)itemStack.getAmount());
            inventory.removeItem(new ItemStack[]{itemStack});
        }
        inventoryContents = this.addAll(inventoryContents);
        inventoryContents.forEach((m, c) -> {
            if (c > 0L) {
                inventory.addItem(new ItemStack[]{new ItemStack(m, Math.toIntExact(c))});
            }
        });
        return this.totalCount - oldCount;
    }

    public long putToInventory(Inventory inventory) {
        for (Material material : this.contents.keySet()) {
            long amount = this.contents.get(material);
            if (amount <= 0L) continue;
            HashMap leftover = inventory.addItem(new ItemStack[]{new ItemStack(material, Math.toIntExact(amount))});
            this.contents.put(material, 0L);
            leftover.values().forEach(stack -> this.contents.put(stack.getType(), this.contents.getOrDefault(stack.getType(), 0L) + (long)stack.getAmount()));
        }
        long oldCount = this.totalCount;
        this.refresh();
        return oldCount - this.totalCount;
    }

    public record Identifier(Type type, String name) {
        static Identifier universal() {
            return new Identifier(Type.UNIVERSAL, "universal");
        }

        static Identifier group(String id) {
            return new Identifier(Type.GROUP, id);
        }

        static Identifier personal(String id) {
            return new Identifier(Type.PERSONAL, id);
        }

        static Identifier personal(Player pl) {
            return Identifier.personal(pl.getName());
        }

        static Identifier held(String id) {
            return new Identifier(Type.HELD, id);
        }

        static Identifier held(Player pl) {
            return Identifier.held(pl.getName());
        }

        static Identifier from(String string) {
            if (string.equals("universal")) {
                return Identifier.universal();
            }
            String[] parts = string.split("\\.");
            if (parts.length != 2) {
                return null;
            }
            switch (parts[0]) {
                case "group": {
                    return Identifier.group(parts[1]);
                }
                case "personal": {
                    return Identifier.personal(parts[1]);
                }
                case "held": {
                    return Identifier.held(parts[1]);
                }
            }
            return null;
        }

        String literal() {
            Object literalType = "";
            switch (this.type.ordinal()) {
                case 0: {
                    return "universal";
                }
                case 1: {
                    literalType = (String)literalType + "group";
                    break;
                }
                case 2: {
                    literalType = (String)literalType + "personal";
                    break;
                }
                case 3: {
                    literalType = (String)literalType + "held";
                }
            }
            return (String)literalType + "." + this.name;
        }

        static enum Type {
            UNIVERSAL,
            GROUP,
            PERSONAL,
            HELD;

        }
    }
}

