/*
 * Decompiled with CFR 0.152.
 */
package dev.huey.cloudPack;

import dev.huey.cloudPack.PackSpace;
import dev.huey.cloudPack.Storage;
import java.io.File;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class Utils {
    private static final SecureRandom random = new SecureRandom();

    public static <T> T pick(List<T> list) {
        int x = random.nextInt(list.size());
        return list.get(x);
    }

    public static String firstUpperCase(String text) {
        switch (text) {
            case "of": 
            case "to": 
            case "the": 
            case "a": 
            case "an": 
            case "and": 
            case "but": 
            case "or": 
            case "nor": 
            case "for": 
            case "so": 
            case "yet": 
            case "at": 
            case "by": 
            case "in": 
            case "on": 
            case "up": 
            case "off": 
            case "out": 
            case "over": 
            case "with": 
            case "as": {
                return text;
            }
        }
        return text.substring(0, 1).toUpperCase() + text.substring(1).toLowerCase();
    }

    public static String formatMaterial(Material material) {
        return String.join((CharSequence)" ", Stream.of(material.name().split("_")).map(Utils::firstUpperCase).toList());
    }

    public static void send(Audience target, Component ... content) {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add(Storage.chatPrefix);
        list.addAll(List.of(content));
        target.sendMessage(Component.join((JoinConfiguration)JoinConfiguration.noSeparators(), list).colorIfAbsent((TextColor)NamedTextColor.GRAY));
    }

    public static void send(Audience target, String text) {
        Utils.send(target, new Component[]{Component.text((String)text)});
    }

    public static PackSpace findHeldPack(Player pl) {
        PackSpace.Identifier identifier = PackSpace.Identifier.held(pl);
        if (!Storage.packs.containsKey(identifier)) {
            Utils.putPack(Utils.createPack(identifier, pl));
        }
        return Storage.packs.get(identifier);
    }

    public static PackSpace createPack(PackSpace.Identifier identifier, UUID playerId) {
        PackSpace pack = PackSpace.from(identifier, playerId);
        if (pack != null) {
            Storage.packs.put(identifier, pack);
        }
        return pack;
    }

    public static PackSpace createPack(PackSpace.Identifier identifier, Player pl) {
        return Utils.createPack(identifier, pl.getUniqueId());
    }

    public static PackSpace createMissingPack(PackSpace.Identifier identifier, Player pl) {
        if (identifier.type().equals((Object)PackSpace.Identifier.Type.GROUP)) {
            return null;
        }
        return Utils.createPack(identifier, pl);
    }

    public static void putPack(PackSpace pack) {
        Storage.packs.put(pack.identifier(), pack);
    }

    public static void save() {
        File file = new File(Storage.plugin.getDataFolder().getAbsolutePath(), "data.yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        config.set("packs", Storage.packs.values().stream().filter(p -> !p.contents().isEmpty()).toList());
        try {
            config.save(file);
        }
        catch (IOException e) {
            Storage.plugin.getLogger().warning("Cannot save data!");
        }
    }

    public static void load() {
        File file = new File(Storage.plugin.getDataFolder().getAbsolutePath(), "data.yml");
        if (!file.exists()) {
            return;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        for (PackSpace pack : (List)config.get("packs")) {
            Storage.packs.put(pack.identifier(), pack);
        }
    }

    public static void startAutoSave() {
        Bukkit.getScheduler().runTaskTimer((Plugin)Storage.plugin, Utils::save, 0L, 6000L);
    }
}

